/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.engine.sampleclient;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import org.ow2.petals.engine.sampleclient.Utils;
import org.ow2.petals.engine.sampleclient.gui.Console;

public class SampleClientListener
implements Runnable {
    private DeliveryChannel channel;
    private MessageExchange messageExchange;
    private boolean running = true;
    private Console console;
    private Logger logger;

    public SampleClientListener(DeliveryChannel channel, Console c, Logger log) {
        this.channel = channel;
        this.console = c;
        this.logger = log;
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                this.messageExchange = this.channel.accept();
                if (this.messageExchange == null) continue;
                this.process(this.messageExchange);
            }
            catch (MessagingException e) {
                Throwable cause = e;
                while (cause != null) {
                    this.logger.info("Exception when accepting messages :" + cause.getClass().getName() + " " + cause.getMessage());
                    if (!((cause = cause.getCause()) instanceof InterruptedException)) continue;
                    this.logger.severe("Thread interrupted, stop listening.");
                    this.running = false;
                }
                this.logger.severe(e.getMessage());
            }
        }
    }

    public void process(MessageExchange msg) {
        this.logger.log(Level.INFO, "Processing received message " + msg.getExchangeId());
        String response = null;
        HashMap<String, String> properties = null;
        if (ExchangeStatus.DONE.equals(msg.getStatus())) {
            response = "receive a DONE status.";
        } else if (ExchangeStatus.ERROR.equals(msg.getStatus())) {
            response = "receive an ERROR status :" + msg.getError().getMessage();
        } else {
            try {
                if (msg.getMessage("OUT") != null && msg.getMessage("OUT").getContent() != null) {
                    response = Utils.createString(msg.getMessage("OUT").getContent());
                    if (!msg.getMessage("OUT").getAttachmentNames().isEmpty()) {
                        this.logger.log(Level.INFO, msg.getMessage("OUT").getAttachmentNames().size() + " attachment(s) found : " + msg.getMessage("OUT").getAttachmentNames());
                        String folder = this.console.saveFolder();
                        for (Object object : msg.getMessage("OUT").getAttachmentNames()) {
                            String attachmentName = (String)object;
                            FileOutputStream fos = new FileOutputStream(folder + File.separator + attachmentName);
                            DataHandler data = msg.getMessage("OUT").getAttachment(attachmentName);
                            data.writeTo((OutputStream)fos);
                            fos.flush();
                            fos.close();
                        }
                    }
                } else if (msg.getFault() != null) {
                    response = "FAULT : " + Utils.createString(msg.getFault().getContent());
                }
                if (msg.getPropertyNames() != null && msg.getPropertyNames().size() > 0) {
                    properties = new HashMap<String, String>();
                    Set names = msg.getPropertyNames();
                    for (String name : names) {
                        properties.put(name, String.valueOf(msg.getProperty(name)));
                    }
                }
                msg.setStatus(ExchangeStatus.DONE);
                this.channel.send(msg);
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, e.getClass() + ":" + e.getMessage());
                response = e.getMessage();
            }
        }
        if (properties != null) {
            this.console.setResponse(response, properties);
        } else {
            this.console.setResponse(response);
        }
    }

    public void stopProcessing() {
        this.running = false;
    }
}

