/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.engine.sampleclient.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.ow2.petals.engine.sampleclient.PropertiesRequestBeanRW;
import org.ow2.petals.engine.sampleclient.RequestBean;
import org.ow2.petals.engine.sampleclient.SampleClient;
import org.ow2.petals.engine.sampleclient.gui.model.ServiceListRenderer;

public class Console
extends JFrame {
    private static final long serialVersionUID = -8117896325113377153L;
    private JButton asreference;
    private JLabel background;
    private JLabel background1;
    private JPanel botQueryPanel;
    private JTextField endpoint;
    private JTextArea in;
    private JRadioButton inout;
    private JRadioButton inoutopt;
    private JTextField interfaceName;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton31;
    private JButton jButtonAddAttachments;
    private JButton jButtonRemoveAttachments;
    private JFileChooser jFileChooserAttachment;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel2b;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel8;
    private JLabel jLabel81;
    private JLabel jLabelItf;
    private JList jList1;
    private DefaultListModel jListModelSelectedAttachments;
    private JList jListSelectedAttachments;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanelAttachment;
    private JRadioButton inonly;
    private JScrollPane jScrollPane = null;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSeparator jSeparator1;
    private JTabbedPane jTabbedPane1;
    private JTextArea jTextArea1;
    private JPanel midQueryPanel;
    private JTextField operation;
    private JTextArea out;
    private JLabel propJLabel = null;
    private JTextArea props = null;
    private JPanel queryPanel;
    private JButton resolve;
    private JRadioButton robustin;
    private SampleClient sampleClient;
    private JPanel sendPanel;
    private JButton sendSync;
    private JTextField service;
    private ServiceEndpoint[] services;
    private JScrollPane servicesScrollPanel;
    private JTextField timeout;
    private JPanel topQueryPanel;
    private ButtonGroup typeGroup;

    private static void lockInMinSize(final JFrame frame) {
        final int origX = frame.getSize().width;
        final int origY = frame.getSize().height;
        frame.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent event) {
                int X = frame.getWidth() < origX ? origX : frame.getWidth();
                int Y = frame.getHeight() < origY ? origY : frame.getHeight();
                frame.setSize(X, Y);
            }
        });
    }

    public Console() {
        this.initialize();
        this.initGUI();
    }

    public Console(SampleClient sampleClient) {
        this();
        this.sampleClient = sampleClient;
    }

    private void getAsReference() {
        ServiceEndpoint se = this.services[this.jList1.getSelectedIndex()];
        String msg = this.sampleClient.getAsReference(se);
        this.openDialogBox("Reference of " + se, msg);
    }

    private List<File> getAttachmentFiles() {
        ArrayList<File> attachmentFiles = new ArrayList<File>();
        Enumeration attachmentEnum = this.jListModelSelectedAttachments.elements();
        while (attachmentEnum.hasMoreElements()) {
            Object attachment = attachmentEnum.nextElement();
            if (!(attachment instanceof File)) continue;
            attachmentFiles.add((File)attachment);
        }
        return attachmentFiles;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setBounds(new Rectangle(5, 281, 576, 64));
            this.jScrollPane.setViewportView(this.getProps());
        }
        return this.jScrollPane;
    }

    private JLabel getPropJLabel() {
        if (this.propJLabel == null) {
            this.propJLabel = new JLabel();
            this.propJLabel.setBounds(new Rectangle(5, 258, 576, 13));
            this.propJLabel.setText("Properties");
        }
        return this.propJLabel;
    }

    private JTextArea getProps() {
        if (this.props == null) {
            this.props = new JTextArea();
        }
        return this.props;
    }

    private void getServices() {
        ServiceEndpoint[] se = this.sampleClient.getEndpoints();
        this.services = se;
        DefaultListModel<JLabel> listModel = new DefaultListModel<JLabel>();
        this.jList1.setCellRenderer(new ServiceListRenderer(this.jList1.getCellRenderer()));
        for (int i = 0; i < se.length; ++i) {
            String name = se[i].toString();
            JLabel label = new JLabel();
            label.setText(name);
            label.setToolTipText("Click to select in the Send Panel");
            label.addMouseListener(new ServiceSelector(name));
            listModel.addElement(label);
        }
        this.jList1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && Console.this.jList1.getSelectedValue() != null) {
                    JLabel label = (JLabel)Console.this.jList1.getSelectedValue();
                    String name = label.getText();
                    if (name.indexOf(" ") > -1) {
                        name = name.substring(0, name.indexOf(" "));
                    }
                    Console.this.interfaceName.setText("");
                    Console.this.service.setText(name);
                    String endpointName = label.getText().substring(label.getText().indexOf("->") + 2);
                    endpointName = endpointName.substring(0, endpointName.indexOf(" "));
                    Console.this.endpoint.setText(endpointName);
                    Console.this.jTabbedPane1.setSelectedIndex(0);
                }
            }
        });
        this.jList1.setModel(listModel);
        if (se.length > 0) {
            this.jList1.setSelectedIndex(0);
        }
    }

    private MenuBar initMenu() {
        MenuBar menuBar = new MenuBar();
        Menu menu = new Menu("File");
        MenuItem load = new MenuItem("Load request");
        final JFileChooser choose = new JFileChooser();
        choose.setDialogTitle("Select request file to load");
        choose.setFileSelectionMode(0);
        choose.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().endsWith("properties");
            }

            @Override
            public String getDescription() {
                return null;
            }
        });
        load.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int res = choose.showOpenDialog(Console.this);
                if (res == 0) {
                    File f = choose.getSelectedFile();
                    PropertiesRequestBeanRW reader = new PropertiesRequestBeanRW();
                    Properties props = new Properties();
                    try {
                        props.load(new FileInputStream(f));
                        RequestBean bean = reader.read(props);
                        Console.this.updateConsole(bean);
                    }
                    catch (FileNotFoundException e1) {
                        e1.printStackTrace();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        menu.add(load);
        MenuItem save = new MenuItem("Save request");
        final JFileChooser chooseSave = new JFileChooser();
        chooseSave.setDialogTitle("Select the folder to save request to...");
        chooseSave.setFileSelectionMode(1);
        save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int res = chooseSave.showOpenDialog(Console.this);
                if (res == 0) {
                    File folder = chooseSave.getSelectedFile();
                    Date d = new Date(System.currentTimeMillis());
                    SimpleDateFormat sdf = new SimpleDateFormat("ddMMyy-HHmmss");
                    File f = new File(folder, "petals-client-request-" + sdf.format(d) + ".properties");
                    PropertiesRequestBeanRW writer = new PropertiesRequestBeanRW();
                    Properties props = new Properties();
                    writer.write(Console.this.getRequestBean(), props);
                    try {
                        props.store(new FileOutputStream(f), "Stored on " + sdf.format(d));
                    }
                    catch (FileNotFoundException e1) {
                        e1.printStackTrace();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        menu.add(save);
        menuBar.add(menu);
        Menu help = new Menu("?");
        MenuItem about = new MenuItem("About");
        about.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        help.add(about);
        menuBar.add(help);
        return menuBar;
    }

    private void updateConsole(RequestBean request) {
        if (request.getMessage() != null) {
            this.in.setText(request.getMessage());
        }
        if (request.getInterfaceName() != null) {
            this.interfaceName.setText(request.getInterfaceName());
        }
        if (request.getServiceName() != null) {
            this.service.setText(request.getServiceName());
        }
        if (request.getEndpointName() != null) {
            this.endpoint.setText(request.getEndpointName());
        }
        if (request.getTimeout() != null) {
            this.timeout.setText(request.getTimeout());
        }
        if (request.getProperties() != null) {
            this.props.setText(request.getProperties());
        }
        if (request.getOperation() != null) {
            this.operation.setText(request.getOperation());
        }
        if (request.getMep() != null) {
            if (request.getMep().equalsIgnoreCase("InOut")) {
                this.inout.setSelected(true);
            } else if (request.getMep().equalsIgnoreCase("InOnly")) {
                this.inonly.setSelected(true);
            } else if (request.getMep().equalsIgnoreCase("InOptionalOut")) {
                this.inoutopt.setSelected(true);
            } else if (request.getMep().equalsIgnoreCase("RobustInOnly")) {
                this.robustin.setSelected(true);
            }
        }
    }

    private RequestBean getRequestBean() {
        RequestBean bean = new RequestBean();
        bean.setEndpointName(this.endpoint.getText());
        bean.setInterfaceName(this.interfaceName.getText());
        bean.setMep(this.getMep());
        bean.setMessage(this.in.getText());
        bean.setOperation(this.operation.getText());
        bean.setProperties(this.props.getText());
        bean.setServiceName(this.service.getText());
        bean.setTimeout(this.timeout.getText());
        return bean;
    }

    private String getMep() {
        String result = null;
        AbstractButton selected = null;
        Enumeration<AbstractButton> rbs = this.typeGroup.getElements();
        while (rbs.hasMoreElements()) {
            AbstractButton but = rbs.nextElement();
            if (!but.isSelected()) continue;
            selected = (JRadioButton)but;
        }
        if (selected != null) {
            result = selected.getText();
        }
        return result;
    }

    private void initGUI() {
        try {
            ImageIcon img1;
            DataInputStream dis;
            MenuBar menuBar = this.initMenu();
            this.setMenuBar(menuBar);
            GridLayout gridLayout1 = new GridLayout();
            gridLayout1.setRows(2);
            GridLayout gridLayout = new GridLayout();
            gridLayout.setRows(4);
            this.setDefaultCloseOperation(0);
            this.jTabbedPane1 = new JTabbedPane();
            this.getContentPane().add(this.jTabbedPane1);
            this.jTabbedPane1.setSize(592, 758);
            this.sendPanel = new JPanel();
            byte[] buffer = null;
            InputStream inStream = this.getClass().getResourceAsStream("/ebmlogo.jpg");
            try {
                if (inStream == null) {
                    inStream = new FileInputStream("src" + File.separator + "img" + File.separator + "ebmlogo.jpg");
                }
                dis = new DataInputStream(inStream);
                buffer = new byte[dis.available()];
                dis.readFully(buffer);
                img1 = new ImageIcon(buffer);
                this.background = new JLabel(img1);
                this.background.setBounds(360, 640, img1.getIconWidth(), img1.getIconHeight());
                this.sendPanel.add(this.background);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, e.getMessage(), "Error", 0);
            }
            this.sendPanel.setLayout(null);
            this.jTabbedPane1.addTab("Send", null, this.sendPanel, null);
            this.sendPanel.setOpaque(false);
            this.typeGroup = new ButtonGroup();
            this.jPanel1 = new JPanel();
            this.jPanel1.setLayout(gridLayout);
            this.jPanel1.setBounds(new Rectangle(0, 0, 586, 90));
            this.jPanel1.setBorder(BorderFactory.createTitledBorder("Service"));
            this.jPanel1.setOpaque(false);
            this.jLabelItf = new JLabel();
            this.jLabelItf.setText("Interface");
            this.interfaceName = new JTextField();
            this.interfaceName.setText("{http://petals.ow2.org}Clock");
            this.jLabel1 = new JLabel();
            this.jLabel1.setText("Service");
            this.service = new JTextField();
            this.jLabel2 = new JLabel();
            this.jLabel2.setText("Operation");
            this.jLabel2b = new JLabel();
            this.jLabel2b.setText("Endpoint");
            this.endpoint = new JTextField();
            this.operation = new JTextField();
            this.jPanel1.add((Component)this.jLabelItf, null);
            this.jPanel1.add((Component)this.interfaceName, null);
            this.jPanel1.add((Component)this.jLabel1, null);
            this.jPanel1.add((Component)this.service, null);
            this.jPanel1.add((Component)this.jLabel2b, null);
            this.jPanel1.add((Component)this.endpoint, null);
            this.jPanel1.add((Component)this.jLabel2, null);
            this.jPanel1.add((Component)this.operation, null);
            this.operation.setText("printTime");
            this.jPanelAttachment = new JPanel(new BorderLayout());
            this.jPanelAttachment.setBounds(new Rectangle(0, 85, 586, 95));
            this.jPanelAttachment.setBorder(BorderFactory.createTitledBorder("Attachments"));
            this.jPanelAttachment.setOpaque(false);
            this.jListSelectedAttachments = new JList();
            this.jListSelectedAttachments.setSelectionMode(2);
            this.jListModelSelectedAttachments = new DefaultListModel();
            this.jListSelectedAttachments.setModel(this.jListModelSelectedAttachments);
            this.jButtonAddAttachments = new JButton();
            this.jButtonAddAttachments.setText("Add attachments");
            this.jButtonAddAttachments.setBounds(new Rectangle(5, 20, 196, 26));
            this.jButtonAddAttachments.setPreferredSize(new Dimension(130, 18));
            this.jFileChooserAttachment = new JFileChooser();
            this.jFileChooserAttachment.setMultiSelectionEnabled(true);
            this.jButtonAddAttachments.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Console.this.jFileChooserAttachment.setDialogTitle("Select files to attach");
                    int res = Console.this.jFileChooserAttachment.showOpenDialog(Console.this);
                    if (res == 0) {
                        for (File attachmentFile : Console.this.jFileChooserAttachment.getSelectedFiles()) {
                            Console.this.jListModelSelectedAttachments.addElement(attachmentFile);
                        }
                    }
                }
            });
            this.jButtonRemoveAttachments = new JButton();
            this.jButtonRemoveAttachments.setText("Remove selected");
            this.jButtonRemoveAttachments.setBounds(new Rectangle(5, 20, 196, 26));
            this.jButtonRemoveAttachments.setPreferredSize(new Dimension(130, 18));
            this.jButtonRemoveAttachments.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    for (Object attachment : Console.this.jListSelectedAttachments.getSelectedValues()) {
                        Console.this.jListModelSelectedAttachments.removeElement(attachment);
                    }
                }
            });
            JPanel jPanelAttachmentButtons = new JPanel(new GridLayout(1, 2));
            jPanelAttachmentButtons.add((Component)this.jButtonAddAttachments, null);
            jPanelAttachmentButtons.add((Component)this.jButtonRemoveAttachments, null);
            this.jPanelAttachment.add((Component)new JScrollPane(this.jListSelectedAttachments), "Center");
            this.jPanelAttachment.add((Component)jPanelAttachmentButtons, "South");
            this.typeGroup = new ButtonGroup();
            this.jPanel3 = new JPanel();
            this.jPanel3.setLayout(gridLayout1);
            this.jPanel3.setLocation(new Point(0, 180));
            this.jPanel3.setSize(586, 80);
            this.jPanel3.setBorder(BorderFactory.createTitledBorder("Message exchange pattern"));
            this.jPanel3.setOpaque(false);
            this.inonly = new JRadioButton();
            this.inonly.setText("InOnly");
            this.inonly.setAutoscrolls(true);
            this.typeGroup.add(this.inonly);
            this.inonly.setSelected(true);
            this.inonly.setOpaque(false);
            this.inout = new JRadioButton();
            this.inout.setText("InOut");
            this.typeGroup.add(this.inout);
            this.inout.setOpaque(false);
            this.inoutopt = new JRadioButton();
            this.jPanel3.add((Component)this.inonly, null);
            this.inoutopt.setText("InOptionalOut");
            this.typeGroup.add(this.inoutopt);
            this.inoutopt.setOpaque(false);
            this.robustin = new JRadioButton();
            this.jPanel3.add((Component)this.inout, null);
            this.jPanel3.add((Component)this.inoutopt, null);
            this.jPanel3.add((Component)this.robustin, null);
            this.robustin.setText("RobustInOnly");
            this.robustin.setOpaque(false);
            this.typeGroup.add(this.robustin);
            this.jPanel2 = new JPanel();
            this.jPanel2.setLayout(null);
            this.jPanel2.setSize(586, 500);
            this.jPanel2.setLocation(new Point(0, 260));
            this.jPanel2.setPreferredSize(new Dimension(10, 10));
            this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Request / Response body", 4, 2));
            this.jPanel2.setOpaque(false);
            this.jLabel3 = new JLabel();
            this.jLabel3.setBounds(new Rectangle(5, 22, 576, 15));
            this.jLabel3.setText("In");
            this.jScrollPane1 = new JScrollPane();
            this.jScrollPane1.setBounds(new Rectangle(5, 45, 576, 90));
            this.jScrollPane1.setAutoscrolls(true);
            this.jPanel2.add((Component)this.jLabel3, null);
            this.in = new JTextArea(3, 40);
            this.in.setLineWrap(true);
            this.in.setWrapStyleWord(true);
            this.in.setText("<text>hi !</text>");
            this.jScrollPane1.setViewportView(this.in);
            this.jPanel2.add((Component)this.jScrollPane1, null);
            this.jLabel4 = new JLabel();
            this.jLabel4.setBounds(new Rectangle(5, 142, 576, 13));
            this.jLabel4.setText("Out");
            this.jPanel2.add((Component)this.jLabel4, null);
            this.jScrollPane2 = new JScrollPane();
            this.jScrollPane2.setBounds(new Rectangle(5, 163, 576, 90));
            this.out = new JTextArea(3, 40);
            this.out.setLineWrap(true);
            this.out.setWrapStyleWord(true);
            this.jScrollPane2.setViewportView(this.out);
            this.jPanel2.add((Component)this.jScrollPane2, null);
            this.jPanel4 = new JPanel();
            this.jPanel2.add((Component)this.jPanel4, null);
            this.jPanel2.add((Component)this.getPropJLabel(), null);
            this.jPanel2.add((Component)this.getJScrollPane(), null);
            this.sendPanel.add(this.jPanel1);
            this.sendPanel.add(this.jPanelAttachment);
            this.sendPanel.add((Component)this.jPanel3, null);
            this.sendPanel.add((Component)this.jPanel2, null);
            this.jPanel4.setLayout(null);
            this.jPanel4.setOpaque(false);
            this.jPanel4.setBounds(new Rectangle(0, 350, 586, 120));
            this.jPanel4.setBorder(BorderFactory.createTitledBorder("Send"));
            this.sendSync = new JButton();
            this.sendSync.setText("SendSync");
            this.sendSync.setBounds(new Rectangle(5, 20, 196, 26));
            this.sendSync.setPreferredSize(new Dimension(130, 18));
            this.sendSync.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    Console.this.sendSync();
                }
            });
            this.timeout = new JTextField();
            this.timeout.setText("2000");
            this.timeout.setToolTipText("timeout, in ms");
            this.timeout.setBounds(new Rectangle(209, 23, 42, 23));
            this.jButton1 = new JButton();
            this.jPanel4.add((Component)this.sendSync, null);
            this.jPanel4.add((Component)this.timeout, null);
            this.jPanel4.add((Component)this.jButton1, null);
            this.jButton1.setText("Send - Accept");
            this.jButton1.setBounds(new Rectangle(5, 55, 196, 27));
            this.jButton1.setPreferredSize(new Dimension(152, 15));
            this.jButton1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    Console.this.send();
                }
            });
            this.queryPanel = new JPanel();
            this.queryPanel.setOpaque(false);
            this.jTabbedPane1.addTab("Query", null, this.queryPanel, null);
            buffer = null;
            inStream = this.getClass().getResourceAsStream("/ebmlogo.jpg");
            try {
                if (inStream == null) {
                    inStream = new FileInputStream("src" + File.separator + "img" + File.separator + "ebmlogo.jpg");
                }
                dis = new DataInputStream(inStream);
                buffer = new byte[dis.available()];
                dis.readFully(buffer);
                img1 = new ImageIcon(buffer);
                this.background1 = new JLabel(img1);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, e.getMessage(), "Error", 0);
            }
            this.topQueryPanel = new JPanel();
            this.topQueryPanel.setLayout(null);
            this.topQueryPanel.setBorder(BorderFactory.createTitledBorder("Query the server to find endpoints"));
            this.topQueryPanel.setOpaque(false);
            this.jLabel8 = new JLabel();
            this.jLabel8.setBounds(new Rectangle(5, 0, 241, 23));
            this.jLabel8.setFont(new Font("Tahoma", 0, 14));
            this.jButton2 = new JButton();
            this.jButton2.setText("Find all the endpoints");
            this.jButton2.setBounds(new Rectangle(5, 30, 181, 25));
            this.jButton2.setPreferredSize(new Dimension(123, 23));
            this.jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    Console.this.getServices();
                }
            });
            this.jSeparator1 = new JSeparator();
            this.jSeparator1.setBounds(new Rectangle(5, 60, 576, 8));
            this.resolve = new JButton();
            this.resolve.setText("Resolve following description");
            this.resolve.setActionCommand("Resolve following description");
            this.resolve.setBounds(new Rectangle(5, 65, 241, 25));
            this.resolve.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    Console.this.resolveDescription();
                }
            });
            this.jTextArea1 = new JTextArea(6, 20);
            this.jTextArea1.setText("< enter a w3c document fragment>");
            this.jTextArea1.setLineWrap(true);
            this.jTextArea1.setWrapStyleWord(true);
            this.jTextArea1.setBounds(new Rectangle(5, 95, 576, 71));
            this.jTextArea1.setAutoscrolls(true);
            this.jTextArea1.setBorder(BorderFactory.createEtchedBorder());
            this.topQueryPanel.add((Component)this.jLabel8, null);
            this.topQueryPanel.add((Component)this.jButton2, null);
            this.topQueryPanel.add((Component)this.jSeparator1, null);
            this.topQueryPanel.add((Component)this.resolve, null);
            this.topQueryPanel.add((Component)this.jTextArea1, null);
            this.midQueryPanel = new JPanel();
            this.midQueryPanel.setLayout(null);
            this.midQueryPanel.setBorder(BorderFactory.createTitledBorder("Result : List of endpoints"));
            this.midQueryPanel.setOpaque(false);
            DefaultComboBoxModel<String> jList1Model = new DefaultComboBoxModel<String>(new String[0]);
            this.jList1 = new JList();
            this.jList1.setModel(jList1Model);
            this.servicesScrollPanel = new JScrollPane(this.jList1);
            this.servicesScrollPanel.setBounds(new Rectangle(5, 50, 576, 300));
            this.servicesScrollPanel.setAutoscrolls(true);
            this.midQueryPanel.add((Component)this.servicesScrollPanel, null);
            this.botQueryPanel = new JPanel();
            this.botQueryPanel.setLayout(null);
            this.botQueryPanel.setBorder(BorderFactory.createTitledBorder("Action on the selected endpoint"));
            this.botQueryPanel.setOpaque(false);
            this.jButton3 = new JButton();
            this.jButton3.setText("Get service description");
            this.jButton3.setBounds(new Rectangle(5, 20, 251, 25));
            this.jButton3.setPreferredSize(new Dimension(145, 26));
            this.jButton3.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    Console.this.showDescription();
                }
            });
            this.jButton31 = new JButton();
            this.jButton31.setBounds(new Rectangle(265, 20, 231, 25));
            this.jButton31.setText("Get interfaces");
            this.jButton31.setPreferredSize(new Dimension(145, 26));
            this.jButton31.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    Console.this.showInterfaces();
                }
            });
            this.asreference = new JButton();
            this.botQueryPanel.add((Component)this.jButton3, null);
            this.botQueryPanel.add((Component)this.asreference, null);
            this.botQueryPanel.add((Component)this.jButton31, null);
            this.asreference.setText("Get selected endpoint as reference");
            this.asreference.setBounds(new Rectangle(5, 55, 251, 25));
            this.asreference.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    Console.this.topQueryPanel.add((Component)Console.this.jLabel81, null);
                    Console.this.getAsReference();
                }
            });
            if (this.background1 != null) {
                this.background1.setBounds(new Rectangle(360, 63, this.background.getWidth(), this.background.getHeight()));
                this.botQueryPanel.add((Component)this.background1, null);
            }
            this.queryPanel.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 1;
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 3;
            c.ipady = 207;
            c.weighty = 0.0;
            c.weightx = 0.0;
            this.queryPanel.add((Component)this.topQueryPanel, c);
            c.fill = 1;
            c.gridx = 0;
            c.gridy = 1;
            c.gridwidth = 3;
            c.ipady = 0;
            c.ipadx = 0;
            c.weighty = 1.0;
            c.weightx = 1.0;
            this.queryPanel.add((Component)this.midQueryPanel, c);
            c.fill = 1;
            c.gridx = 0;
            c.gridy = 3;
            c.ipady = 130;
            c.ipadx = 500;
            c.gridwidth = 3;
            c.weighty = 0.0;
            c.weightx = 0.0;
            this.queryPanel.add((Component)this.botQueryPanel, c);
            this.pack();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setTitle("Petals - Sample client");
        this.setResizable(true);
        this.setSize(600, 789);
        Console.lockInMinSize(this);
    }

    private void openDialogBox(String title, String textMsg) {
        JFrame f = new JFrame(title);
        JTextArea text = new JTextArea(textMsg);
        text.setLineWrap(true);
        text.setWrapStyleWord(true);
        JScrollPane sp = new JScrollPane(text);
        f.getRootPane().getContentPane().add(sp);
        f.pack();
        f.setSize(300, 300);
        f.setDefaultCloseOperation(2);
        f.setVisible(true);
    }

    private void resolveDescription() {
        String fragmentDescription = this.jTextArea1.getText();
        ServiceEndpoint se = this.sampleClient.resolveDescription(fragmentDescription);
        DefaultListModel<ServiceEndpoint> listModel = new DefaultListModel<ServiceEndpoint>();
        listModel.addElement(se);
        this.jList1.setModel(listModel);
    }

    public String saveFolder() {
        JFileChooser saveFolder = new JFileChooser();
        saveFolder.setDialogTitle("Select folder to write attachments");
        saveFolder.setFileSelectionMode(1);
        int res = saveFolder.showSaveDialog(this);
        String result = ".";
        if (res == 0) {
            result = saveFolder.getSelectedFile().getAbsolutePath();
        }
        return result;
    }

    private void send() {
        JRadioButton selected = null;
        this.out.setText("");
        Enumeration<AbstractButton> rbs = this.typeGroup.getElements();
        while (rbs.hasMoreElements()) {
            AbstractButton but = rbs.nextElement();
            if (!but.isSelected()) continue;
            selected = (JRadioButton)but;
        }
        this.sampleClient.send(this.interfaceName.getText(), this.service.getText(), this.operation.getText(), this.endpoint.getText(), this.in.getText(), selected.getText(), this.getAttachmentFiles(), this.props.getText(), -1L);
    }

    private void sendSync() {
        JRadioButton selected = null;
        this.out.setText("");
        Enumeration<AbstractButton> rbs = this.typeGroup.getElements();
        while (rbs.hasMoreElements()) {
            AbstractButton but = rbs.nextElement();
            if (!but.isSelected()) continue;
            selected = (JRadioButton)but;
        }
        this.sampleClient.send(this.interfaceName.getText(), this.service.getText(), this.operation.getText(), this.endpoint.getText(), this.in.getText(), selected.getText(), this.getAttachmentFiles(), this.props.getText(), Long.parseLong(this.timeout.getText()));
    }

    public void setResponse(String text) {
        this.out.setText(text);
    }

    public void setResponse(String text, Map<String, String> properties) {
        this.out.setText(text);
        this.props.setText("");
        for (String name : properties.keySet()) {
            this.props.append(name + "=" + properties.get(name) + ";");
        }
    }

    private void showDescription() {
        ServiceEndpoint se = this.services[this.jList1.getSelectedIndex()];
        String msg = this.sampleClient.getDescription(se);
        this.openDialogBox("Description of " + se, msg);
    }

    public void showError(Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter psw = new PrintWriter(sw);
        e.printStackTrace(psw);
        JOptionPane.showMessageDialog(this, sw.toString(), "error", 0);
    }

    private void showInterfaces() {
        ServiceEndpoint se = this.services[this.jList1.getSelectedIndex()];
        String msg = this.sampleClient.getInterfaces(se);
        this.openDialogBox("Interfaces of " + se, msg);
    }

    public void showWarning(String msg) {
        JOptionPane.showMessageDialog(this, msg, "warning", 2);
    }

    private class ServiceSelector
    extends MouseAdapter {
        private final String name;

        public ServiceSelector(String name) {
            this.name = name;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Console.this.service.setText(this.name);
            Console.this.jTabbedPane1.setSelectedIndex(0);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Console.this.service.setText(this.name);
            Console.this.jTabbedPane1.setSelectedIndex(0);
        }
    }
}

