/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bpel.engine.util;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.impl.message.BPELInternalMessageImpl;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.env.ExternalContext;
import com.ebmwebsourcing.easyviper.core.api.soa.Endpoint;
import com.ebmwebsourcing.easyviper.core.api.soa.message.Message;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.FlowAttributes;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.jdom.Document;
import org.jdom.input.DOMBuilder;
import org.ow2.petals.bpel.engine.listener.JBIListener;
import org.ow2.petals.bpel.engine.message.JBIContextImpl;
import org.ow2.petals.bpel.engine.message.JBIExternalMessageImpl;
import org.ow2.petals.commons.PetalsExecutionContext;
import org.ow2.petals.component.framework.api.Message;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.util.ExchangeUtil;
import org.ow2.petals.component.framework.util.NormalizedMessageUtil;
import org.ow2.petals.component.framework.util.SourceUtil;
import org.w3c.dom.Element;

public class Sender {
    private final Logger logger;
    private final ComponentContext context;

    public Sender(ComponentContext context, DeliveryChannel channel, Logger logger) {
        this.logger = logger;
        this.context = context;
    }

    public final JBIExternalMessageImpl send(JBIExternalMessageImpl internalMsg, Long syncTime, Endpoint providerEndpointInfo, ExternalContext context, SendStyle sendStyle) throws CoreException {
        JBIExternalMessageImpl messageReturned = null;
        try {
            if (providerEndpointInfo == null) {
                throw new BPELException("The provider endpoint information cannot be null");
            }
            JBIContextImpl jbiContext = (JBIContextImpl)context;
            JBIListener listener = jbiContext.getListener();
            this.logger.finest("create JBI exchange");
            Exchange msgIn = null;
            msgIn = internalMsg.getContent() != null ? this.createMsg(providerEndpointInfo.getInterfaceName(), providerEndpointInfo.getInvokedOperation(), sendStyle, ((Element)internalMsg.getContent()).getOwnerDocument(), jbiContext.getInitialExchange(), listener) : this.createMsg(providerEndpointInfo.getInterfaceName(), providerEndpointInfo.getInvokedOperation(), sendStyle, null, jbiContext.getInitialExchange(), listener);
            this.logger.finest("Send a JBI message");
            String endpointName = null;
            QName service = null;
            Fault keptFault = null;
            Exception keptException = null;
            Element keptElement = null;
            URI keptPattern = null;
            msgIn.setInterfaceName(providerEndpointInfo.getInterfaceName());
            this.logger.finest("message mep : " + msgIn.getPattern());
            service = providerEndpointInfo.getServiceName();
            this.logger.fine("invoked service name: " + service);
            endpointName = providerEndpointInfo.getEndpointName();
            this.logger.fine("invoked endpoint name: " + endpointName);
            String messAddre = providerEndpointInfo.getAddress();
            if (messAddre != null && messAddre.contains("::")) {
                this.logger.fine("late binding invoke: " + messAddre);
                String[] tabServiceEndpoint = messAddre.split("::");
                if (tabServiceEndpoint.length > 1) {
                    service = QName.valueOf(tabServiceEndpoint[0]);
                    endpointName = tabServiceEndpoint[1];
                    msgIn.setService(service);
                    ServiceEndpoint serviceEndpoint = this.resolveEndPoint(service, endpointName);
                    msgIn.setEndpoint(serviceEndpoint);
                }
            } else if (service == null && endpointName == null) {
                this.logger.fine("Service name and endpoint not set, working only on interface.");
            } else if (service != null) {
                this.logger.fine("Set the service to invoke: " + service);
                msgIn.setService(service);
                if (endpointName != null && !"autogenerate".equals(endpointName)) {
                    ServiceEndpoint serviceEndpoint = this.resolveEndPoint(service, endpointName);
                    this.logger.fine("Set the endpoint to invoke: " + serviceEndpoint.getEndpointName());
                    msgIn.setEndpoint(serviceEndpoint);
                }
                this.logger.fine("invoke: " + endpointName);
            } else {
                this.logger.severe(String.valueOf(messAddre) + " is not a valid JBI address. It MUST be of the following form: {namespace}ServiceName::EndpointName");
                if (messAddre.startsWith("http:")) {
                    this.logger.severe("You entered a http address !!! Petals BPEL engine is in a bus and can only access a JBI address");
                }
            }
            this.logger.finest("Satus: " + msgIn.getStatus());
            this.logger.finest("Consumer Role? " + msgIn.isConsumerRole());
            if (sendStyle == SendStyle.ASYNCHRONOUS_SEND && msgIn.isInOnlyPattern()) {
                listener.send(msgIn);
            } else if (sendStyle == SendStyle.SYNCHRONOUS_SEND) {
                if (syncTime != null) {
                    listener.sendSync(msgIn);
                } else {
                    listener.sendSync(msgIn);
                }
                if (msgIn.isOutMessage()) {
                    org.w3c.dom.Document docOutMessage = null;
                    docOutMessage = msgIn.getOutMessage().getContent() instanceof DOMSource ? (org.w3c.dom.Document)((DOMSource)msgIn.getOutMessage().getContent()).getNode() : msgIn.getOutMessageContentAsDocument(true);
                    if (docOutMessage != null) {
                        keptElement = docOutMessage.getDocumentElement();
                    }
                }
                if (msgIn.getFault() != null) {
                    keptFault = msgIn.getFault();
                }
                if (msgIn.getError() != null) {
                    keptException = msgIn.getError();
                }
                if (msgIn.getPattern() != null) {
                    keptPattern = msgIn.getPattern();
                }
                if (!msgIn.getPattern().equals(Message.MEPConstants.IN_ONLY_PATTERN)) {
                    this.logger.finest("Set status done on endpoint: " + msgIn.getEndpointName());
                    msgIn.setDoneStatus();
                    this.logger.finest("Send status done");
                    listener.send(msgIn);
                }
                if (keptFault != null || keptException != null) {
                    if (keptException != null) {
                        throw new CoreException((Throwable)keptException);
                    }
                    if (keptFault != null) {
                        org.w3c.dom.Document faultDoc = SourceUtil.createDocument((Source)keptFault.getContent());
                        BPELInternalMessageImpl faultMsg = new BPELInternalMessageImpl();
                        DOMBuilder builder = new DOMBuilder();
                        Document faultJDoc = builder.build(faultDoc);
                        faultMsg.setContent((Object)faultJDoc.getRootElement());
                        faultMsg.setEndpoint(endpointName);
                        faultMsg.setOperationName(providerEndpointInfo.getInvokedOperation());
                        faultMsg.setService(service);
                        CoreException userEx = new CoreException();
                        userEx.setFault((Message)faultMsg);
                        throw userEx;
                    }
                    throw new CoreException("Error from the provider " + service + endpointName);
                }
                this.logger.log(Level.FINE, "Receive response from: " + service + endpointName);
                if (sendStyle == SendStyle.SYNCHRONOUS_SEND) {
                    messageReturned = new JBIExternalMessageImpl();
                    if (keptElement != null) {
                        messageReturned.setContent(keptElement);
                    }
                    if (this.logger.isLoggable(Level.FINEST)) {
                        this.logger.finest("jbi message returned: " + (Object)((Object)messageReturned));
                    }
                }
            } else {
                throw new CoreException("this kind of message (" + (Object)((Object)sendStyle) + ") is unknown or is incompatible with the mep of message: " + keptPattern);
            }
            this.logger.finest("JBI message sent");
        }
        catch (MessagingException e) {
            this.logger.severe(e.getMessage());
            throw new BPELException((Throwable)e);
        }
        catch (PEtALSCDKException e) {
            this.logger.severe(e.getMessage());
            throw new BPELException((Throwable)e);
        }
        return messageReturned;
    }

    private Exchange createMsg(QName itf, String operation, SendStyle sendStyle, org.w3c.dom.Document content, Exchange initialExchange, JBIListener listener) throws BPELException, PEtALSCDKException {
        Exchange exchange = null;
        try {
            FlowAttributes flowAttributes;
            Message.MEPConstants mep = Message.MEPConstants.IN_ONLY_PATTERN;
            if (sendStyle == SendStyle.SYNCHRONOUS_SEND) {
                mep = Message.MEPConstants.IN_OUT_PATTERN;
            }
            if ((flowAttributes = initialExchange.getFlowAttributes()) != null) {
                PetalsExecutionContext.putFlowAttributes((FlowAttributes)flowAttributes);
            }
            exchange = this.createExchange(mep, listener);
            exchange.setInterfaceName(itf);
            if (exchange != null) {
                if (itf == null) {
                    throw new BPELException("Interface cannot be null");
                }
                exchange.setOperation(new QName(itf.getNamespaceURI(), operation));
                exchange.setInMessageContent(content);
                if (initialExchange.getInMessage().getSecuritySubject() != null) {
                    exchange.getInMessage().setSecuritySubject(initialExchange.getInMessage().getSecuritySubject());
                }
                NormalizedMessageUtil.copyAttachments((NormalizedMessage)initialExchange.getInMessage(), (NormalizedMessage)exchange.getInMessage());
                ExchangeUtil.copyExchangeProperties((Exchange)initialExchange, (Exchange)exchange);
            }
        }
        catch (MessagingException e) {
            throw new BPELException((Throwable)e);
        }
        return exchange;
    }

    public Exchange createExchange(Message.MEPConstants mep, JBIListener listener) throws MessagingException {
        if (mep == null) {
            throw new IllegalArgumentException("'mep' parameter must be non null");
        }
        Exchange exchange = null;
        try {
            if (mep.equals((Object)Message.MEPConstants.IN_ONLY_PATTERN)) {
                exchange = listener.createExchange(Message.MEPConstants.IN_ONLY_PATTERN);
            } else if (mep.equals((Object)Message.MEPConstants.IN_OUT_PATTERN)) {
                exchange = listener.createExchange(Message.MEPConstants.IN_OUT_PATTERN);
            } else if (mep.equals((Object)Message.MEPConstants.ROBUST_IN_ONLY_PATTERN)) {
                exchange = listener.createExchange(Message.MEPConstants.ROBUST_IN_ONLY_PATTERN);
            } else if (mep.equals((Object)Message.MEPConstants.IN_OPTIONAL_OUT_PATTERN)) {
                exchange = listener.createExchange(Message.MEPConstants.IN_OPTIONAL_OUT_PATTERN);
            }
        }
        catch (PEtALSCDKException e) {
            throw new MessagingException((Throwable)e);
        }
        return exchange;
    }

    public final ServiceEndpoint resolveEndPoint(QName service, String endpointName) throws BPELException {
        this.logger.log(Level.FINEST, "find the endPoint in the JBI environment");
        this.logger.log(Level.FINEST, "service name: " + service);
        this.logger.log(Level.FINEST, "endpoint name: " + endpointName);
        ServiceEndpoint endpoint = this.context.getEndpoint(service, endpointName);
        if (endpoint == null) {
            throw new BPELException("endpoint (" + service + "-" + endpointName + ") not found in the JBI environment");
        }
        this.logger.log(Level.FINEST, "endpoint service found: " + endpoint);
        return endpoint;
    }

    public static enum SendStyle {
        ASYNCHRONOUS_SEND,
        SYNCHRONOUS_SEND,
        SYNCHRONOUS_SEND_WITH_TIMEOUT;

    }
}

