/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bpel.engine.su;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.model.Model;
import com.ebmwebsourcing.easyviper.core.api.model.registry.ProcessKey;
import com.ebmwebsourcing.easyviper.core.api.model.registry.definition.ProcessContextDefinition;
import com.ebmwebsourcing.easyviper.core.impl.model.registry.ProcessContextDefinitionImpl;
import com.ebmwebsourcing.easyviper.core.impl.model.registry.ProcessKeyImpl;
import java.net.URI;
import java.util.List;
import javax.jbi.servicedesc.ServiceEndpoint;
import org.ow2.petals.bpel.engine.BPELEngine;
import org.ow2.petals.bpel.engine.util.Util;
import org.ow2.petals.component.framework.AbstractComponent;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.jbidescriptor.generated.Jbi;
import org.ow2.petals.component.framework.jbidescriptor.generated.Provides;
import org.ow2.petals.component.framework.su.AbstractServiceUnitManager;
import org.ow2.petals.component.framework.su.ServiceUnitDataHandler;

public final class CoreServiceUnitManager
extends AbstractServiceUnitManager {
    private static final String BPEL_PROPERTY = "bpel";
    private static final String POOLSIZE_PROPERTY = "poolsize";
    private static final String FORCE_UNINSTALL_PROPERTY = "force-uninstall";

    public CoreServiceUnitManager(AbstractComponent component) {
        super(component);
    }

    protected void doDeploy(String serviceUnitName, String suRootPath, Jbi jbiDescriptor) throws PEtALSCDKException {
        try {
            this.logger.info("Perform BPEL-Processes deployment on Core server");
            List providesList = jbiDescriptor.getServices().getProvides();
            for (Provides provides : providesList) {
                ConfigurationExtensions props = new ConfigurationExtensions(provides.getAny());
                String bpelProcessName = props.get((Object)BPEL_PROPERTY);
                int poolSize = 0;
                if (props.get((Object)POOLSIZE_PROPERTY) != null) {
                    poolSize = Integer.valueOf(props.get((Object)POOLSIZE_PROPERTY));
                }
                ProcessContextDefinitionImpl context = new ProcessContextDefinitionImpl();
                context.setPoolSize(poolSize);
                URI uri = Util.getResourceAsURL(suRootPath, bpelProcessName).toURI();
                Model model = ((BPELEngine)this.component).getCore().getModel();
                model.getRegistry().storeProcessDefinition(uri, (ProcessContextDefinition)context);
                this.logger.info("The BPEL Process " + bpelProcessName + " has been succesfully deployed on Core server and is available on the endpoint " + provides.getServiceName() + provides.getEndpointName());
            }
            this.logger.info("BPEL-Processes deployment on Core server has been performed");
        }
        catch (Exception e) {
            this.logger.severe("BPEL-Processes deployment on Core server failed ! see the error message: " + e.getMessage());
            throw new PEtALSCDKException((Throwable)e);
        }
    }

    protected void doShutdown(String serviceUnitName) throws PEtALSCDKException {
    }

    protected void doStart(String serviceUnitName) throws PEtALSCDKException {
    }

    protected void doStop(String serviceUnitName) throws PEtALSCDKException {
    }

    protected void doUndeploy(String serviceUnitName) throws PEtALSCDKException {
        try {
            this.logger.info("Perform BPEL-Processes undeployment on Core server");
            for (ServiceEndpoint serviceEndpoint : this.getEndpointsForServiceUnit(serviceUnitName)) {
                Provides currentPovides = this.getProvidesFromEndpoint(serviceEndpoint);
                ProcessKeyImpl currentKey = new ProcessKeyImpl();
                currentKey.setEndpoint(currentPovides.getEndpointName());
                currentKey.setInterface(currentPovides.getInterfaceName());
                currentKey.setService(currentPovides.getServiceName());
                this.logger.finest(currentKey.getInterface() + "::" + currentKey.getService() + "::" + currentKey.getEndpoint() + "  is going to be removed...");
                try {
                    ((BPELEngine)this.component).getCore().getEngine().getPoolOfProcessForkers().removeFromKey((ProcessKey)currentKey);
                }
                catch (InterruptedException e) {
                    throw new PEtALSCDKException((Throwable)e);
                }
                catch (CoreException e) {
                    throw new PEtALSCDKException((Throwable)e);
                }
            }
            ServiceUnitDataHandler suDataHandler = (ServiceUnitDataHandler)this.getServiceUnitDataHandlers().get(serviceUnitName);
            for (Provides provides : suDataHandler.getDescriptor().getServices().getProvides()) {
                ConfigurationExtensions props = suDataHandler.getConfigurationExtensions((Object)provides);
                String bpelProcessName = props.get((Object)BPEL_PROPERTY);
                Boolean forceUninstall = true;
                if (props.get((Object)FORCE_UNINSTALL_PROPERTY) != null) {
                    forceUninstall = Boolean.valueOf(props.get((Object)FORCE_UNINSTALL_PROPERTY));
                }
                ((BPELEngine)this.component).getCore().getModel().getRegistry().unStoreProcessDefinition(Util.getResourceAsURL(suDataHandler.getInstallRoot(), bpelProcessName).toURI(), forceUninstall.booleanValue());
                this.logger.info("The BPEL Process " + bpelProcessName + " has been succesfully undeployed on Core server");
            }
            this.logger.info("BPEL-Processes undeployment on Core server has been performed");
        }
        catch (Exception e) {
            throw new PEtALSCDKException((Throwable)e);
        }
    }
}

