/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bpel.engine;

import com.ebmwebsourcing.easybpel.extended.activities.configure.api.ExtendedActivityInitialization;
import com.ebmwebsourcing.easybpel.extended.activities.configure.api.ExtendedActivityInitializationList;
import com.ebmwebsourcing.easybpel.extended.activities.configure.api.inout.ExtendedActivityInitializationListReader;
import com.ebmwebsourcing.easybpel.extended.activities.configure.impl.inout.ExtendedActivityInitializationListReaderImpl;
import com.ebmwebsourcing.easybpel.extended.service.activity.api.ExtendedActivityService;
import com.ebmwebsourcing.easybpel.extended.service.activity.impl.ExtendedActivityServiceImpl;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.impl.BPELFactoryImpl;
import com.ebmwebsourcing.easyviper.core.api.Core;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.configuration.ConfigurationEngine;
import com.ebmwebsourcing.easyviper.core.impl.engine.configuration.ConfigurationEngineImpl;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import org.ow2.petals.bpel.engine.env.JBIReceiverImpl;
import org.ow2.petals.bpel.engine.env.JBISenderImpl;
import org.ow2.petals.bpel.engine.su.CoreServiceUnitManager;
import org.ow2.petals.bpel.engine.util.Util;
import org.ow2.petals.component.framework.AbstractComponent;
import org.ow2.petals.component.framework.se.AbstractServiceEngine;
import org.ow2.petals.component.framework.su.AbstractServiceUnitManager;

public class BPELEngine
extends AbstractServiceEngine {
    private Core core;
    private ExtendedActivityInitializationListReader reader = null;

    protected final void doInit() throws JBIException {
        try {
            this.getLogger().log(Level.INFO, "Core Intialization...");
            ConfigurationEngineImpl conf = new ConfigurationEngineImpl();
            if (this.getComponentExtensions().get((Object)"explorer") != null) {
                conf.setExplorer(Boolean.valueOf(this.getComponentExtensions().get((Object)"explorer")));
            }
            if (this.getComponentExtensions().get((Object)"autoFlushMessage-frequency") != null) {
                conf.setAutoFlushMessageFrequency(Integer.valueOf(Integer.parseInt(this.getComponentExtensions().get((Object)"autoFlushMessage-frequency"))));
                this.getLogger().log(Level.INFO, "auto-flushMessage activated at frequency: " + conf.getAutoFlushMessageFrequency());
            }
            if (this.getComponentExtensions().get((Object)"autoTrashProcess-frequency") != null) {
                conf.setAutoTrashProcessFreqeuency(Integer.valueOf(Integer.parseInt(this.getComponentExtensions().get((Object)"autoTrashProcess-frequency"))));
                this.getLogger().log(Level.INFO, "auto-trashProcess activated at frequency: " + conf.getAutoTrashProcessFrequency());
            }
            boolean activateInitialLogger = false;
            if (this.getComponentExtensions().get((Object)"internal-logger") != null) {
                activateInitialLogger = Boolean.valueOf(this.getComponentExtensions().get((Object)"internal-logger"));
            }
            Logger internalLogger = null;
            if (activateInitialLogger) {
                internalLogger = this.getLogger();
            }
            this.core = BPELFactoryImpl.getInstance().newBPELEngine((ConfigurationEngine)conf, 10, JBIReceiverImpl.class, 10, JBISenderImpl.class, internalLogger);
            String extendedActivityFileInit = this.getComponentExtensions().get((Object)"extended-activity-init-file");
            if (extendedActivityFileInit != null) {
                this.getLogger().log(Level.INFO, "extended-activity-init-file found: " + extendedActivityFileInit);
                this.reader = new ExtendedActivityInitializationListReaderImpl();
                URI init = Util.getResourceAsURL(this.getContext().getInstallRoot(), extendedActivityFileInit).toURI();
                ExtendedActivityInitializationList extendedActivityList = this.reader.read(init);
                ExtendedActivityService service = (ExtendedActivityService)this.core.getEngine().getServiceManager().getService(ExtendedActivityServiceImpl.class);
                for (ExtendedActivityInitialization activityDef : extendedActivityList.getExtendedActivityInitialization()) {
                    this.getLogger().log(Level.INFO, "add extended activity from: " + activityDef.getDefinition());
                    service.loadExtendedActivitiesConfigure(Thread.currentThread().getContextClassLoader().getResource(activityDef.getDefinition()));
                }
            }
        }
        catch (BPELException e) {
            e.printStackTrace();
            throw new JBIException((Throwable)e);
        }
        catch (CoreException e) {
            e.printStackTrace();
            throw new JBIException((Throwable)e);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            throw new JBIException((Throwable)e);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            throw new JBIException((Throwable)e);
        }
    }

    public void doShutdown() throws JBIException {
        try {
            this.core.getEngine().getPoolOfProcessForkers().removeAllForkers();
        }
        catch (InterruptedException e) {
            throw new JBIException((Throwable)e);
        }
        catch (CoreException e) {
            throw new JBIException((Throwable)e);
        }
    }

    public Core getCore() {
        return this.core;
    }

    protected AbstractServiceUnitManager createServiceUnitManager() {
        return new CoreServiceUnitManager((AbstractComponent)this);
    }
}

