/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.se.eip.patterns;

import com.ebmwebsourcing.easycommons.xml.DocumentBuilders;
import com.ebmwebsourcing.easycommons.xml.XMLComparator;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Source;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.jbidescriptor.generated.Consumes;
import org.ow2.petals.component.framework.jbidescriptor.generated.MEPType;
import org.ow2.petals.component.framework.jbidescriptor.generated.Param;
import org.ow2.petals.component.framework.util.SourceUtil;
import org.ow2.petals.se.eip.async.CommonAsyncContext;
import org.ow2.petals.se.eip.patterns.AbstractMEPBridgeWithUnicConsumesPattern;
import org.ow2.petals.se.eip.patterns.AbstractPattern;
import org.ow2.petals.se.eip.patterns.AbstractTest;
import org.ow2.petals.se.eip.patterns.mock.ExchangeImplMock;
import org.ow2.petals.se.eip.patterns.mock.MessageExchangeMock;
import org.w3c.dom.Document;

public abstract class AbstractMEPBridgeWithUnicConsumesPatternTest
extends AbstractTest {
    private static final String VIRTUAL_NAMESPACE = "http://petals.ow2.org/components/eip/version-2/virtualMEPBridge";
    private static final String VIRTUAL_NAME = "virtualMEPBridge";
    protected AbstractMEPBridgeWithUnicConsumesPattern abstractMEPBridgeWithUnicConsumesPattern;
    private Document in1;
    private Document out1;
    private Document out2;
    private Document fault1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        DocumentBuilder documentBuilder = null;
        InputStream inputStream = null;
        try {
            documentBuilder = DocumentBuilders.takeDocumentBuilder();
            inputStream = AbstractMEPBridgeWithUnicConsumesPattern.class.getResourceAsStream("/abstractMEPBridgeIn1.xml");
            this.in1 = documentBuilder.parse(inputStream);
            inputStream.close();
            inputStream = AbstractMEPBridgeWithUnicConsumesPattern.class.getResourceAsStream("/abstractMEPBridgeOut1.xml");
            this.out1 = documentBuilder.parse(inputStream);
            inputStream.close();
            inputStream = AbstractMEPBridgeWithUnicConsumesPattern.class.getResourceAsStream("/abstractMEPBridgeOut2.xml");
            this.out2 = documentBuilder.parse(inputStream);
            inputStream.close();
            inputStream = AbstractMEPBridgeWithUnicConsumesPattern.class.getResourceAsStream("/abstractMEPBridgeFault1.xml");
            this.fault1 = documentBuilder.parse(inputStream);
        }
        finally {
            if (documentBuilder != null) {
                DocumentBuilders.releaseDocumentBuilder((DocumentBuilder)documentBuilder);
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        this.abstractMEPBridgeWithUnicConsumesPattern = null;
        this.in1 = null;
        this.out1 = null;
        this.out2 = null;
        this.fault1 = null;
    }

    @Test
    public void testProcessInOnlyWithInOnlyConsumesWithDone() {
        try {
            this.abstractMEPBridgeWithUnicConsumesPattern.init();
            this.context.getExchangeList().clear();
            List<Consumes> consumesList = this.getConsumesList(MEPType.IN_ONLY);
            this.context.setConsumeList(consumesList);
            ExchangeImplMock originalExchange = this.createExchange(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, this.in1, null, null, null);
            CommonAsyncContext eipAsyncContext = new CommonAsyncContext((Exchange)originalExchange, Long.valueOf(600000L), this.abstractMEPBridgeWithUnicConsumesPattern.getName(), consumesList.size(), false, false, false);
            this.processAsyncStreamTest(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.DONE, null, null, null, null, (AbstractPattern)this.abstractMEPBridgeWithUnicConsumesPattern, eipAsyncContext);
            Assert.assertEquals((long)1L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isDoneStatus());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getOutMessage());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getFault());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getError());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOnlyWithInOnlyConsumesWithError() {
        try {
            this.abstractMEPBridgeWithUnicConsumesPattern.init();
            this.context.getExchangeList().clear();
            List<Consumes> consumesList = this.getConsumesList(MEPType.IN_ONLY);
            this.context.setConsumeList(consumesList);
            ExchangeImplMock originalExchange = this.createExchange(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, this.in1, null, null, null);
            CommonAsyncContext eipAsyncContext = new CommonAsyncContext((Exchange)originalExchange, Long.valueOf(600000L), this.abstractMEPBridgeWithUnicConsumesPattern.getName(), consumesList.size(), false, false, false);
            this.processAsyncStreamTest(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ERROR, null, null, null, (Exception)((Object)new MessagingException("test exception")), (AbstractPattern)this.abstractMEPBridgeWithUnicConsumesPattern, eipAsyncContext);
            Assert.assertEquals((long)1L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isErrorStatus());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getOutMessage());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getFault());
            Assert.assertNotNull((Object)eipAsyncContext.getOriginalExchange().getError());
            Assert.assertEquals((Object)"javax.jbi.messaging.MessagingException: test exception", (Object)eipAsyncContext.getOriginalExchange().getError().getMessage());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOnlyWithRobustInOnlyConsumesWithDone() {
        try {
            this.abstractMEPBridgeWithUnicConsumesPattern.init();
            this.context.getExchangeList().clear();
            List<Consumes> consumesList = this.getConsumesList(MEPType.IN_ONLY);
            this.context.setConsumeList(consumesList);
            ExchangeImplMock originalExchange = this.createExchange(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, this.in1, null, null, null);
            CommonAsyncContext eipAsyncContext = new CommonAsyncContext((Exchange)originalExchange, Long.valueOf(600000L), this.abstractMEPBridgeWithUnicConsumesPattern.getName(), consumesList.size(), false, false, false);
            this.processAsyncStreamTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.DONE, null, null, null, null, (AbstractPattern)this.abstractMEPBridgeWithUnicConsumesPattern, eipAsyncContext);
            Assert.assertEquals((long)1L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isDoneStatus());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getOutMessage());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getFault());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getError());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOnlyWithRobustInOnlyConsumesWithError() {
        try {
            this.abstractMEPBridgeWithUnicConsumesPattern.init();
            this.context.getExchangeList().clear();
            List<Consumes> consumesList = this.getConsumesList(MEPType.IN_ONLY);
            this.context.setConsumeList(consumesList);
            ExchangeImplMock originalExchange = this.createExchange(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, this.in1, null, null, null);
            CommonAsyncContext eipAsyncContext = new CommonAsyncContext((Exchange)originalExchange, Long.valueOf(600000L), this.abstractMEPBridgeWithUnicConsumesPattern.getName(), consumesList.size(), false, false, false);
            this.processAsyncStreamTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ERROR, null, null, null, (Exception)((Object)new MessagingException("test exception")), (AbstractPattern)this.abstractMEPBridgeWithUnicConsumesPattern, eipAsyncContext);
            Assert.assertEquals((long)1L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isErrorStatus());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getOutMessage());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getFault());
            Assert.assertNotNull((Object)eipAsyncContext.getOriginalExchange().getError());
            Assert.assertEquals((Object)"javax.jbi.messaging.MessagingException: test exception", (Object)eipAsyncContext.getOriginalExchange().getError().getMessage());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOnlyWithRobustInOnlyConsumesWithFault() {
        try {
            this.abstractMEPBridgeWithUnicConsumesPattern.init();
            this.context.getExchangeList().clear();
            List<Consumes> consumesList = this.getConsumesList(MEPType.IN_ONLY);
            this.context.setConsumeList(consumesList);
            ExchangeImplMock originalExchange = this.createExchange(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, this.in1, null, null, null);
            CommonAsyncContext eipAsyncContext = new CommonAsyncContext((Exchange)originalExchange, Long.valueOf(600000L), this.abstractMEPBridgeWithUnicConsumesPattern.getName(), consumesList.size(), false, false, false);
            this.processAsyncStreamTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ACTIVE, null, null, this.fault1, null, (AbstractPattern)this.abstractMEPBridgeWithUnicConsumesPattern, eipAsyncContext);
            Assert.assertEquals((long)2L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isDoneStatus());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getOutMessage());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getFault());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getError());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOnlyWithRobustInOnlyConsumesWithFaultAndFaultToException() {
        try {
            this.abstractMEPBridgeWithUnicConsumesPattern.init();
            this.context.getExchangeList().clear();
            List<Consumes> consumesList = this.getConsumesList(MEPType.IN_ONLY);
            this.context.setConsumeList(consumesList);
            ExchangeImplMock originalExchange = this.createExchange(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, this.in1, null, null, null);
            CommonAsyncContext eipAsyncContext = new CommonAsyncContext((Exchange)originalExchange, Long.valueOf(600000L), this.abstractMEPBridgeWithUnicConsumesPattern.getName(), consumesList.size(), false, false, true);
            this.processAsyncStreamTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ACTIVE, null, null, this.fault1, null, (AbstractPattern)this.abstractMEPBridgeWithUnicConsumesPattern, eipAsyncContext);
            Assert.assertEquals((long)2L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isErrorStatus());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getOutMessage());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getFault());
            Assert.assertNotNull((Object)eipAsyncContext.getOriginalExchange().getError());
            XMLComparator.isEquivalent((String)XMLPrettyPrinter.prettyPrint((Document)this.fault1), (String)eipAsyncContext.getOriginalExchange().getError().getMessage());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOnlyWithInOutConsumesWithOut() {
        try {
            this.abstractMEPBridgeWithUnicConsumesPattern.init();
            this.context.getExchangeList().clear();
            List<Consumes> consumesList = this.getConsumesList(MEPType.IN_ONLY);
            this.context.setConsumeList(consumesList);
            ExchangeImplMock originalExchange = this.createExchange(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, this.in1, null, null, null);
            CommonAsyncContext eipAsyncContext = new CommonAsyncContext((Exchange)originalExchange, Long.valueOf(600000L), this.abstractMEPBridgeWithUnicConsumesPattern.getName(), consumesList.size(), false, false, false);
            this.processAsyncStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ACTIVE, null, this.out1, null, null, (AbstractPattern)this.abstractMEPBridgeWithUnicConsumesPattern, eipAsyncContext);
            Assert.assertEquals((long)2L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isDoneStatus());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getOutMessage());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getFault());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getError());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOnlyWithInOutConsumesWithFault() {
        try {
            this.abstractMEPBridgeWithUnicConsumesPattern.init();
            this.context.getExchangeList().clear();
            List<Consumes> consumesList = this.getConsumesList(MEPType.IN_ONLY);
            this.context.setConsumeList(consumesList);
            ExchangeImplMock originalExchange = this.createExchange(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, this.in1, null, null, null);
            CommonAsyncContext eipAsyncContext = new CommonAsyncContext((Exchange)originalExchange, Long.valueOf(600000L), this.abstractMEPBridgeWithUnicConsumesPattern.getName(), consumesList.size(), false, false, false);
            this.processAsyncStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ACTIVE, null, null, this.fault1, null, (AbstractPattern)this.abstractMEPBridgeWithUnicConsumesPattern, eipAsyncContext);
            Assert.assertEquals((long)2L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isDoneStatus());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getOutMessage());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getFault());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getError());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOnlyWithInOutConsumesWithFaultAndFaultToException() {
        try {
            this.abstractMEPBridgeWithUnicConsumesPattern.init();
            this.context.getExchangeList().clear();
            List<Consumes> consumesList = this.getConsumesList(MEPType.IN_ONLY);
            this.context.setConsumeList(consumesList);
            ExchangeImplMock originalExchange = this.createExchange(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, this.in1, null, null, null);
            CommonAsyncContext eipAsyncContext = new CommonAsyncContext((Exchange)originalExchange, Long.valueOf(600000L), this.abstractMEPBridgeWithUnicConsumesPattern.getName(), consumesList.size(), false, false, true);
            this.processAsyncStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ACTIVE, null, null, this.fault1, null, (AbstractPattern)this.abstractMEPBridgeWithUnicConsumesPattern, eipAsyncContext);
            Assert.assertEquals((long)2L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isErrorStatus());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getOutMessage());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getFault());
            Assert.assertNotNull((Object)eipAsyncContext.getOriginalExchange().getError());
            XMLComparator.isEquivalent((String)XMLPrettyPrinter.prettyPrint((Document)this.fault1), (String)eipAsyncContext.getOriginalExchange().getError().getMessage());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessRobustInOnlyWithInOnlyConsumesWithDone() {
        try {
            this.abstractMEPBridgeWithUnicConsumesPattern.init();
            this.context.getExchangeList().clear();
            List<Consumes> consumesList = this.getConsumesList(MEPType.IN_ONLY);
            this.context.setConsumeList(consumesList);
            ExchangeImplMock originalExchange = this.createExchange(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, this.in1, null, null, null);
            CommonAsyncContext eipAsyncContext = new CommonAsyncContext((Exchange)originalExchange, Long.valueOf(600000L), this.abstractMEPBridgeWithUnicConsumesPattern.getName(), consumesList.size(), false, false, false);
            this.processAsyncStreamTest(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.DONE, null, null, null, null, (AbstractPattern)this.abstractMEPBridgeWithUnicConsumesPattern, eipAsyncContext);
            Assert.assertEquals((long)1L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isDoneStatus());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getOutMessage());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getFault());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getError());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessRobustInOnlyWithInOnlyConsumesWithError() {
        try {
            this.abstractMEPBridgeWithUnicConsumesPattern.init();
            this.context.getExchangeList().clear();
            List<Consumes> consumesList = this.getConsumesList(MEPType.IN_ONLY);
            this.context.setConsumeList(consumesList);
            ExchangeImplMock originalExchange = this.createExchange(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, this.in1, null, null, null);
            CommonAsyncContext eipAsyncContext = new CommonAsyncContext((Exchange)originalExchange, Long.valueOf(600000L), this.abstractMEPBridgeWithUnicConsumesPattern.getName(), consumesList.size(), false, false, false);
            this.processAsyncStreamTest(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ERROR, null, null, null, new Exception("test exception"), (AbstractPattern)this.abstractMEPBridgeWithUnicConsumesPattern, eipAsyncContext);
            Assert.assertEquals((long)1L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isErrorStatus());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getOutMessage());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getFault());
            Assert.assertNotNull((Object)eipAsyncContext.getOriginalExchange().getError());
            Assert.assertEquals((Object)"java.lang.Exception: test exception", (Object)eipAsyncContext.getOriginalExchange().getError().getMessage());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessRobustInOnlyWithRobustInOnlyConsumesWithDone() {
        try {
            this.abstractMEPBridgeWithUnicConsumesPattern.init();
            this.context.getExchangeList().clear();
            List<Consumes> consumesList = this.getConsumesList(MEPType.IN_ONLY);
            this.context.setConsumeList(consumesList);
            ExchangeImplMock originalExchange = this.createExchange(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, this.in1, null, null, null);
            CommonAsyncContext eipAsyncContext = new CommonAsyncContext((Exchange)originalExchange, Long.valueOf(600000L), this.abstractMEPBridgeWithUnicConsumesPattern.getName(), consumesList.size(), false, false, false);
            this.processAsyncStreamTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.DONE, null, null, null, null, (AbstractPattern)this.abstractMEPBridgeWithUnicConsumesPattern, eipAsyncContext);
            Assert.assertEquals((long)1L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isDoneStatus());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getOutMessage());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getFault());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getError());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessRobustInOnlyWithRobustInOnlyConsumesWithError() {
        try {
            this.abstractMEPBridgeWithUnicConsumesPattern.init();
            this.context.getExchangeList().clear();
            List<Consumes> consumesList = this.getConsumesList(MEPType.IN_ONLY);
            this.context.setConsumeList(consumesList);
            ExchangeImplMock originalExchange = this.createExchange(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, this.in1, null, null, null);
            CommonAsyncContext eipAsyncContext = new CommonAsyncContext((Exchange)originalExchange, Long.valueOf(600000L), this.abstractMEPBridgeWithUnicConsumesPattern.getName(), consumesList.size(), false, false, false);
            this.processAsyncStreamTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ERROR, null, null, null, new Exception("test exception"), (AbstractPattern)this.abstractMEPBridgeWithUnicConsumesPattern, eipAsyncContext);
            Assert.assertEquals((long)1L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isErrorStatus());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getOutMessage());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getFault());
            Assert.assertNotNull((Object)eipAsyncContext.getOriginalExchange().getError());
            Assert.assertEquals((Object)"java.lang.Exception: test exception", (Object)eipAsyncContext.getOriginalExchange().getError().getMessage());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessRobustInOnlyWithRobustInOnlyConsumesWithFault() {
        try {
            this.abstractMEPBridgeWithUnicConsumesPattern.init();
            this.context.getExchangeList().clear();
            List<Consumes> consumesList = this.getConsumesList(MEPType.IN_ONLY);
            this.context.setConsumeList(consumesList);
            ExchangeImplMock originalExchange = this.createExchange(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, this.in1, null, null, null);
            CommonAsyncContext eipAsyncContext = new CommonAsyncContext((Exchange)originalExchange, Long.valueOf(600000L), this.abstractMEPBridgeWithUnicConsumesPattern.getName(), consumesList.size(), false, false, false);
            this.processAsyncStreamTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ACTIVE, null, null, this.fault1, null, (AbstractPattern)this.abstractMEPBridgeWithUnicConsumesPattern, eipAsyncContext);
            Assert.assertEquals((long)2L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isActiveStatus());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getOutMessage());
            Assert.assertNotNull((Object)eipAsyncContext.getOriginalExchange().getFault());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getError());
            String result = XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)eipAsyncContext.getOriginalExchange().getFault().getContent()));
            XMLComparator.isEquivalent((String)XMLPrettyPrinter.prettyPrint((Document)this.fault1), (String)result);
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessRobustInOnlyWithRobustInOnlyConsumesWithFaultAndFaultToException() {
        try {
            this.abstractMEPBridgeWithUnicConsumesPattern.init();
            this.context.getExchangeList().clear();
            List<Consumes> consumesList = this.getConsumesList(MEPType.IN_ONLY);
            this.context.setConsumeList(consumesList);
            ExchangeImplMock originalExchange = this.createExchange(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, this.in1, null, null, null);
            CommonAsyncContext eipAsyncContext = new CommonAsyncContext((Exchange)originalExchange, Long.valueOf(600000L), this.abstractMEPBridgeWithUnicConsumesPattern.getName(), consumesList.size(), false, false, true);
            this.processAsyncStreamTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ACTIVE, null, null, this.fault1, null, (AbstractPattern)this.abstractMEPBridgeWithUnicConsumesPattern, eipAsyncContext);
            Assert.assertEquals((long)2L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isErrorStatus());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getOutMessage());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getFault());
            Assert.assertNotNull((Object)eipAsyncContext.getOriginalExchange().getError());
            XMLComparator.isEquivalent((String)XMLPrettyPrinter.prettyPrint((Document)this.fault1), (String)eipAsyncContext.getOriginalExchange().getError().getMessage());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessRobustInOnlyWithInOutConsumesWithOut() {
        try {
            this.abstractMEPBridgeWithUnicConsumesPattern.init();
            this.context.getExchangeList().clear();
            List<Consumes> consumesList = this.getConsumesList(MEPType.IN_ONLY);
            this.context.setConsumeList(consumesList);
            ExchangeImplMock originalExchange = this.createExchange(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, this.in1, null, null, null);
            CommonAsyncContext eipAsyncContext = new CommonAsyncContext((Exchange)originalExchange, Long.valueOf(600000L), this.abstractMEPBridgeWithUnicConsumesPattern.getName(), consumesList.size(), false, false, false);
            this.processAsyncStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ACTIVE, null, this.out1, null, null, (AbstractPattern)this.abstractMEPBridgeWithUnicConsumesPattern, eipAsyncContext);
            Assert.assertEquals((long)2L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isDoneStatus());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getOutMessage());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getFault());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getError());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessRobustInOnlyWithInOutConsumesWithFault() {
        try {
            this.abstractMEPBridgeWithUnicConsumesPattern.init();
            this.context.getExchangeList().clear();
            List<Consumes> consumesList = this.getConsumesList(MEPType.IN_ONLY);
            this.context.setConsumeList(consumesList);
            ExchangeImplMock originalExchange = this.createExchange(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, this.in1, null, null, null);
            CommonAsyncContext eipAsyncContext = new CommonAsyncContext((Exchange)originalExchange, Long.valueOf(600000L), this.abstractMEPBridgeWithUnicConsumesPattern.getName(), consumesList.size(), false, false, false);
            this.processAsyncStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ACTIVE, null, null, this.fault1, null, (AbstractPattern)this.abstractMEPBridgeWithUnicConsumesPattern, eipAsyncContext);
            Assert.assertEquals((long)2L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isActiveStatus());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getOutMessage());
            Assert.assertNotNull((Object)eipAsyncContext.getOriginalExchange().getFault());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getError());
            String result = XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)eipAsyncContext.getOriginalExchange().getFault().getContent()));
            XMLComparator.isEquivalent((String)XMLPrettyPrinter.prettyPrint((Document)this.fault1), (String)result);
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessRobustInOnlyWithInOutConsumesWithFaultAndFaultToException() {
        try {
            this.abstractMEPBridgeWithUnicConsumesPattern.init();
            this.context.getExchangeList().clear();
            List<Consumes> consumesList = this.getConsumesList(MEPType.IN_ONLY);
            this.context.setConsumeList(consumesList);
            ExchangeImplMock originalExchange = this.createExchange(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, this.in1, null, null, null);
            CommonAsyncContext eipAsyncContext = new CommonAsyncContext((Exchange)originalExchange, Long.valueOf(600000L), this.abstractMEPBridgeWithUnicConsumesPattern.getName(), consumesList.size(), false, false, true);
            this.processAsyncStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ACTIVE, null, null, this.fault1, null, (AbstractPattern)this.abstractMEPBridgeWithUnicConsumesPattern, eipAsyncContext);
            Assert.assertEquals((long)2L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isErrorStatus());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getOutMessage());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getFault());
            Assert.assertNotNull((Object)eipAsyncContext.getOriginalExchange().getError());
            XMLComparator.isEquivalent((String)XMLPrettyPrinter.prettyPrint((Document)this.fault1), (String)eipAsyncContext.getOriginalExchange().getError().getMessage());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOutWithInOnlyConsumesWithDone() {
        try {
            this.abstractMEPBridgeWithUnicConsumesPattern.init();
            this.context.getExchangeList().clear();
            List<Consumes> consumesList = this.getConsumesList(MEPType.IN_ONLY);
            this.context.setConsumeList(consumesList);
            ExchangeImplMock originalExchange = this.createExchange(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, this.in1, null, null, null);
            CommonAsyncContext eipAsyncContext = new CommonAsyncContext((Exchange)originalExchange, Long.valueOf(600000L), this.abstractMEPBridgeWithUnicConsumesPattern.getName(), consumesList.size(), false, false, false);
            this.processAsyncStreamTest(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.DONE, null, null, null, null, (AbstractPattern)this.abstractMEPBridgeWithUnicConsumesPattern, eipAsyncContext);
            Assert.assertEquals((long)1L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isActiveStatus());
            Assert.assertNotNull((Object)eipAsyncContext.getOriginalExchange().getOutMessage());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getFault());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getError());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.out2).replace(VIRTUAL_NAMESPACE, this.abstractMEPBridgeWithUnicConsumesPattern.getNameSpace()).replace(VIRTUAL_NAME, this.abstractMEPBridgeWithUnicConsumesPattern.getName()), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)eipAsyncContext.getOriginalExchange().getOutMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOutWithInOnlyConsumesWithError() {
        try {
            this.abstractMEPBridgeWithUnicConsumesPattern.init();
            this.context.getExchangeList().clear();
            List<Consumes> consumesList = this.getConsumesList(MEPType.IN_ONLY);
            this.context.setConsumeList(consumesList);
            ExchangeImplMock originalExchange = this.createExchange(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, this.in1, null, null, null);
            CommonAsyncContext eipAsyncContext = new CommonAsyncContext((Exchange)originalExchange, Long.valueOf(600000L), this.abstractMEPBridgeWithUnicConsumesPattern.getName(), consumesList.size(), false, false, false);
            this.processAsyncStreamTest(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ERROR, null, null, null, (Exception)((Object)new MessagingException("test exception")), (AbstractPattern)this.abstractMEPBridgeWithUnicConsumesPattern, eipAsyncContext);
            Assert.assertEquals((long)1L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isActiveStatus());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getFault());
            Assert.assertNotNull((Object)eipAsyncContext.getOriginalExchange().getError());
            Assert.assertEquals((Object)"javax.jbi.messaging.MessagingException: test exception", (Object)eipAsyncContext.getOriginalExchange().getError().getMessage());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOutWithRobustInOnlyConsumesWithDone() {
        try {
            this.abstractMEPBridgeWithUnicConsumesPattern.init();
            this.context.getExchangeList().clear();
            List<Consumes> consumesList = this.getConsumesList(MEPType.IN_ONLY);
            this.context.setConsumeList(consumesList);
            ExchangeImplMock originalExchange = this.createExchange(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, this.in1, null, null, null);
            CommonAsyncContext eipAsyncContext = new CommonAsyncContext((Exchange)originalExchange, Long.valueOf(600000L), this.abstractMEPBridgeWithUnicConsumesPattern.getName(), consumesList.size(), false, false, false);
            this.processAsyncStreamTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.DONE, null, null, null, null, (AbstractPattern)this.abstractMEPBridgeWithUnicConsumesPattern, eipAsyncContext);
            Assert.assertEquals((long)1L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isActiveStatus());
            Assert.assertNotNull((Object)eipAsyncContext.getOriginalExchange().getOutMessage());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getFault());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getError());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.out2).replace(VIRTUAL_NAMESPACE, this.abstractMEPBridgeWithUnicConsumesPattern.getNameSpace()).replace(VIRTUAL_NAME, this.abstractMEPBridgeWithUnicConsumesPattern.getName()), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)eipAsyncContext.getOriginalExchange().getOutMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOutWithRobustInOnlyConsumesWithError() {
        try {
            this.abstractMEPBridgeWithUnicConsumesPattern.init();
            this.context.getExchangeList().clear();
            List<Consumes> consumesList = this.getConsumesList(MEPType.IN_ONLY);
            this.context.setConsumeList(consumesList);
            ExchangeImplMock originalExchange = this.createExchange(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, this.in1, null, null, null);
            CommonAsyncContext eipAsyncContext = new CommonAsyncContext((Exchange)originalExchange, Long.valueOf(600000L), this.abstractMEPBridgeWithUnicConsumesPattern.getName(), consumesList.size(), false, false, false);
            this.processAsyncStreamTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ERROR, null, null, null, (Exception)((Object)new MessagingException("test exception")), (AbstractPattern)this.abstractMEPBridgeWithUnicConsumesPattern, eipAsyncContext);
            Assert.assertEquals((long)1L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isActiveStatus());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getFault());
            Assert.assertNotNull((Object)eipAsyncContext.getOriginalExchange().getError());
            Assert.assertEquals((Object)"javax.jbi.messaging.MessagingException: test exception", (Object)eipAsyncContext.getOriginalExchange().getError().getMessage());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOutWithRobustInOnlyConsumesWithFault() {
        try {
            this.abstractMEPBridgeWithUnicConsumesPattern.init();
            this.context.getExchangeList().clear();
            List<Consumes> consumesList = this.getConsumesList(MEPType.IN_ONLY);
            this.context.setConsumeList(consumesList);
            ExchangeImplMock originalExchange = this.createExchange(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, this.in1, null, null, null);
            CommonAsyncContext eipAsyncContext = new CommonAsyncContext((Exchange)originalExchange, Long.valueOf(600000L), this.abstractMEPBridgeWithUnicConsumesPattern.getName(), consumesList.size(), false, false, false);
            this.processAsyncStreamTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ACTIVE, null, null, this.fault1, null, (AbstractPattern)this.abstractMEPBridgeWithUnicConsumesPattern, eipAsyncContext);
            Assert.assertEquals((long)2L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isActiveStatus());
            Assert.assertNotNull((Object)eipAsyncContext.getOriginalExchange().getFault());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getError());
            String result = XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)eipAsyncContext.getOriginalExchange().getFault().getContent()));
            XMLComparator.isEquivalent((String)XMLPrettyPrinter.prettyPrint((Document)this.fault1), (String)result);
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOutWithRobustInOnlyConsumesWithFaultAndFaultToException() {
        try {
            this.abstractMEPBridgeWithUnicConsumesPattern.init();
            this.context.getExchangeList().clear();
            List<Consumes> consumesList = this.getConsumesList(MEPType.IN_ONLY);
            this.context.setConsumeList(consumesList);
            ExchangeImplMock originalExchange = this.createExchange(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, this.in1, null, null, null);
            CommonAsyncContext eipAsyncContext = new CommonAsyncContext((Exchange)originalExchange, Long.valueOf(600000L), this.abstractMEPBridgeWithUnicConsumesPattern.getName(), consumesList.size(), false, false, true);
            this.processAsyncStreamTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ACTIVE, null, null, this.fault1, null, (AbstractPattern)this.abstractMEPBridgeWithUnicConsumesPattern, eipAsyncContext);
            Assert.assertEquals((long)2L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isActiveStatus());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getFault());
            Assert.assertNotNull((Object)eipAsyncContext.getOriginalExchange().getError());
            XMLComparator.isEquivalent((String)XMLPrettyPrinter.prettyPrint((Document)this.fault1), (String)eipAsyncContext.getOriginalExchange().getError().getMessage());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOutWithInOutConsumesWithOut() {
        try {
            this.abstractMEPBridgeWithUnicConsumesPattern.init();
            this.context.getExchangeList().clear();
            List<Consumes> consumesList = this.getConsumesList(MEPType.IN_ONLY);
            this.context.setConsumeList(consumesList);
            ExchangeImplMock originalExchange = this.createExchange(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, this.in1, null, null, null);
            CommonAsyncContext eipAsyncContext = new CommonAsyncContext((Exchange)originalExchange, Long.valueOf(600000L), this.abstractMEPBridgeWithUnicConsumesPattern.getName(), consumesList.size(), false, false, false);
            this.processAsyncStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ACTIVE, null, this.out1, null, null, (AbstractPattern)this.abstractMEPBridgeWithUnicConsumesPattern, eipAsyncContext);
            Assert.assertEquals((long)2L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isActiveStatus());
            Assert.assertNotNull((Object)eipAsyncContext.getOriginalExchange().getOutMessage());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getFault());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getError());
            String result = XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)eipAsyncContext.getOriginalExchange().getOutMessage().getContent()));
            XMLComparator.isEquivalent((String)XMLPrettyPrinter.prettyPrint((Document)this.out1), (String)result);
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOutWithInOutConsumesWithFaultAndFaultToException() {
        try {
            this.abstractMEPBridgeWithUnicConsumesPattern.init();
            this.context.getExchangeList().clear();
            List<Consumes> consumesList = this.getConsumesList(MEPType.IN_ONLY);
            this.context.setConsumeList(consumesList);
            ExchangeImplMock originalExchange = this.createExchange(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, this.in1, null, null, null);
            CommonAsyncContext eipAsyncContext = new CommonAsyncContext((Exchange)originalExchange, Long.valueOf(600000L), this.abstractMEPBridgeWithUnicConsumesPattern.getName(), consumesList.size(), false, false, true);
            this.processAsyncStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ACTIVE, null, null, this.fault1, null, (AbstractPattern)this.abstractMEPBridgeWithUnicConsumesPattern, eipAsyncContext);
            Assert.assertEquals((long)2L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isActiveStatus());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getFault());
            Assert.assertNotNull((Object)eipAsyncContext.getOriginalExchange().getError());
            XMLComparator.isEquivalent((String)XMLPrettyPrinter.prettyPrint((Document)this.fault1), (String)eipAsyncContext.getOriginalExchange().getError().getMessage());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOutWithInOutConsumesWithFault() {
        try {
            this.abstractMEPBridgeWithUnicConsumesPattern.init();
            this.context.getExchangeList().clear();
            List<Consumes> consumesList = this.getConsumesList(MEPType.IN_ONLY);
            this.context.setConsumeList(consumesList);
            ExchangeImplMock originalExchange = this.createExchange(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, this.in1, null, null, null);
            CommonAsyncContext eipAsyncContext = new CommonAsyncContext((Exchange)originalExchange, Long.valueOf(600000L), this.abstractMEPBridgeWithUnicConsumesPattern.getName(), consumesList.size(), false, false, false);
            this.processAsyncStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ACTIVE, null, null, this.fault1, null, (AbstractPattern)this.abstractMEPBridgeWithUnicConsumesPattern, eipAsyncContext);
            Assert.assertEquals((long)2L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isActiveStatus());
            Assert.assertNotNull((Object)eipAsyncContext.getOriginalExchange().getFault());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getError());
            String result = XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)eipAsyncContext.getOriginalExchange().getFault().getContent()));
            XMLComparator.isEquivalent((String)XMLPrettyPrinter.prettyPrint((Document)this.fault1), (String)result);
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testInit() {
        try {
            this.abstractMEPBridgeWithUnicConsumesPattern.init();
        }
        catch (Throwable t) {
            Assert.fail((String)("An error occurs: " + t.getMessage()));
        }
    }

    @Override
    public List<Param> getParamList() {
        return new CopyOnWriteArrayList<Param>();
    }

    private List<Consumes> getConsumesList(MEPType mepType) {
        CopyOnWriteArrayList<Consumes> consumesList = new CopyOnWriteArrayList<Consumes>();
        QName interfaceName = null;
        QName serviceName = null;
        String endpoint = null;
        interfaceName = new QName("http://petals.ow2.org", "interface");
        serviceName = new QName("http://petals.ow2.org", "serviceConsumer");
        endpoint = "8b32ee51-9b7b-4a09-8805-99733c1efc9a";
        Consumes consumes = new Consumes();
        consumes.setMep(mepType);
        consumes.setInterfaceName(interfaceName);
        consumes.setServiceName(serviceName);
        consumes.setEndpointName(endpoint);
        consumes.setOperation(new QName("http://petals.ow2.org", "test1"));
        consumesList.add(consumes);
        return consumesList;
    }
}

