/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.se.eip.patterns;

import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.xpath.XPathExpressionException;
import org.ow2.petals.commons.exception.ExceptionUtil;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.jbidescriptor.generated.Consumes;
import org.ow2.petals.component.framework.util.ExchangeUtil;
import org.ow2.petals.component.framework.util.SourceUtil;
import org.ow2.petals.se.eip.ExchangeContext;
import org.ow2.petals.se.eip.async.CommonAsyncContext;
import org.ow2.petals.se.eip.patterns.AbstractPattern;
import org.ow2.petals.se.eip.patterns.PatternHelper;
import org.w3c.dom.Document;

public class Aggregator
extends AbstractPattern {
    public static final String AGGREGATOR_NAMESPACE = "http://petals.ow2.org/components/eip/version-2/aggregator";
    private final Map<String, List<NormalizedMessage>> inMessagesMap = new ConcurrentHashMap<String, List<NormalizedMessage>>();

    private static final Source buildContent(List<NormalizedMessage> inMessagesList, ExchangeContext context) throws MessagingException, PEtALSCDKException {
        Document aggregatedDocument = null;
        for (NormalizedMessage inMessage : inMessagesList) {
            aggregatedDocument = PatternHelper.aggregateContent(inMessage, aggregatedDocument, "result", AGGREGATOR_NAMESPACE);
        }
        return SourceUtil.createDOMSource(aggregatedDocument);
    }

    @Override
    public String getName() {
        return "Aggregator";
    }

    @Override
    public String getNameSpace() {
        return AGGREGATOR_NAMESPACE;
    }

    @Override
    public void init() {
    }

    @Override
    public boolean process(Exchange exchange, ExchangeContext context) {
        try {
            List<Consumes> consumes = context.getSUConsumes(exchange.getEndpoint());
            if (consumes != null && consumes.size() == 1) {
                Document inMessageContent = SourceUtil.createDocument((Source)exchange.getInMessage().getContent());
                exchange.getInMessage().setContent((Source)new DOMSource(inMessageContent));
                String correlationID = this.retrieveCorrelationId(inMessageContent, exchange, context);
                if (correlationID != null) {
                    boolean complete = this.isComplete(inMessageContent, context);
                    if (!this.inMessagesMap.containsKey(correlationID) && !complete) {
                        this.inMessagesMap.put(correlationID, new CopyOnWriteArrayList());
                    }
                    if (complete) {
                        Exchange response;
                        if (this.logger.isLoggable(Level.FINE)) {
                            this.logger.fine(this.getName() + ": sequence is complete");
                        }
                        if ((response = this.sendAggregatedMessage(exchange, correlationID, context, consumes.get(0))) != null) {
                            NormalizedMessage receivedMessage = PatternHelper.processSentExchange(response, context);
                            if (receivedMessage != null) {
                                if (receivedMessage instanceof Fault && !exchange.isInOnlyPattern()) {
                                    exchange.setFault((Fault)receivedMessage);
                                } else if (!exchange.isInOnlyPattern() && !exchange.isRobustInOnlyPattern()) {
                                    exchange.setOutMessage(receivedMessage);
                                }
                            }
                        } else {
                            exchange.setError((Exception)((Object)new MessagingException("Timeout occurred, no reponse has been received from the target service")));
                        }
                    } else {
                        if (this.logger.isLoggable(Level.FINE)) {
                            this.logger.fine(this.getName() + ": storing exchange '" + exchange.getExchangeId() + "' for correlation '" + correlationID + "'");
                        }
                        this.inMessagesMap.get(correlationID).add(exchange.getInMessage());
                        if (this.logger.isLoggable(Level.FINE)) {
                            this.logger.fine(this.getName() + ": sequence size is : " + this.inMessagesMap.get(correlationID).size());
                        }
                        if (exchange.isInOutPattern() || exchange.isInOptionalOutPattern()) {
                            Document document = PatternHelper.createResultDocument(AGGREGATOR_NAMESPACE);
                            document.getDocumentElement().setTextContent(this.getName() + ": the content is buffered by the pattern");
                            exchange.getOutMessage().setContent((Source)SourceUtil.createStreamSource((Document)document));
                        }
                    }
                } else {
                    exchange.setError((Exception)((Object)new MessagingException(this.getName() + ": no correlation id found in the message")));
                }
            } else {
                exchange.setError((Exception)((Object)new MessagingException(this.getName() + ": the Service Unit must define 1 Consumes section")));
            }
        }
        catch (MessagingException e) {
            exchange.setError((Exception)((Object)e));
        }
        catch (XPathExpressionException e) {
            exchange.setError((Exception)e);
        }
        catch (PEtALSCDKException e) {
            exchange.setError((Exception)((Object)new MessagingException(ExceptionUtil.getExtendedMessage((Exception)((Object)e)))));
        }
        return true;
    }

    @Override
    public boolean processAsync(Exchange exchange, ExchangeContext context, CommonAsyncContext asyncContext) {
        exchange.setError((Exception)((Object)new MessagingException(this.getName() + ": the pattern doesn't process the asynchronous exchanges")));
        return true;
    }

    @Override
    public boolean validateMEP(URI pattern) {
        return true;
    }

    private boolean isComplete(Document document, ExchangeContext context) throws XPathExpressionException {
        boolean result = false;
        String condition = context.getExtensions().get((Object)"test");
        result = PatternHelper.evaluateXPathCondition(condition, document.getDocumentElement());
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine(this.getName() + ": evaluation of condition: \"" + condition + "\", result: \"" + Boolean.toString(result) + "\".");
        }
        return result;
    }

    private String retrieveCorrelationId(Document inMessage, Exchange exchange, ExchangeContext context) throws XPathExpressionException {
        String result = null;
        String expression = context.getExtensions().get((Object)"aggregator-correlation");
        result = PatternHelper.evaluateXPathExpressionAsString(expression, inMessage);
        if (result != null) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine(this.getName() + ": evaluation of condition '" + expression + "', result '" + result + "'");
            }
            if (Boolean.FALSE.toString().equals(result) || result.isEmpty()) {
                result = null;
            }
        }
        return result;
    }

    private Exchange sendAggregatedMessage(Exchange exchange, String correlationId, ExchangeContext context, Consumes consumes) throws MessagingException, PEtALSCDKException {
        List<NormalizedMessage> inMessageList = this.inMessagesMap.get(correlationId);
        if (inMessageList == null) {
            throw new MessagingException(this.getName() + ": no sequence found for the correlation " + correlationId);
        }
        Source content = Aggregator.buildContent(inMessageList, context);
        Exchange response = this.sendExchange(exchange, correlationId, consumes, content, context);
        this.inMessagesMap.remove(correlationId);
        return response;
    }

    private Exchange sendExchange(Exchange exchange, String correlationId, Consumes consumes, Source content, ExchangeContext context) throws MessagingException, PEtALSCDKException {
        Exchange newExchange = context.createConsumeExchange(consumes);
        if (newExchange.getOperation() == null) {
            newExchange.setOperation(exchange.getOperation());
        }
        ExchangeUtil.copyExchangeProperties((Exchange)exchange, (Exchange)newExchange);
        List<NormalizedMessage> inMessageList = this.inMessagesMap.get(correlationId);
        for (NormalizedMessage inMessage : inMessageList) {
            PatternHelper.copy(inMessage, newExchange.getInMessage(), false, true, true, true);
        }
        newExchange.setInMessageContent(content);
        this.logSend(consumes, newExchange);
        if (!context.sendSync(newExchange)) {
            newExchange = null;
        }
        return newExchange;
    }
}

