/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.se.eip.patterns;

import java.net.URI;
import java.util.List;
import java.util.logging.Level;
import javax.jbi.messaging.MessagingException;
import org.ow2.petals.commons.exception.ExceptionUtil;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.jbidescriptor.generated.Consumes;
import org.ow2.petals.component.framework.util.ExchangeUtil;
import org.ow2.petals.se.eip.ExchangeContext;
import org.ow2.petals.se.eip.async.CommonAsyncContext;
import org.ow2.petals.se.eip.patterns.AbstractMEPBridgeWithUnicConsumesPattern;
import org.ow2.petals.se.eip.patterns.PatternHelper;

public class Bridge
extends AbstractMEPBridgeWithUnicConsumesPattern {
    public static final String BRIDGE_NAMESPACE = "http://petals.ow2.org/components/eip/version-2/bridge";

    @Override
    public boolean process(Exchange exchange, ExchangeContext context) {
        try {
            List<Consumes> consumesList = context.getSUConsumes(exchange.getEndpoint());
            if (consumesList != null && consumesList.size() == 1) {
                Consumes consumes = consumesList.get(0);
                Exchange newExchange = context.createConsumeExchange(consumes);
                if (newExchange.getOperation() == null) {
                    newExchange.setOperation(exchange.getOperation());
                }
                PatternHelper.copy(exchange.getInMessage(), newExchange.getInMessage());
                ExchangeUtil.copyExchangeProperties((Exchange)exchange, (Exchange)newExchange);
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine(this.getName() + ": the source MEP is " + exchange.getPattern());
                    this.logger.fine(this.getName() + ": the target MEP is " + newExchange.getPattern());
                }
                this.logSend(consumes, newExchange);
                boolean faultRobust = this.isFaultToException(context.getExtensions());
                CommonAsyncContext asyncContext = new CommonAsyncContext(exchange, 600000L, this.getName(), 1, false, false, faultRobust);
                context.sendAsync(newExchange, asyncContext);
            } else {
                exchange.setError((Exception)((Object)new MessagingException(this.getName() + ": the Service Unit must define 1 Consumes section")));
            }
        }
        catch (MessagingException e) {
            exchange.setError((Exception)((Object)e));
        }
        catch (PEtALSCDKException e) {
            exchange.setError((Exception)((Object)new MessagingException(ExceptionUtil.getExtendedMessage((Exception)((Object)e)))));
        }
        return false;
    }

    @Override
    public void init() {
    }

    @Override
    public String getName() {
        return "Bridge";
    }

    @Override
    public boolean validateMEP(URI mep) {
        return true;
    }

    @Override
    public String getNameSpace() {
        return BRIDGE_NAMESPACE;
    }
}

