/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.se.eip.patterns;

import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.logging.Level;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.ow2.petals.commons.exception.ExceptionUtil;
import org.ow2.petals.component.framework.api.Message;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.jbidescriptor.generated.Consumes;
import org.ow2.petals.component.framework.util.ExchangeUtil;
import org.ow2.petals.component.framework.util.SourceUtil;
import org.ow2.petals.se.eip.ExchangeContext;
import org.ow2.petals.se.eip.async.CommonAsyncContext;
import org.ow2.petals.se.eip.patterns.AbstractMEPBridgePattern;
import org.ow2.petals.se.eip.patterns.PatternHelper;

public class Dispatcher
extends AbstractMEPBridgePattern {
    public static final String DISPATCHER_NAMESPACE = "http://petals.ow2.org/components/eip/version-2/dispatcher";

    @Override
    public boolean process(Exchange exchange, ExchangeContext context) {
        try {
            List<Consumes> consumesList = context.getSUConsumes(exchange.getEndpoint());
            if (consumesList != null && consumesList.size() != 0) {
                this.logger.fine("Begin asynchronous exchanges send to consumes for exchange[" + exchange.getExchangeId() + "]");
                this.sendAsyncExchanges(consumesList, exchange, context);
            } else {
                this.logger.warning("No consume section was define for service unit");
                exchange.setError((Exception)((Object)new MessagingException(this.getName() + ": the Service Unit must define at least 1 Consumes sections for the pattern ")));
            }
        }
        catch (PEtALSCDKException e) {
            this.logger.log(Level.WARNING, "PEtALSCDKException occurred during Dispatcher processing for [" + exchange.getExchangeId() + "] exchange", e);
            exchange.setError((Exception)((Object)new MessagingException(ExceptionUtil.getExtendedMessage((Exception)((Object)e)))));
        }
        catch (MessagingException e) {
            this.logger.log(Level.WARNING, "MessagingException occurred during Dispatcher processing for [" + exchange.getExchangeId() + "] exchange", e);
            exchange.setError((Exception)((Object)e));
        }
        return false;
    }

    @Override
    public boolean validateMEP(URI uri) {
        return Message.MEPConstants.IN_ONLY_PATTERN.equals(uri);
    }

    private void sendAsyncExchanges(List<Consumes> consumesList, Exchange exchange, ExchangeContext context) throws PEtALSCDKException, MessagingException {
        boolean faultToException = this.isFaultToException(context.getExtensions());
        CommonAsyncContext asyncContext = new CommonAsyncContext(exchange, 600000L, this.getName(), consumesList.size(), false, false, faultToException);
        NormalizedMessage inMessage = exchange.getInMessage();
        InputStream inMessageAsStream = PatternHelper.handleStreamSource(inMessage);
        this.logger.fine("Begin " + this.getName() + " sendAsyncExchange() for exchange[" + exchange.getExchangeId() + "] with FaultToException policy: " + faultToException + " and default time to live: " + 600000L);
        for (Consumes toConsume : consumesList) {
            Exchange dipatchedExchange = context.createConsumeExchange(toConsume);
            if (dipatchedExchange.getOperation() == null) {
                dipatchedExchange.setOperation(exchange.getOperation());
            }
            PatternHelper.copy(inMessage, dipatchedExchange.getInMessage());
            ExchangeUtil.copyExchangeProperties((Exchange)exchange, (Exchange)dipatchedExchange);
            this.logSend(toConsume, dipatchedExchange);
            context.sendAsync(dipatchedExchange, asyncContext);
            if (inMessageAsStream == null) continue;
            inMessage.setContent((Source)new StreamSource(inMessageAsStream));
            inMessageAsStream = PatternHelper.handleStreamSource(inMessage);
        }
    }

    @Override
    public void init() {
    }

    @Override
    public String getName() {
        return "Dispatcher";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processAsync(Exchange exchange, ExchangeContext context, CommonAsyncContext asyncContext) {
        block17: {
            try {
                int subMessages = asyncContext.decrementAndGetOngoingSubMessages();
                this.logger.fine(subMessages + " sub messages wait for process async for exchange[" + exchange.getExchangeId() + "]");
                if (subMessages == 0) {
                    this.logger.fine("No sub message wait for process async");
                    this.processResponse(exchange, context, asyncContext);
                } else {
                    NormalizedMessage receivedMessage = PatternHelper.processSentExchange(exchange, context);
                    if (!asyncContext.isTerminated() && receivedMessage != null && receivedMessage instanceof Fault) {
                        this.logger.fine("Received message is a Fault and is not terminated");
                        if (asyncContext.isFaultToException()) {
                            asyncContext.getOriginalExchange().setError((Exception)((Object)new MessagingException(SourceUtil.createString((Source)receivedMessage.getContent()))));
                            this.logger.fine("The asynchrone context handle a FaultToException and return to the original exchange the following MessageException: " + asyncContext.getOriginalExchange().getError().getMessage());
                            context.send(asyncContext.getOriginalExchange());
                            asyncContext.setTerminated();
                        }
                    }
                }
            }
            catch (MessagingException e) {
                if (asyncContext.isTerminated()) break block17;
                this.logger.warning("Messaging exception was catched: " + e.getMessage() + " and " + "the async context isn't terminated, so the original exchange must" + " be terminate by an error");
                asyncContext.getOriginalExchange().setError((Exception)((Object)e));
                try {
                    context.send(asyncContext.getOriginalExchange());
                }
                catch (MessagingException e1) {
                    this.logger.warning(this.getName() + ": unable to close the source exchange on error status");
                }
                finally {
                    asyncContext.setTerminated();
                }
            }
            catch (PEtALSCDKException e) {
                if (asyncContext.isTerminated()) break block17;
                this.logger.warning("PEtALSCDK exception was catched: " + e.getMessage() + " and " + "the async context isn't terminated, so the original exchange must" + " be terminate by an error");
                asyncContext.getOriginalExchange().setError((Exception)((Object)new MessagingException(ExceptionUtil.getExtendedMessage((Exception)((Object)e)))));
                try {
                    context.send(asyncContext.getOriginalExchange());
                }
                catch (MessagingException e1) {
                    this.logger.warning(this.getName() + ": unable to close the source exchange on error status");
                }
                finally {
                    asyncContext.setTerminated();
                }
            }
        }
        return true;
    }

    @Override
    public String getNameSpace() {
        return DISPATCHER_NAMESPACE;
    }
}

