/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.se.eip.patterns;

import com.ebmwebsourcing.easycommons.lang.StringHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.jbi.JBIException;
import javax.jbi.messaging.MessagingException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPathExpressionException;
import org.ow2.petals.commons.exception.ExceptionUtil;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.jbidescriptor.generated.Consumes;
import org.ow2.petals.component.framework.util.ExchangeUtil;
import org.ow2.petals.component.framework.util.SourceUtil;
import org.ow2.petals.se.eip.ExchangeContext;
import org.ow2.petals.se.eip.async.CommonAsyncContext;
import org.ow2.petals.se.eip.patterns.AbstractAggregatorPattern;
import org.ow2.petals.se.eip.patterns.PatternHelper;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class Splitter
extends AbstractAggregatorPattern {
    private static final String SPLITTER_NAMESPACE = "http://petals.ow2.org/components/eip/version-2/splitter";

    @Override
    public String getName() {
        return "Splitter";
    }

    @Override
    public boolean process(Exchange exchange, ExchangeContext context) {
        boolean send = false;
        boolean reply = false;
        try {
            List<Consumes> consumesList = context.getSUConsumes(exchange.getEndpoint());
            if (consumesList != null && consumesList.size() == 1) {
                Consumes consumes = consumesList.get(0);
                ArrayList<Source> splittedSources = null;
                if (!this.isAttachmentMode(context.getExtensions())) {
                    String splitterPath = context.getExtensions().get((Object)"test");
                    if (!StringHelper.isNullOrEmpty((String)splitterPath)) {
                        Document inMessageContent;
                        NodeList nodeList;
                        if (this.logger != null && this.logger.isLoggable(Level.FINE)) {
                            this.logger.fine(this.getName() + ": splitting XPath : " + splitterPath);
                        }
                        if ((nodeList = PatternHelper.evaluateXPathExpressionAsNodeList(splitterPath, inMessageContent = SourceUtil.createDocument((Source)exchange.getInMessage().getContent()))) != null && nodeList.getLength() != 0) {
                            if (this.logger != null && this.logger.isLoggable(Level.FINE)) {
                                this.logger.fine(this.getName() + ": splitted elements : " + nodeList.getLength());
                            }
                            splittedSources = new ArrayList(nodeList.getLength());
                            for (int i = 0; i < nodeList.getLength(); ++i) {
                                splittedSources.add(new DOMSource(nodeList.item(i)));
                                send = true;
                            }
                        } else {
                            exchange.setError((Exception)((Object)new MessagingException(this.getName() + ": no element to process found")));
                            reply = true;
                        }
                    } else {
                        exchange.setError((Exception)((Object)new MessagingException(this.getName() + ": the Service Unit must define an element " + "test")));
                        reply = true;
                    }
                } else if (exchange.getInMessageAttachments() != null && !exchange.getInMessageAttachments().isEmpty()) {
                    splittedSources = new ArrayList<Source>(exchange.getInMessageAttachments().size());
                    for (DataHandler dataHandler : exchange.getInMessageAttachments()) {
                        String name = dataHandler.getName();
                        String type = dataHandler.getContentType();
                        if (this.logger != null && this.logger.isLoggable(Level.FINE)) {
                            this.logger.fine(this.getName() + ": type of the current attachment " + name + ": " + type);
                        }
                        if ("application/xml".equals(type)) {
                            DataSource content = dataHandler.getDataSource();
                            splittedSources.add(new StreamSource(content.getInputStream()));
                            send = true;
                            continue;
                        }
                        this.logger.info(this.getName() + ": the attachment " + name + " with " + type + " as type is ignored. It must be an application/xml type to be process");
                    }
                } else {
                    this.logger.info(this.getName() + ": no attachment to process found");
                }
                if (send) {
                    boolean faultRobust = this.isFaultRobust(context.getExtensions());
                    boolean errorRobust = this.isExceptionRobust(context.getExtensions());
                    CommonAsyncContext asyncContext = new CommonAsyncContext(exchange, 600000L, this.getName(), splittedSources.size(), faultRobust, errorRobust, false);
                    for (Source splittedSource : splittedSources) {
                        Exchange splittedExchange = context.createConsumeExchange(consumes);
                        if (splittedExchange.getOperation() == null) {
                            splittedExchange.setOperation(exchange.getOperation());
                        }
                        PatternHelper.copy(exchange.getInMessage(), splittedExchange.getInMessage());
                        splittedExchange.getInMessage().setContent(splittedSource);
                        ExchangeUtil.copyExchangeProperties((Exchange)exchange, (Exchange)splittedExchange);
                        this.logSend(consumes, splittedExchange);
                        context.sendAsync(splittedExchange, asyncContext);
                    }
                }
            } else {
                exchange.setError((Exception)((Object)new JBIException(this.getName() + ": the Service Unit must define 1 Consumes section")));
                reply = true;
            }
        }
        catch (MessagingException e) {
            exchange.setError((Exception)((Object)e));
            reply = true;
        }
        catch (XPathExpressionException e) {
            exchange.setError((Exception)e);
            reply = true;
        }
        catch (IOException e) {
            exchange.setError((Exception)e);
            reply = true;
        }
        catch (PEtALSCDKException e) {
            exchange.setError((Exception)((Object)new MessagingException(ExceptionUtil.getExtendedMessage((Exception)((Object)e)))));
            reply = true;
        }
        return reply;
    }

    @Override
    public void init() {
    }

    @Override
    public String getNameSpace() {
        return SPLITTER_NAMESPACE;
    }
}

