/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.se.eip;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;
import org.ow2.petals.component.framework.se.AbstractServiceEngine;
import org.ow2.petals.se.eip.patterns.Pattern;

public class EIPComponent
extends AbstractServiceEngine {
    private Map<String, Pattern> patterns;

    public void doInit() {
        this.getLogger().info("Initialize the EIP Service Engine.");
        this.patterns = new HashMap<String, Pattern>();
        ConfigurationExtensions extensions = this.getComponentExtensions();
        Set patternsNames = extensions.keySet();
        for (String name : patternsNames) {
            String patternClassName = extensions.get((Object)name);
            try {
                this.getLogger().finest("Loading the pattern '" + name + "' implemented by '" + patternClassName + "'");
                Class<?> patternClass = ((Object)((Object)this)).getClass().getClassLoader().loadClass(patternClassName);
                Pattern pattern = (Pattern)patternClass.newInstance();
                pattern.init();
                this.patterns.put(name.toString(), pattern);
                this.getLogger().finest("Pattern '" + name + "' has been created.");
            }
            catch (ClassNotFoundException e) {
                this.getLogger().warning("Class '" + patternClassName + "' has not been found.");
            }
            catch (InstantiationException e) {
                this.getLogger().warning("Pattern '" + name + "' can not be instantiated.");
            }
            catch (IllegalAccessException e) {
                this.getLogger().warning("IllegalAccessException " + e.getMessage());
            }
            catch (ClassCastException e) {
                this.getLogger().warning("The class '" + patternClassName + "' does not implement the Pattern interface.");
            }
        }
    }

    public Map<String, Pattern> getPatterns() {
        return this.patterns;
    }
}

