/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.se.eip.patterns;

import java.net.URI;
import java.util.logging.Logger;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.ow2.petals.commons.exception.ExceptionUtil;
import org.ow2.petals.component.framework.api.Message;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.util.SourceUtil;
import org.ow2.petals.se.eip.ExchangeContext;
import org.ow2.petals.se.eip.async.CommonAsyncContext;
import org.ow2.petals.se.eip.patterns.AbstractPattern;
import org.ow2.petals.se.eip.patterns.PatternHelper;
import org.w3c.dom.Document;

public abstract class AbstractAggregatorPattern
extends AbstractPattern {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processAsync(Exchange exchange, ExchangeContext context, CommonAsyncContext asyncContext) {
        NormalizedMessage receivedMessage = null;
        boolean finished = false;
        if (this.logger == null) {
            this.logger = context.getLogger();
            if (this.logger == null) {
                this.logger = Logger.getLogger(AbstractPattern.class.getName());
            }
        }
        Exchange exchange2 = asyncContext.getOriginalExchange();
        synchronized (exchange2) {
            block38: {
                try {
                    int subMessages = asyncContext.decrementAndGetOngoingSubMessages();
                    if (subMessages == 0) {
                        finished = true;
                    }
                    receivedMessage = PatternHelper.processSentExchange(exchange, context);
                    if (!asyncContext.isTerminated()) {
                        if (receivedMessage != null) {
                            if (receivedMessage instanceof Fault) {
                                if (!asyncContext.isFaultRobust()) {
                                    if (asyncContext.getOriginalExchange().getFault() == null && asyncContext.getOriginalExchange().getError() == null) {
                                        asyncContext.getOriginalExchange().setFault((Fault)receivedMessage);
                                        finished = true;
                                    }
                                } else {
                                    this.aggregate(asyncContext, receivedMessage);
                                }
                            } else {
                                this.aggregate(asyncContext, receivedMessage);
                            }
                        } else {
                            Document document = this.getAggregatedDocument(asyncContext);
                            if (document == null) {
                                document = PatternHelper.createResultDocument(this.getNameSpace());
                            }
                            asyncContext.getOriginalExchange().getOutMessage().setContent((Source)SourceUtil.createStreamSource((Document)document));
                        }
                    }
                }
                catch (MessagingException e) {
                    if (!asyncContext.isTerminated()) {
                        if (!asyncContext.isExceptionRobust()) {
                            asyncContext.getOriginalExchange().setError((Exception)((Object)e));
                            finished = true;
                        } else {
                            try {
                                this.aggregate(asyncContext, (Exception)((Object)e));
                            }
                            catch (MessagingException e2) {
                                asyncContext.getOriginalExchange().setError((Exception)((Object)e2));
                                finished = true;
                            }
                            catch (PEtALSCDKException e2) {
                                asyncContext.getOriginalExchange().setError((Exception)((Object)new MessagingException(ExceptionUtil.getExtendedMessage((Exception)((Object)e2)))));
                                finished = true;
                            }
                        }
                    }
                }
                catch (PEtALSCDKException e) {
                    if (asyncContext.isTerminated()) break block38;
                    if (!asyncContext.isExceptionRobust()) {
                        asyncContext.getOriginalExchange().setError((Exception)((Object)new MessagingException(ExceptionUtil.getExtendedMessage((Exception)((Object)e)))));
                        finished = true;
                    }
                    try {
                        this.aggregate(asyncContext, (Exception)((Object)e));
                    }
                    catch (MessagingException e2) {
                        asyncContext.getOriginalExchange().setError((Exception)((Object)e2));
                        finished = true;
                    }
                    catch (PEtALSCDKException e2) {
                        asyncContext.getOriginalExchange().setError((Exception)((Object)new MessagingException(ExceptionUtil.getExtendedMessage((Exception)((Object)e2)))));
                        finished = true;
                    }
                }
            }
            if (finished) {
                this.logger.fine(this.getName() + ": terminate the pattern");
                if (!asyncContext.isTerminated()) {
                    try {
                        if (asyncContext.getOriginalExchange().getFault() == null && asyncContext.getOriginalExchange().getError() == null) {
                            Document document = SourceUtil.createDocument((Source)asyncContext.getOriginalExchange().getOutMessage().getContent());
                            document.normalizeDocument();
                            asyncContext.getOriginalExchange().getOutMessage().setContent((Source)SourceUtil.createStreamSource((Document)document));
                        }
                        context.send(asyncContext.getOriginalExchange());
                    }
                    catch (MessagingException e) {
                        this.logger.warning(this.getName() + ": unable to send an exchange, " + e.getMessage());
                    }
                    catch (PEtALSCDKException e) {
                        this.logger.warning(this.getName() + ": unable to send an exchange, " + e.getMessage());
                    }
                    finally {
                        asyncContext.setTerminated();
                    }
                }
            }
        }
        return false;
    }

    private void aggregate(CommonAsyncContext asyncContext, Exception exception) throws MessagingException, PEtALSCDKException {
        Document aggregatedDocument = this.getAggregatedDocument(asyncContext);
        Document itemDocument = PatternHelper.createExceptionDocument(this.getNameSpace());
        if (itemDocument != null) {
            itemDocument.getDocumentElement().setTextContent(exception.getMessage());
            aggregatedDocument = PatternHelper.aggregateContent(itemDocument, aggregatedDocument, "result", this.getNameSpace());
            asyncContext.getOriginalExchange().getOutMessage().setContent((Source)SourceUtil.createStreamSource((Document)aggregatedDocument));
        }
    }

    private void aggregate(CommonAsyncContext asyncContext, NormalizedMessage receivedMessage) throws MessagingException, PEtALSCDKException {
        Document aggregatedDocument = this.getAggregatedDocument(asyncContext);
        aggregatedDocument = PatternHelper.aggregateContent(receivedMessage, aggregatedDocument, "result", this.getNameSpace());
        StreamSource source = SourceUtil.createStreamSource((Document)aggregatedDocument);
        asyncContext.getOriginalExchange().getOutMessage().setContent((Source)source);
        PatternHelper.copyAttachments(receivedMessage, asyncContext.getOriginalExchange().getOutMessage());
        PatternHelper.copyProperties(receivedMessage, asyncContext.getOriginalExchange().getOutMessage());
    }

    private Document getAggregatedDocument(CommonAsyncContext asyncContext) throws PEtALSCDKException {
        Source outContent;
        Document aggregatedDocument = null;
        this.logger.fine(this.getName() + ": aggregates a document to the original out message");
        NormalizedMessage normalizedMessage = asyncContext.getOriginalExchange().getOutMessage();
        if (normalizedMessage != null && (outContent = normalizedMessage.getContent()) != null) {
            aggregatedDocument = SourceUtil.createDocument((Source)outContent);
        }
        return aggregatedDocument;
    }

    @Override
    public boolean validateMEP(URI mep) {
        return Message.MEPConstants.IN_OUT_PATTERN.equals(mep);
    }
}

