/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.se.eip.patterns;

import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.logging.Level;
import javax.jbi.JBIException;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPathExpressionException;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.jbidescriptor.generated.Consumes;
import org.ow2.petals.component.framework.util.ExchangeUtil;
import org.ow2.petals.component.framework.util.SourceUtil;
import org.ow2.petals.se.eip.ExchangeContext;
import org.ow2.petals.se.eip.async.CommonAsyncContext;
import org.ow2.petals.se.eip.async.DynamicRouterAsyncContext;
import org.ow2.petals.se.eip.patterns.AbstractMEPBridgePattern;
import org.ow2.petals.se.eip.patterns.PatternHelper;
import org.ow2.petals.se.eip.patterns.XPathRouterEngine;
import org.w3c.dom.Document;

public class DynamicRouter
extends AbstractMEPBridgePattern {
    public static final String DYNAMIC_ROUTER_NAME = "Dynamic-Router";
    public static final String DYNAMIC_ROUTER_NAMESPACE = "http://petals.ow2.org/components/eip/version-2/dynamicRouter";
    private XPathRouterEngine routerEngine;

    @Override
    public boolean process(Exchange exchange, ExchangeContext context) {
        try {
            List<Consumes> consumesList = context.getSUConsumes(exchange.getEndpoint());
            if (consumesList != null) {
                List<String> conditions = this.routerEngine.getXpathParameters(context.getExtensions());
                if (consumesList.size() == conditions.size() + 2) {
                    Consumes conditionService = consumesList.get(0);
                    if (conditionService != null) {
                        InputStream inMessageAsStream = PatternHelper.handleStreamSource(exchange.getInMessage());
                        Exchange conditionExchange = context.createConsumeExchange(conditionService);
                        if (conditionExchange.getOperation() == null) {
                            conditionExchange.setOperation(exchange.getOperation());
                        }
                        PatternHelper.copy(exchange.getInMessage(), conditionExchange.getInMessage());
                        ExchangeUtil.copyExchangeProperties((Exchange)exchange, (Exchange)conditionExchange);
                        if (inMessageAsStream != null) {
                            exchange.getInMessage().setContent((Source)new StreamSource(inMessageAsStream));
                        }
                        boolean faultRobust = this.isFaultToException(context.getExtensions());
                        DynamicRouterAsyncContext asyncContext = new DynamicRouterAsyncContext(exchange, 600000L, faultRobust, consumesList, conditions);
                        context.sendAsync(conditionExchange, asyncContext);
                    } else {
                        exchange.setError((Exception)((Object)new MessagingException(this.getName() + ": the Service Unit must define a valid condition service")));
                    }
                } else {
                    exchange.setError((Exception)((Object)new MessagingException(this.getName() + ": the Service Unit must define (numberOfRoutingParameters+2) Consumes sections")));
                }
            } else {
                exchange.setError((Exception)((Object)new MessagingException(this.getName() + ": the Service Unit must define (numberOfRoutingParameters+2) Consumes sections")));
            }
        }
        catch (JBIException e) {
            exchange.setError((Exception)((Object)e));
        }
        return false;
    }

    @Override
    public String getName() {
        return DYNAMIC_ROUTER_NAME;
    }

    @Override
    public boolean validateMEP(URI mep) {
        return true;
    }

    @Override
    public void init() {
        this.routerEngine = new XPathRouterEngine();
    }

    @Override
    public boolean processAsync(Exchange exchange, ExchangeContext context, CommonAsyncContext asyncContext) {
        try {
            int subMessages = asyncContext.decrementAndGetOngoingSubMessages();
            if (subMessages == 1) {
                this.processRouterResponse(exchange, context, asyncContext);
            } else if (subMessages == 0) {
                this.processResponse(exchange, context, asyncContext);
            } else if (!asyncContext.isTerminated()) {
                asyncContext.getOriginalExchange().setError(new Exception("Terminate the pattern processing due to a bad global routing"));
                context.send(asyncContext.getOriginalExchange());
                asyncContext.setTerminated();
            }
        }
        catch (MessagingException e) {
            this.logger.warning(this.getName() + ": unable to close the source exchange on error status");
        }
        return false;
    }

    @Override
    public String getNameSpace() {
        return DYNAMIC_ROUTER_NAMESPACE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRouterResponse(Exchange exchange, ExchangeContext context, CommonAsyncContext asyncContext) {
        block27: {
            NormalizedMessage receivedMessage = null;
            Document document = null;
            try {
                receivedMessage = PatternHelper.processSentExchange(exchange, context);
                if (asyncContext instanceof DynamicRouterAsyncContext) {
                    if (asyncContext.isTerminated()) break block27;
                    if (this.logger != null && this.logger.isLoggable(Level.FINE)) {
                        this.logger.fine(this.getName() + ": processing the dynamic pattern");
                    }
                    if (receivedMessage != null) {
                        document = SourceUtil.createDocument((Source)receivedMessage.getContent());
                        int consumesIndex = this.routerEngine.route(((DynamicRouterAsyncContext)asyncContext).getConditionList(), document);
                        Consumes consumedService = ((DynamicRouterAsyncContext)asyncContext).getConsumesList().get(consumesIndex + 1);
                        Exchange routedExchange = context.createConsumeExchange(consumedService);
                        if (routedExchange.getOperation() == null) {
                            routedExchange.setOperation(exchange.getOperation());
                        }
                        PatternHelper.copy(asyncContext.getOriginalExchange().getInMessage(), routedExchange.getInMessage());
                        ExchangeUtil.copyExchangeProperties((Exchange)asyncContext.getOriginalExchange(), (Exchange)routedExchange);
                        this.logSend(consumedService, routedExchange);
                        context.sendAsync(routedExchange, asyncContext);
                        break block27;
                    }
                    asyncContext.getOriginalExchange().setError(new Exception("No valid response from the dynamic router service: unable to route"));
                    try {
                        context.send(asyncContext.getOriginalExchange());
                        break block27;
                    }
                    catch (MessagingException e1) {
                        this.logger.warning(this.getName() + ": unable to close the source exchange on error status");
                        break block27;
                    }
                    finally {
                        asyncContext.setTerminated();
                    }
                }
                if (asyncContext.isTerminated()) break block27;
                asyncContext.getOriginalExchange().setError(new Exception("The asynchronous context isn't a dynamic router context: unable to process"));
                try {
                    context.send(asyncContext.getOriginalExchange());
                }
                catch (MessagingException e1) {
                    this.logger.warning(this.getName() + ": unable to close the source exchange on error status");
                }
                finally {
                    asyncContext.setTerminated();
                }
            }
            catch (JBIException e) {
                if (asyncContext.isTerminated()) break block27;
                asyncContext.getOriginalExchange().setError(new Exception(e));
                try {
                    context.send(asyncContext.getOriginalExchange());
                }
                catch (MessagingException e1) {
                    this.logger.warning(this.getName() + ": unable to close the source exchange on error status");
                }
                finally {
                    asyncContext.setTerminated();
                }
            }
            catch (XPathExpressionException e) {
                if (asyncContext.isTerminated()) break block27;
                asyncContext.getOriginalExchange().setError(new Exception(e));
                try {
                    context.send(asyncContext.getOriginalExchange());
                }
                catch (MessagingException e1) {
                    this.logger.warning(this.getName() + ": unable to close the source exchange on error status");
                }
                finally {
                    asyncContext.setTerminated();
                }
            }
        }
    }
}

