/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.se.eip.patterns;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.List;
import java.util.logging.Logger;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.jbidescriptor.generated.Param;
import org.ow2.petals.component.framework.util.SourceUtil;
import org.ow2.petals.se.eip.ExchangeContext;
import org.ow2.petals.se.eip.async.CommonAsyncContext;
import org.ow2.petals.se.eip.patterns.AbstractPattern;
import org.ow2.petals.se.eip.patterns.SourceKind;
import org.ow2.petals.se.eip.patterns.mock.ExchangeContextMock;
import org.ow2.petals.se.eip.patterns.mock.ExchangeImplMock;
import org.ow2.petals.se.eip.patterns.mock.MessageExchangeMock;
import org.ow2.petals.se.eip.patterns.mock.ServiceEndpointMock;
import org.w3c.dom.Document;

public abstract class AbstractTest {
    protected ExchangeContextMock context;
    protected Logger logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String convertStreamToString(InputStream is) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                sb.append(line + "\n");
            }
        }
        catch (IOException e) {
            Assert.fail((String)("unable to convert: " + e.getMessage()));
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                Assert.fail((String)("unable to convert: " + e.getMessage()));
            }
        }
        return sb.toString();
    }

    public ServiceEndpoint createConsumerServiceEndpoint() {
        QName[] interfaces = new QName[1];
        QName serviceName = null;
        String endpoint = null;
        interfaces[0] = new QName("http://petals.ow2.org", "interface");
        serviceName = new QName("http://petals.ow2.org", "serviceConsumer");
        endpoint = "8b32ee51-9b7b-4a09-8805-99733c1efc9a";
        ServiceEndpointMock serviceEndpoint = new ServiceEndpointMock(interfaces, serviceName, endpoint);
        return serviceEndpoint;
    }

    public ServiceEndpoint createProviderServiceEndpoint() {
        QName[] interfaces = new QName[1];
        QName serviceName = null;
        String endpoint = null;
        interfaces[0] = new QName("http://petals.ow2.org", "interface");
        serviceName = new QName("http://petals.ow2.org", "serviceProvider");
        endpoint = "8b32ee51-9b7b-4a09-8805-99733c1efc9b";
        ServiceEndpointMock serviceEndpoint = new ServiceEndpointMock(interfaces, serviceName, endpoint);
        return serviceEndpoint;
    }

    public abstract List<Param> getParamList();

    protected ExchangeImplMock createExchange(SourceKind sourceKind, URI pattern, MessageExchange.Role role, ExchangeStatus status, QName operation, Document in, Document out, Document fault, Exception exception) throws MessagingException, PEtALSCDKException {
        ExchangeImplMock exchange = null;
        Source source = null;
        exchange = new ExchangeImplMock(new MessageExchangeMock(this.createConsumerServiceEndpoint(), pattern, role, status));
        exchange.setEndpoint(this.createProviderServiceEndpoint());
        exchange.setOperation(operation);
        if (in != null) {
            if (sourceKind.isDOM()) {
                source = SourceUtil.createDOMSource((Document)in);
            } else if (sourceKind.isStream()) {
                source = SourceUtil.createStreamSource((Document)in);
            } else {
                throw new PEtALSCDKException("unable to know the source kind to generate");
            }
            exchange.getInMessage().setContent(source);
        }
        if (out != null) {
            if (sourceKind.isDOM()) {
                source = SourceUtil.createDOMSource((Document)out);
            } else if (sourceKind.isStream()) {
                source = SourceUtil.createStreamSource((Document)out);
            } else {
                throw new PEtALSCDKException("unable to know the source kind to generate");
            }
            exchange.getOutMessage().setContent(source);
        }
        if (fault != null) {
            Fault jbiFault = exchange.createFault();
            if (sourceKind.isDOM()) {
                source = SourceUtil.createDOMSource((Document)fault);
            } else if (sourceKind.isStream()) {
                source = SourceUtil.createStreamSource((Document)fault);
            } else {
                throw new PEtALSCDKException("unable to know the source kind to generate");
            }
            jbiFault.setContent(source);
            exchange.setCheckRole(false);
            exchange.setFault(jbiFault);
            exchange.setCheckRole(true);
        }
        if (exception != null) {
            exchange.setError(exception);
        }
        return exchange;
    }

    protected ExchangeImplMock createExchange(URI pattern, MessageExchange.Role role, ExchangeStatus status, Document in, Document out, Document fault, Exception exception) throws MessagingException, PEtALSCDKException {
        SourceKind sourceKind = new SourceKind();
        sourceKind.setStreamKind();
        return this.createExchange(sourceKind, pattern, role, status, null, in, out, fault, exception);
    }

    protected Exchange processAsyncDOMTest(URI pattern, MessageExchange.Role role, ExchangeStatus status, Document in, Document out, Document fault, Exception exception, AbstractPattern abstractPattern, CommonAsyncContext eipAsyncContext) throws MessagingException, PEtALSCDKException {
        SourceKind sourceKind = new SourceKind();
        sourceKind.setDOMKind();
        ExchangeImplMock exchange = this.createExchange(sourceKind, pattern, role, status, null, in, out, fault, exception);
        abstractPattern.logger = this.logger;
        abstractPattern.processAsync((Exchange)exchange, (ExchangeContext)this.context, eipAsyncContext);
        return exchange;
    }

    protected Exchange processAsyncStreamTest(URI pattern, MessageExchange.Role role, ExchangeStatus status, Document in, Document out, Document fault, Exception exception, AbstractPattern abstractPattern, CommonAsyncContext eipAsyncContext) throws MessagingException, PEtALSCDKException {
        SourceKind sourceKind = new SourceKind();
        sourceKind.setStreamKind();
        ExchangeImplMock exchange = this.createExchange(sourceKind, pattern, role, status, null, in, out, fault, exception);
        abstractPattern.logger = this.logger;
        abstractPattern.processAsync((Exchange)exchange, (ExchangeContext)this.context, eipAsyncContext);
        return exchange;
    }

    protected Exchange processDOMTest(URI pattern, MessageExchange.Role role, ExchangeStatus status, QName operation, Document in, Document out, Document fault, Exception exception, AbstractPattern abstractPattern) throws MessagingException, PEtALSCDKException {
        SourceKind sourceKind = new SourceKind();
        sourceKind.setDOMKind();
        ExchangeImplMock exchange = this.createExchange(sourceKind, pattern, role, status, operation, in, out, fault, exception);
        abstractPattern.logger = this.logger;
        abstractPattern.process((Exchange)exchange, (ExchangeContext)this.context);
        return exchange;
    }

    protected Exchange processStreamTest(URI pattern, MessageExchange.Role role, ExchangeStatus status, QName operation, Document in, Document out, Document fault, Exception exception, AbstractPattern abstractPattern) throws MessagingException, PEtALSCDKException {
        SourceKind sourceKind = new SourceKind();
        sourceKind.setStreamKind();
        ExchangeImplMock exchange = this.createExchange(sourceKind, pattern, role, status, operation, in, out, fault, exception);
        abstractPattern.logger = this.logger;
        abstractPattern.process((Exchange)exchange, (ExchangeContext)this.context);
        return exchange;
    }

    @Before
    public void setUp() throws Exception {
        this.context = new ExchangeContextMock(new ConfigurationExtensions(this.getParamList()));
        this.logger = Logger.getLogger(this.getClass().getSimpleName());
    }

    @After
    public void tearDown() throws Exception {
        this.context = null;
    }
}

