/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.se.eip.patterns;

import com.ebmwebsourcing.easycommons.xml.DocumentBuilders;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Source;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.jbidescriptor.generated.Consumes;
import org.ow2.petals.component.framework.jbidescriptor.generated.MEPType;
import org.ow2.petals.component.framework.jbidescriptor.generated.Param;
import org.ow2.petals.component.framework.util.SourceUtil;
import org.ow2.petals.se.eip.patterns.AbstractMEPBridgeWithUnicConsumesPatternTest;
import org.ow2.petals.se.eip.patterns.AbstractPattern;
import org.ow2.petals.se.eip.patterns.Router;
import org.ow2.petals.se.eip.patterns.mock.MessageExchangeMock;
import org.w3c.dom.Document;

public class RouterOperationTest
extends AbstractMEPBridgeWithUnicConsumesPatternTest {
    private Document in;
    private QName operation1 = new QName("http://petals.ow2.org", "operation1");
    private QName operation2 = new QName("http://petals.ow2.org", "operation2");
    private QName operation3 = new QName("http://petals.ow2.org", "operation3");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.abstractMEPBridgeWithUnicConsumesPattern = new Router();
        DocumentBuilder documentBuilder = null;
        InputStream inputStream = null;
        try {
            documentBuilder = DocumentBuilders.takeDocumentBuilder();
            inputStream = Router.class.getResourceAsStream("/routerIn1.xml");
            this.in = documentBuilder.parse(inputStream);
        }
        finally {
            if (documentBuilder != null) {
                DocumentBuilders.releaseDocumentBuilder((DocumentBuilder)documentBuilder);
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        this.in = null;
    }

    @Test
    public void testProcessTest1DOM() {
        try {
            this.context.setConsumeList(RouterOperationTest.getConsumesList(MEPType.IN_OUT));
            Exchange exchange = this.processDOMTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, this.operation1, this.in, null, null, null, (AbstractPattern)this.abstractMEPBridgeWithUnicConsumesPattern);
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)1L, (long)exchangeList.size());
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNull((Object)exchange.getError());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
            Assert.assertEquals((Object)"test1", (Object)exchangeList.get(0).getOperation().getLocalPart());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessTest2DOM() {
        try {
            this.context.setConsumeList(RouterOperationTest.getConsumesList(MEPType.IN_OUT));
            Exchange exchange = this.processDOMTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, this.operation2, this.in, null, null, null, (AbstractPattern)this.abstractMEPBridgeWithUnicConsumesPattern);
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)1L, (long)exchangeList.size());
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNull((Object)exchange.getError());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
            Assert.assertEquals((Object)"test2", (Object)exchangeList.get(0).getOperation().getLocalPart());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessDefaultDOM() {
        try {
            this.context.setConsumeList(RouterOperationTest.getConsumesList(MEPType.IN_OUT));
            Exchange exchange = this.processDOMTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, this.operation3, this.in, null, null, null, (AbstractPattern)this.abstractMEPBridgeWithUnicConsumesPattern);
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)1L, (long)exchangeList.size());
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNull((Object)exchange.getError());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
            Assert.assertEquals((Object)"default", (Object)exchangeList.get(0).getOperation().getLocalPart());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessTest1Stream() {
        try {
            this.context.setConsumeList(RouterOperationTest.getConsumesList(MEPType.IN_OUT));
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, this.operation1, this.in, null, null, null, (AbstractPattern)this.abstractMEPBridgeWithUnicConsumesPattern);
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)1L, (long)exchangeList.size());
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNull((Object)exchange.getError());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
            Assert.assertEquals((Object)"test1", (Object)exchangeList.get(0).getOperation().getLocalPart());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessTest2Stream() {
        try {
            this.context.setConsumeList(RouterOperationTest.getConsumesList(MEPType.IN_OUT));
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, this.operation2, this.in, null, null, null, (AbstractPattern)this.abstractMEPBridgeWithUnicConsumesPattern);
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)1L, (long)exchangeList.size());
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNull((Object)exchange.getError());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
            Assert.assertEquals((Object)"test2", (Object)exchangeList.get(0).getOperation().getLocalPart());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessDefaultStream() {
        try {
            this.context.setConsumeList(RouterOperationTest.getConsumesList(MEPType.IN_OUT));
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, this.operation3, this.in, null, null, null, (AbstractPattern)this.abstractMEPBridgeWithUnicConsumesPattern);
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)1L, (long)exchangeList.size());
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNull((Object)exchange.getError());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
            Assert.assertEquals((Object)"default", (Object)exchangeList.get(0).getOperation().getLocalPart());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Override
    @Test
    public void testInit() {
        try {
            this.abstractMEPBridgeWithUnicConsumesPattern.init();
        }
        catch (Throwable t) {
            Assert.fail((String)("An error occurs: " + t.getMessage()));
        }
    }

    @Override
    public List<Param> getParamList() {
        ArrayList<Param> paramList = new ArrayList<Param>();
        Param param = new Param();
        param.setName("test-operation");
        param.setValue(this.operation1.toString());
        paramList.add(param);
        param = new Param();
        param.setName("test-operation");
        param.setValue(this.operation2.toString());
        paramList.add(param);
        return paramList;
    }

    private static final List<Consumes> getConsumesList(MEPType mepType) {
        ArrayList<Consumes> consumesList = new ArrayList<Consumes>();
        QName interfaceName = new QName("http://petals.ow2.org", "interface");
        QName serviceName = new QName("http://petals.ow2.org", "serviceConsumer");
        String endpoint = "8b32ee51-9b7b-4a09-8805-99733c1efc9a";
        Consumes consumes = new Consumes();
        consumes.setMep(mepType);
        consumes.setInterfaceName(interfaceName);
        consumes.setServiceName(serviceName);
        consumes.setEndpointName(endpoint);
        consumes.setOperation(new QName("http://petals.ow2.org", "test1"));
        consumesList.add(consumes);
        consumes = new Consumes();
        consumes.setMep(MEPType.IN_ONLY);
        consumes.setInterfaceName(interfaceName);
        consumes.setServiceName(serviceName);
        consumes.setEndpointName(endpoint);
        consumes.setOperation(new QName("http://petals.ow2.org", "test2"));
        consumesList.add(consumes);
        consumes = new Consumes();
        consumes.setMep(MEPType.IN_ONLY);
        consumes.setInterfaceName(interfaceName);
        consumes.setServiceName(serviceName);
        consumes.setEndpointName(endpoint);
        consumes.setOperation(new QName("http://petals.ow2.org", "default"));
        consumesList.add(consumes);
        return consumesList;
    }
}

