/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.se.eip.patterns.mock;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ServiceEndpointMock
implements ServiceEndpoint {
    private String endpointName = null;
    private QName[] interfaces = null;
    private QName serviceName = null;
    private static final String EPR_NAMESPACE = "http://java.sun.com/xml/ns/jbi";

    public ServiceEndpointMock(QName[] interfaces, QName serviceName, String endpointName) {
        this.interfaces = interfaces;
        this.serviceName = serviceName;
        this.endpointName = endpointName;
    }

    public DocumentFragment getAsReference(QName operationName) {
        DocumentFragment result = null;
        try {
            String reference = "<end-point-reference xmlns='http://java.sun.com/xml/ns/jbi' service-name='" + this.serviceName.getLocalPart() + "' end-point-name='" + this.endpointName + "'></end-point-reference>";
            InputSource source = this.createSource(reference);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(source);
            result = document.createDocumentFragment();
            builder.reset();
        }
        catch (ParserConfigurationException e) {
        }
        catch (SAXException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public String getEndpointName() {
        return this.endpointName;
    }

    public QName[] getInterfaces() {
        return this.interfaces;
    }

    public QName getServiceName() {
        return this.serviceName;
    }

    private InputSource createSource(String msg) {
        InputSource source = new InputSource();
        byte[] msgByte = msg.getBytes();
        ByteArrayInputStream in = new ByteArrayInputStream(msgByte);
        source.setByteStream(in);
        return source;
    }
}

