/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.se.jsr181;

import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.jbi.messaging.MessagingException;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axiom.soap.SOAPFaultCode;
import org.apache.axiom.soap.SOAPFaultReason;
import org.apache.axiom.soap.SOAPFaultText;
import org.apache.axiom.soap.SOAPFaultValue;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.transport.TransportSender;
import org.apache.axis2.util.XMLUtils;
import org.apache.commons.io.IOExceptionWithCause;
import org.ow2.petals.commons.exception.ExceptionUtil;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.api.util.MtomUtil;
import org.ow2.petals.component.framework.listener.AbstractJBIListener;
import org.ow2.petals.jsr181.JBIContext;
import org.ow2.petals.jsr181.JBIContextManager;
import org.ow2.petals.jsr181.PetalsMessageSender;
import org.ow2.petals.se.jsr181.Jsr181Se;
import org.ow2.petals.se.jsr181.axis.AxisEmptyTransportSender;
import org.ow2.petals.se.jsr181.model.JaxConfigurationHandler;
import org.ow2.petals.se.jsr181.utils.AxiomHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Jsr181JBIListener
extends AbstractJBIListener
implements PetalsMessageSender {
    private String logHint;
    public static final String MTOM_TNS = "http://www.w3.org/2004/08/xop/include";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onJBIMessage(Exchange exchange) {
        this.logHint = "Exchange " + exchange.getExchangeId();
        Logger log = this.getLogger();
        if (log.isLoggable(Level.INFO)) {
            log.info(this.logHint + " is started to be processed.");
        }
        if (!exchange.isProviderRole()) {
            String msg = "The provider role is the only role being supported in the Petals-SE-Jsr181 component.";
            if (log.isLoggable(Level.INFO)) {
                log.info(this.logHint + " encountered a problem. " + msg);
            }
            this.handleError(msg, exchange);
        } else {
            ClassLoader savedClassLoader = Thread.currentThread().getContextClassLoader();
            JBIContextManager.setJBIContext((JBIContext)new JBIContext(exchange, (PetalsMessageSender)this));
            try {
                String edptName = exchange.getEndpointName();
                JaxConfigurationHandler jaxHandler = ((Jsr181Se)this.component).getJaxConfigurationHandler(edptName);
                AxisService axisService = jaxHandler.getAxisService();
                if (!this.checkOperation(exchange, axisService)) {
                    String msg = this.logHint + ": cannot find the operation " + exchange.getOperation() + " in the Axis service.";
                    this.handleError(msg, exchange);
                } else if (exchange.isInOptionalOutPattern()) {
                    String msg = this.logHint + ": the MEP InOptionalOut is not supported by the JSR-181 component.";
                    this.handleError(msg, exchange);
                } else if (!this.checkMEP(exchange, axisService)) {
                    String msg = this.logHint + ": the MEP " + exchange.getPattern() + " is not compatible with the operation MEP.";
                    this.handleError(msg, exchange);
                } else {
                    MessageContext inMessageContext = ((Jsr181Se)this.component).getAxisContext().createMessageContext();
                    this.fillInEnvelope(inMessageContext, axisService, exchange);
                    Thread.currentThread().setContextClassLoader(axisService.getClassLoader());
                    AxisEngine.receive((MessageContext)inMessageContext);
                    if (exchange.isInOutPattern()) {
                        MessageContext outMessageContext = inMessageContext.getOperationContext().getMessageContext("Out");
                        outMessageContext.setProperty("CACHE_CLASSLOADER", (Object)axisService.getClassLoader());
                        this.fillOutJBIMessage(outMessageContext, exchange);
                    }
                    if (log.isLoggable(Level.INFO)) {
                        log.info(this.logHint + " was successfully processed.");
                    }
                }
            }
            catch (AxisFault axisFault) {
                this.handleFault((Exception)((Object)axisFault), exchange);
            }
            catch (MessagingException me) {
                this.handleFault((Exception)((Object)me), exchange);
            }
            catch (IOExceptionWithCause e) {
                this.handleFault((Exception)((Object)e), exchange);
            }
            catch (Exception e) {
                this.handleFault(e, exchange);
            }
            finally {
                Thread.currentThread().setContextClassLoader(savedClassLoader);
                JBIContextManager.setJBIContext(null);
            }
        }
        return true;
    }

    protected boolean checkMEP(Exchange exchange, AxisService axisService) {
        AxisOperation operation = axisService.getOperation(exchange.getOperation());
        Logger logger = this.getLogger();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.logHint + ": MEP for Axis Operation is " + operation.getMessageExchangePattern() + ".");
            logger.fine(this.logHint + ": MEP for JBI message is " + exchange.getPattern() + ".");
        }
        int mepConstant = operation.getAxisSpecificMEPConstant();
        return exchange.isInOnlyPattern() && mepConstant == 10 || exchange.isInOptionalOutPattern() && mepConstant == 13 || exchange.isInOutPattern() && mepConstant == 12 || exchange.isRobustInOnlyPattern() && mepConstant == 11;
    }

    protected boolean checkOperation(Exchange exchange, AxisService axisService) {
        AxisOperation op = axisService.getOperation(exchange.getOperation());
        return op != null;
    }

    private void fillOutJBIMessage(MessageContext messageContext, Exchange exchange) throws Exception {
        SOAPEnvelope response = messageContext.getEnvelope();
        Source source = AxiomHelper.createSource(response);
        if (source != null) {
            exchange.setOutMessageContent(source);
        }
    }

    private void fillInEnvelope(MessageContext messageContext, AxisService axisService, Exchange exchange) throws AxisFault, MessagingException, IOExceptionWithCause {
        OMElement bodyContent;
        messageContext.setServerSide(true);
        messageContext.setAxisService(axisService);
        TransportOutDescription out = new TransportOutDescription("JBI");
        out.setSender((TransportSender)new AxisEmptyTransportSender());
        messageContext.setTransportOut(out);
        messageContext.setSoapAction(exchange.getOperationName());
        SOAPFactory soapFactory = OMAbstractFactory.getSOAP11Factory();
        Document exchangePayload = exchange.getInMessageContentAsDocument();
        if (exchangePayload == null || exchangePayload.getDocumentElement() == null) {
            SOAPFault fault = soapFactory.createSOAPFault();
            SOAPFaultCode soapFaultCode = soapFactory.createSOAPFaultCode();
            SOAPFaultValue soapFaultValue = soapFactory.createSOAPFaultValue(soapFaultCode);
            soapFaultValue.setText(new QName("http://schemas.xmlsoap.org/soap/envelope/", "Client"));
            fault.setCode(soapFaultCode);
            SOAPFaultReason soapFaultReason = soapFactory.createSOAPFaultReason();
            SOAPFaultText soapFaultText = soapFactory.createSOAPFaultText(soapFaultReason);
            soapFaultText.setText("The input document cannot be null.");
            fault.setReason(soapFaultReason);
            throw new AxisFault(fault);
        }
        Set dataHandlers = exchange.getInMessageAttachments();
        for (DataHandler dataHandler : dataHandlers) {
            messageContext.addAttachment(dataHandler.getName(), dataHandler);
        }
        Set contentIds = MtomUtil.extractAttachmentsIdFromPayload((Element)exchangePayload.getDocumentElement());
        for (String contentId : contentIds) {
            DataHandler dataHandler = null;
            for (String attName : exchange.getInMessageAttachmentNames()) {
                if (!MtomUtil.compare((String)contentId, (String)attName)) continue;
                dataHandler = exchange.getInMessageAttachment(attName);
                break;
            }
            if (dataHandler != null) {
                messageContext.addAttachment(contentId, dataHandler);
                continue;
            }
            this.getLogger().warning("No data handler was found for the attachment " + contentId);
        }
        SOAPEnvelope envelope = soapFactory.createSOAPEnvelope();
        try {
            bodyContent = XMLUtils.toOM((Element)exchangePayload.getDocumentElement(), (boolean)false);
        }
        catch (Exception e) {
            throw new IOExceptionWithCause((Throwable)e);
        }
        SOAPBody body = soapFactory.createSOAPBody(envelope);
        body.addChild((OMNode)bodyContent);
        envelope.addChild((OMNode)body);
        messageContext.setEnvelope(envelope);
    }

    private void handleFault(Exception exception, Exchange exchange) {
        String msg = exception.getMessage() != null ? exception.getMessage() : "The JSR-181 component generated an exception (handleFault).";
        Logger log = this.getLogger();
        if (log.isLoggable(Level.INFO)) {
            log.info(this.logHint + " encountered a problem. " + msg);
        }
        if (exchange.isInOnlyPattern()) {
            exchange.setError((Exception)((Object)new MessagingException(msg, (Throwable)exception)));
        } else {
            try {
                exchange.setFault((Throwable)exception);
            }
            catch (MessagingException e) {
                this.handleError("The JSR-181 component service generated an exception and cannot manage it.", exchange);
            }
        }
    }

    private void handleError(String message, Exchange exchange) {
        this.handleError((Exception)((Object)new MessagingException(message)), exchange);
    }

    private void handleError(Exception exception, Exchange exchange) {
        String msg = exception.getMessage() != null ? exception.getMessage() : "The JSR-181 component generated an exception (handleError).";
        Logger log = this.getLogger();
        if (log.isLoggable(Level.INFO)) {
            log.info(this.logHint + " encountered a problem. " + msg);
        }
        String ename = exception.getClass().getName();
        if (exception instanceof MessagingException || ename.startsWith("java.") || ename.startsWith("org.w3c.") || ename.startsWith("org.xml.")) {
            exchange.setError(exception);
        } else {
            MessagingException msgException = new MessagingException(ExceptionUtil.getExtendedMessage((Exception)exception));
            exchange.setError((Exception)((Object)msgException));
        }
    }
}

