/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.se.jsr181;

import java.io.File;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.jbi.servicedesc.ServiceEndpoint;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.ow2.petals.component.framework.AbstractComponent;
import org.ow2.petals.component.framework.se.AbstractServiceEngine;
import org.ow2.petals.component.framework.su.AbstractServiceUnitManager;
import org.ow2.petals.se.jsr181.Jsr181SuManager;
import org.ow2.petals.se.jsr181.axis.Axis2Deployer;
import org.ow2.petals.se.jsr181.model.JaxConfigurationHandler;
import org.w3c.dom.Document;

public class Jsr181Se
extends AbstractServiceEngine {
    private ConfigurationContext axisContext;
    private Axis2Deployer deployer;
    private final ConcurrentHashMap<String, JaxConfigurationHandler> endpointNameToJaxHandler = new ConcurrentHashMap();

    protected void doInit() throws JBIException {
        File axis2File = new File(this.getContext().getInstallRoot(), "axis2.xml");
        if (!axis2File.exists()) {
            throw new JBIException("Can not get the Axis2 configuration file from component context");
        }
        Logger log = this.getLogger();
        if (log.isLoggable(Level.FINE)) {
            this.getLogger().fine("Creating the Axis configuration context...");
        }
        try {
            this.axisContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)axis2File.getAbsolutePath());
            if (log.isLoggable(Level.FINE)) {
                this.getLogger().fine("The Axis configuration context was created.");
            }
        }
        catch (AxisFault e) {
            String msg = "Cannot initialize the JSR181 SE";
            if (log.isLoggable(Level.FINE)) {
                this.getLogger().fine(msg);
            }
            throw new JBIException(msg, (Throwable)e);
        }
        this.deployer = new Axis2Deployer(this);
    }

    public Document getServiceDescription(ServiceEndpoint endpoint) {
        return super.getServiceDescription(endpoint);
    }

    public ConfigurationContext getAxisContext() {
        return this.axisContext;
    }

    public Axis2Deployer getAxis2Deployer() {
        return this.deployer;
    }

    public AbstractServiceUnitManager createServiceUnitManager() {
        return new Jsr181SuManager((AbstractComponent)this);
    }

    public JaxConfigurationHandler getJaxConfigurationHandler(String endpointName) {
        return this.endpointNameToJaxHandler.get(endpointName);
    }

    public JaxConfigurationHandler registerJaxConfigurationHandler(String endpointName, JaxConfigurationHandler jaxConfigurationHandler) {
        return this.endpointNameToJaxHandler.put(endpointName, jaxConfigurationHandler);
    }

    public JaxConfigurationHandler removeJaxConfigurationHandler(String endpointName) {
        return this.endpointNameToJaxHandler.remove(endpointName);
    }
}

