/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.se.jsr181.model;

import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.axis2.AxisFault;
import org.apache.axis2.classloader.JarFileClassLoader;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisService;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.util.ClassLoaderUtil;
import org.ow2.petals.se.jsr181.axis.Axis2Deployer;
import org.ow2.petals.se.jsr181.model.JaxConfiguration;
import org.ow2.petals.se.jsr181.utils.Jsr181ClassLoaderUtils;

public class JaxConfigurationHandler {
    private final JaxConfiguration jaxConfiguration;
    private JarFileClassLoader classLoader;
    private AxisService axisService;
    private final Object lock = new Object();

    public JaxConfigurationHandler(JaxConfiguration jaxConfiguration) {
        this.jaxConfiguration = jaxConfiguration;
    }

    public AxisService getAxisService() {
        return this.axisService;
    }

    public String getEndpointName() {
        return this.jaxConfiguration.getEndpointName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Axis2Deployer axis2Deployer, Logger logger) throws PEtALSCDKException {
        if (logger.isLoggable(Level.FINE)) {
            String msg = ": creating an Axis service for the " + this.jaxConfiguration.getClassName() + " class.";
            logger.fine(this.jaxConfiguration.getServiceUnitName() + msg);
        }
        Object object = this.lock;
        synchronized (object) {
            URL[] urls = ClassLoaderUtil.getUrls((String)this.jaxConfiguration.getSuRootPath());
            this.classLoader = (JarFileClassLoader)Jsr181ClassLoaderUtils.createClassLoader(urls, this.getClass().getClassLoader());
            ClassLoader saved = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader((ClassLoader)this.classLoader);
                this.axisService = axis2Deployer.deployJAXWS(this.jaxConfiguration.getClassName(), (ClassLoader)this.classLoader, this.jaxConfiguration.getServiceURL(), this.jaxConfiguration.getServiceUnitName());
            }
            catch (Exception e) {
                throw new PEtALSCDKException((Throwable)e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(saved);
                if (this.axisService == null) {
                    this.classLoader.destroy();
                    this.classLoader = null;
                    throw new PEtALSCDKException("An Axis service could not be created from the JAX-WS class.");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(ConfigurationContext axisContext) throws PEtALSCDKException {
        Object object = this.lock;
        synchronized (object) {
            try {
                axisContext.getAxisConfiguration().removeServiceGroup(this.axisService.getName());
                this.axisService.getAxisConfiguration().removeService(this.axisService.getName());
            }
            catch (AxisFault e) {
                throw new PEtALSCDKException((Throwable)e);
            }
            finally {
                this.axisService = null;
                this.classLoader.destroy();
                this.classLoader = null;
            }
        }
    }
}

