/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.se.jsr181.axis;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.axis2.AxisFault;
import org.apache.axis2.deployment.util.Utils;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.util.Loader;
import org.ow2.petals.se.jsr181.Jsr181Se;

public class Axis2Deployer {
    private final Jsr181Se jsr181Se;
    private final Logger logger;

    public Axis2Deployer(Jsr181Se jsr181Se) {
        this.jsr181Se = jsr181Se;
        this.logger = jsr181Se.getLogger();
    }

    public AxisService deployJAXWS(String className, ClassLoader classloader, URL serviceLocation, String suName) {
        AxisService axisService;
        block11: {
            axisService = null;
            try {
                Class jaxWsClass = Loader.loadClass((ClassLoader)classloader, (String)className);
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine(suName + ": the " + className + " class was succesfully loaded.");
                }
                boolean foundWsAnnotation = false;
                for (Annotation ann : jaxWsClass.getAnnotations()) {
                    if (!"javax.jws.WebService".equals(ann.annotationType().getName())) continue;
                    foundWsAnnotation = true;
                    axisService = this.createAxisService(serviceLocation, jaxWsClass);
                    this.jsr181Se.getAxisContext().getAxisConfiguration().addService(axisService);
                    break;
                }
                if (this.logger.isLoggable(Level.FINE)) {
                    if (foundWsAnnotation) {
                        this.logger.fine(suName + ": a JAX-WS annotated class was found.");
                    } else {
                        this.logger.fine(suName + ": no JAX-WS annotated class was found.");
                    }
                }
            }
            catch (AxisFault e) {
                if (this.logger.isLoggable(Level.FINER)) {
                    this.logger.finer(e.getMessage());
                }
            }
            catch (ClassNotFoundException e) {
                if (this.logger.isLoggable(Level.FINER)) {
                    this.logger.finer(e.getMessage());
                }
            }
            catch (Exception e) {
                if (!this.logger.isLoggable(Level.FINER)) break block11;
                this.logger.finer(e.getMessage());
            }
        }
        return axisService;
    }

    private AxisService createAxisService(URL serviceLocation, Class<?> jaxWsClass) throws Exception {
        AxisService axisService = null;
        Class claxx = Loader.loadClass((ClassLoader)jaxWsClass.getClassLoader(), (String)"org.apache.axis2.jaxws.description.DescriptionFactory");
        Method mthod = claxx.getMethod("createAxisService", Class.class);
        axisService = (AxisService)mthod.invoke((Object)claxx, jaxWsClass);
        if (axisService != null) {
            Iterator operations = axisService.getOperations();
            while (operations.hasNext()) {
                AxisOperation axisOperation = (AxisOperation)operations.next();
                if (axisOperation.getMessageReceiver() != null) continue;
                Class jaxwsMR = Loader.loadClass((ClassLoader)jaxWsClass.getClassLoader(), (String)"org.apache.axis2.jaxws.server.JAXWSMessageReceiver");
                MessageReceiver jaxwsMRInstance = (MessageReceiver)jaxwsMR.newInstance();
                axisOperation.setMessageReceiver(jaxwsMRInstance);
            }
            axisService.setElementFormDefault(false);
            axisService.setFileName(serviceLocation);
            Utils.fillAxisService((AxisService)axisService, (AxisConfiguration)this.jsr181Se.getAxisContext().getAxisConfiguration(), new ArrayList(), new ArrayList());
        }
        return axisService;
    }
}

