/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.se.jsr181;

import java.io.File;
import java.io.IOException;
import javax.jbi.JBIException;
import org.apache.commons.io.FileUtils;
import org.ow2.petals.component.framework.DefaultBootstrap;

public class Jsr181Bootstrap
extends DefaultBootstrap {
    private static final String MODULES_PATH = "modules";
    private static final String SERVICES_PATH = "services";
    private static final String MODULE_ARCHIVE_EXTENSION = "mar";
    public static final String CONFIGURATION_FILE = "axis2.xml";

    public void doInit() throws JBIException {
        super.doInit();
        this.createWorkDirectories();
        this.copyConfigurationFiles();
    }

    protected void copyConfigurationFiles() throws JBIException {
        File[] rootFiles;
        File[] metaInfFiles;
        File installRootFile = new File(this.installContext.getInstallRoot());
        File modules = new File(installRootFile, MODULES_PATH);
        for (File file : metaInfFiles = new File(installRootFile, "META-INF").listFiles()) {
            File destFile;
            if (file.getName().endsWith(".mar") && !(destFile = new File(modules, file.getName())).exists()) {
                try {
                    FileUtils.copyFile((File)file, (File)destFile);
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (!file.getName().equals(CONFIGURATION_FILE) || (destFile = new File(this.installContext.getInstallRoot(), file.getName())).exists()) continue;
            try {
                FileUtils.copyFile((File)file, (File)destFile);
            }
            catch (IOException e) {
                throw new JBIException("Cannot copy the Axis2 configuration file, Axis2 will not start properly.");
            }
        }
        for (File file : rootFiles = installRootFile.listFiles()) {
            File destFile;
            if (!file.getName().endsWith(".mar") || (destFile = new File(modules, file.getName())).exists()) continue;
            try {
                FileUtils.copyFile((File)file, (File)destFile);
            }
            catch (IOException e) {
                this.getLogger().warning("The module '" + file.getName() + "' has not been copied to modules directory.");
            }
        }
    }

    protected void createWorkDirectories() throws JBIException {
        File modules = new File(this.installContext.getInstallRoot(), MODULES_PATH);
        File services = new File(this.installContext.getInstallRoot(), SERVICES_PATH);
        if (!modules.exists() && !modules.mkdirs() || !services.exists() && !services.mkdirs()) {
            throw new JBIException("Could not create work directories.");
        }
    }
}

