/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.se.jsr181;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.axis2.context.ConfigurationContext;
import org.ow2.petals.component.framework.AbstractComponent;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.jbidescriptor.generated.Jbi;
import org.ow2.petals.component.framework.jbidescriptor.generated.Provides;
import org.ow2.petals.component.framework.su.ServiceEngineServiceUnitManager;
import org.ow2.petals.component.framework.su.ServiceUnitDataHandler;
import org.ow2.petals.se.jsr181.Jsr181Se;
import org.ow2.petals.se.jsr181.axis.Axis2Deployer;
import org.ow2.petals.se.jsr181.model.JaxConfiguration;
import org.ow2.petals.se.jsr181.model.JaxConfigurationHandler;

public class Jsr181SuManager
extends ServiceEngineServiceUnitManager {
    private static final String CONFIG_CLASS = "class";
    private final Map<String, List<JaxConfigurationHandler>> suNameToJaxConfigHandler = new HashMap<String, List<JaxConfigurationHandler>>();

    public Jsr181SuManager(AbstractComponent component) {
        super(component);
    }

    public void doDeploy(String serviceUnitName, String suRootPath, Jbi descriptor) throws PEtALSCDKException {
        List providesList = descriptor.getServices().getProvides();
        if (providesList.size() == 0) {
            throw new PEtALSCDKException("This service-unit does not specify any service (no provides sections).");
        }
        ArrayList<JaxConfigurationHandler> handlers = new ArrayList<JaxConfigurationHandler>(providesList.size());
        for (Provides provides : providesList) {
            ServiceUnitDataHandler suDataHandler = this.getSUDataHandlerForProvides(provides);
            if (suDataHandler == null) {
                throw new PEtALSCDKException("Error while processing the JBI descriptor in the component. The SU data handler was null.");
            }
            ConfigurationExtensions extensions = suDataHandler.getConfigurationExtensions((Object)provides);
            String className = extensions.get((Object)CONFIG_CLASS);
            if (className != null) {
                className = className.trim();
            }
            if (className == null || className.length() == 0) {
                throw new PEtALSCDKException("The class name cannot be null or empty.");
            }
            try {
                URL serviceURL = new URL("http://localhost/services/" + provides.getServiceName().getLocalPart());
                String edptName = provides.getEndpointName();
                JaxConfiguration jaxConfiguration = new JaxConfiguration(serviceURL, suRootPath, className, edptName, serviceUnitName);
                JaxConfigurationHandler jaxConfigHandler = new JaxConfigurationHandler(jaxConfiguration);
                handlers.add(jaxConfigHandler);
                ((Jsr181Se)this.component).registerJaxConfigurationHandler(edptName, jaxConfigHandler);
            }
            catch (MalformedURLException e) {
                throw new PEtALSCDKException((Throwable)e);
            }
        }
        this.suNameToJaxConfigHandler.put(serviceUnitName, handlers);
    }

    protected void doStart(String serviceUnitName) throws PEtALSCDKException {
        List<JaxConfigurationHandler> handlers = this.suNameToJaxConfigHandler.get(serviceUnitName);
        if (handlers == null || handlers.size() == 0) {
            throw new PEtALSCDKException("No service handler was registered for this service-unit.");
        }
        Axis2Deployer deployer = ((Jsr181Se)this.component).getAxis2Deployer();
        for (JaxConfigurationHandler handler : handlers) {
            handler.start(deployer, this.logger);
        }
    }

    protected void doShutdown(String serviceUnitName) throws PEtALSCDKException {
        List<JaxConfigurationHandler> handlers = this.suNameToJaxConfigHandler.get(serviceUnitName);
        if (handlers == null || handlers.size() == 0) {
            throw new PEtALSCDKException("No service handler was registered for this service-unit.");
        }
        ConfigurationContext axisContext = ((Jsr181Se)this.component).getAxisContext();
        for (JaxConfigurationHandler handler : handlers) {
            handler.stop(axisContext);
        }
    }

    protected void doUndeploy(String serviceUnitName) throws PEtALSCDKException {
        List<JaxConfigurationHandler> handlers = this.suNameToJaxConfigHandler.remove(serviceUnitName);
        if (handlers != null) {
            for (JaxConfigurationHandler handler : handlers) {
                ((Jsr181Se)this.component).removeJaxConfigurationHandler(handler.getEndpointName());
            }
        }
    }
}

