/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.se.pojo.listener;

import java.lang.reflect.Method;
import java.util.logging.Level;
import javax.jbi.messaging.MessagingException;
import org.ow2.petals.commons.exception.ExceptionUtil;
import org.ow2.petals.component.framework.api.exception.FaultException;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.listener.AbstractJBIListener;
import org.ow2.petals.component.framework.process.async.AsyncContext;
import org.ow2.petals.se.pojo.Pojo;
import org.ow2.petals.se.pojo.PojoComponent;

public class JBIListener
extends AbstractJBIListener {
    public boolean onJBIMessage(Exchange exchange) {
        return this.onMessage(exchange, null);
    }

    public boolean onAsyncJBIMessage(Exchange exchange, AsyncContext asyncContext) {
        if (asyncContext == null) {
            this.getLogger().log(Level.SEVERE, "onAsyncJBIMessage called with null AsyncContext: ignore !");
            return true;
        }
        return this.onMessage(exchange, asyncContext);
    }

    private boolean onMessage(Exchange exchange, AsyncContext asyncContext) {
        boolean ret;
        block8: {
            ret = true;
            try {
                Pojo pojo = null;
                pojo = asyncContext != null ? ((PojoComponent)this.getComponent()).getPojos().get(asyncContext.getOriginalExchange().getEndpointName()) : ((PojoComponent)this.getComponent()).getPojos().get(exchange.getEndpointName());
                if (pojo != null) {
                    try {
                        this.setJbiListenerOnPojo(pojo);
                        ret = pojo.callOnExchangeMethod(exchange, asyncContext);
                        break block8;
                    }
                    catch (FaultException e) {
                        this.getLogger().log(Level.FINE, e.getMessage(), e);
                        exchange.setFault((Throwable)e);
                        break block8;
                    }
                    catch (PEtALSCDKException e) {
                        this.getLogger().log(Level.SEVERE, e.getMessage(), e);
                        if (exchange.isActiveStatus()) {
                            exchange.setError((Exception)((Object)new MessagingException(ExceptionUtil.getExtendedMessage((Exception)((Object)e)))));
                        }
                        break block8;
                    }
                    catch (MessagingException e) {
                        this.getLogger().log(Level.WARNING, e.getMessage(), e);
                        throw e;
                    }
                }
                this.getLogger().log(Level.SEVERE, "Failed to find the POJO instance matching the endpoint '" + exchange.getEndpointName() + "'");
                exchange.setError((Exception)((Object)new MessagingException("Failed to find the POJO instance matching the endpoint '" + exchange.getEndpointName() + "'")));
            }
            catch (MessagingException e) {
                if (!exchange.isActiveStatus()) break block8;
                exchange.setError((Exception)((Object)e));
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setJbiListenerOnPojo(Pojo pojo) throws PEtALSCDKException {
        block5: {
            ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(pojo.getClassLoader());
            try {
                Method setJbiListenerMethod = Pojo.findMethod(pojo.getPojo().getClass(), "setJBIListener", AbstractJBIListener.class);
                if (setJbiListenerMethod == null) break block5;
                try {
                    setJbiListenerMethod.invoke(pojo.getPojo(), new Object[]{this});
                }
                catch (Exception e) {
                    throw new PEtALSCDKException("Can not set the JBIListener on the POJO", (Throwable)e);
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldClassLoader);
            }
        }
    }
}

