/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.wsstar.notification.service.persistence;

import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.SubscriptionManagerRP;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.PublisherRegistrationRP;
import com.ebmwebsourcing.wsstar.notification.definition.inout.WSNotificationReader;
import com.ebmwebsourcing.wsstar.notification.definition.inout.WSNotificationWriter;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationException;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class WsnPersistence {
    private File subscriptions_folder = null;
    private File registrations_folder = null;

    public WsnPersistence(File subscriptions_path, File registrations_path) {
        if (subscriptions_path == null) {
            throw new NullPointerException("Persistence folder must not be null");
        }
        if (!subscriptions_path.exists()) {
            subscriptions_path.mkdirs();
        }
        this.subscriptions_folder = subscriptions_path;
        if (registrations_path != null) {
            if (!registrations_path.exists()) {
                registrations_path.mkdirs();
            }
            this.registrations_folder = registrations_path;
        }
    }

    public void persist(SubscriptionManagerRP subscriptionRP, String uuid) throws WSNotificationException {
        File persist = new File(this.subscriptions_folder.getAbsoluteFile(), uuid);
        if (persist == null) {
            throw new WSNotificationException("The persistance file can not be created");
        }
        if (!persist.exists()) {
            try {
                persist.createNewFile();
            }
            catch (IOException e) {
                throw new WSNotificationException(e);
            }
        }
        WSNotificationWriter.getInstance().writeSubscriptionManagerRP(subscriptionRP, persist);
    }

    public void persist(PublisherRegistrationRP registrationRP, String uuid) throws WSNotificationException {
        if (this.registrations_folder != null) {
            File persist = new File(this.registrations_folder, uuid);
            if (persist == null) {
                throw new WSNotificationException("The persistance file can not be created");
            }
            if (!persist.exists()) {
                try {
                    persist.createNewFile();
                }
                catch (IOException e) {
                    throw new WSNotificationException(e);
                }
            }
            WSNotificationWriter.getInstance().writePublisherRegistrationRP(registrationRP, persist);
        }
    }

    public Map<String, PublisherRegistrationRP> getRegistrationsToRestore() throws WSNotificationException {
        ConcurrentHashMap<String, PublisherRegistrationRP> result = new ConcurrentHashMap<String, PublisherRegistrationRP>();
        if (this.registrations_folder.exists()) {
            File[] persistedRegistrations = this.registrations_folder.listFiles();
            for (int i = 0; i < persistedRegistrations.length; ++i) {
                result.put(persistedRegistrations[i].getName(), WSNotificationReader.getInstance().readPublisherRegistrationRP(persistedRegistrations[i]));
            }
        }
        return result;
    }

    public Map<String, SubscriptionManagerRP> getSubscriptionsToRestore() throws WSNotificationException {
        ConcurrentHashMap<String, SubscriptionManagerRP> result = new ConcurrentHashMap<String, SubscriptionManagerRP>();
        if (this.subscriptions_folder.exists()) {
            File[] persistedSubsriptionFiles = this.subscriptions_folder.listFiles();
            for (int i = 0; i < persistedSubsriptionFiles.length; ++i) {
                result.put(persistedSubsriptionFiles[i].getName(), WSNotificationReader.getInstance().readSubscriptionManagerRP(persistedSubsriptionFiles[i]));
            }
        }
        return result;
    }

    public void removeSubscription(String uuid) throws WSNotificationException {
        File subscriptionToRemove = new File(this.subscriptions_folder, uuid);
        if (subscriptionToRemove.exists() && !subscriptionToRemove.delete()) {
            throw new WSNotificationException("Deletion of subscription \"" + uuid + "\" failed !");
        }
    }

    public void removeRegistration(String uuid) throws WSNotificationException {
        File registrationToRemove;
        if (this.registrations_folder.exists() && (registrationToRemove = new File(this.registrations_folder, uuid)).exists() && !registrationToRemove.delete()) {
            throw new WSNotificationException("Deletion of registration \"" + uuid + "\" failed !");
        }
    }
}

