/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.logger;

import com.ebmwebsourcing.easycommons.logger.LogData;
import com.ebmwebsourcing.easycommons.logger.LogDataAppender;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class LogDataFormatter
extends Formatter {
    private final DateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss,SSS", Locale.getDefault());
    private final Deque<LogDataAppender> dataAppenders = new LinkedList<LogDataAppender>();

    public final void addLogDataAppender(LogDataAppender logDataAppender) {
        assert (logDataAppender != null);
        this.dataAppenders.add(logDataAppender);
    }

    final LogDataAppender[] getLogDataAppenders() {
        return this.dataAppenders.toArray(new LogDataAppender[this.dataAppenders.size()]);
    }

    private void formatLogData(StringBuffer outBuffer, LogData logData) {
        block0: for (Map.Entry<String, Object> entry : logData.getData().entrySet()) {
            Iterator<LogDataAppender> itAppender = this.dataAppenders.descendingIterator();
            while (itAppender.hasNext()) {
                LogDataAppender appender = itAppender.next();
                if (!appender.canAppend(logData, entry.getKey())) continue;
                appender.append(outBuffer, logData, entry.getKey());
                outBuffer.append("\n");
                continue block0;
            }
        }
    }

    @Override
    public String format(LogRecord record) {
        StringBuffer sb = new StringBuffer();
        sb.append(String.format("%s %s [%s] : %s", this.dateFormat.format(record.getMillis()), record.getLevel(), record.getLoggerName(), record.getMessage()));
        sb.append("\n");
        Object[] extraParameters = record.getParameters();
        if (extraParameters != null && extraParameters.length != 0 && extraParameters[0] instanceof LogData) {
            this.formatLogData(sb, (LogData)extraParameters[0]);
        }
        if (record.getThrown() != null) {
            this.appendThrowableStackPart(record.getThrown(), sb);
        }
        return sb.toString();
    }

    private void appendThrowableStackPart(Throwable throwable, StringBuffer sb) {
        sb.append("Caused by ").append(throwable.toString()).append("\n");
        for (StackTraceElement ste : throwable.getStackTrace()) {
            sb.append("  ").append(ste.toString()).append("\n");
        }
        if (throwable.getCause() != null) {
            this.appendThrowableStackPart(throwable.getCause(), sb);
        }
    }

    @Override
    public synchronized String formatMessage(LogRecord record) {
        Object[] extraParameters = record.getParameters();
        String result = null;
        if (extraParameters != null && extraParameters.length != 0 && extraParameters[0] instanceof LogData) {
            Object[] extraParametersWithoutLogData = Arrays.copyOfRange(extraParameters, 1, extraParameters.length);
            record.setParameters(extraParametersWithoutLogData);
            result = super.formatMessage(record);
            record.setParameters(extraParameters);
        } else {
            result = super.formatMessage(record);
        }
        return result;
    }
}

