/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.pooling;

import com.ebmwebsourcing.easycommons.pooling.api.PoolPolicy;
import com.ebmwebsourcing.easycommons.pooling.api.PoolPolicyBehaviorException;
import com.ebmwebsourcing.easycommons.pooling.api.ResourceHandler;
import com.ebmwebsourcing.easycommons.pooling.api.UnstableStateException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class GenericResourcePool<T> {
    private final ConcurrentHashMap<T, Boolean> resources;
    private final int dynamicPartSize;
    private final int staticPartSize;
    private final ResourceHandler<T> handler;
    private final Byte waitingFlag;
    private final PoolPolicy poolPolicy;

    public GenericResourcePool(ResourceHandler<T> handler, int minSize, int maxSize, PoolPolicy poolPolicy) throws UnstableStateException {
        if (handler == null) {
            throw new IllegalArgumentException("Resource handler must not be null");
        }
        this.waitingFlag = 1;
        this.poolPolicy = poolPolicy;
        this.resources = new ConcurrentHashMap(minSize);
        this.dynamicPartSize = maxSize != -1 ? maxSize - minSize : -1;
        this.staticPartSize = minSize;
        this.handler = handler;
        for (int i = 0; i < minSize; ++i) {
            try {
                this.resources.put(this.handler.createResource(), false);
                continue;
            }
            catch (Exception e) {
                throw new UnstableStateException("Pool is in unstable state because one resource has not been correctly created", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized T take() throws UnstableStateException, PoolPolicyBehaviorException {
        T resource = this.acquire();
        if (resource != null) {
            this.resources.replace(resource, true);
            try {
                this.handler.activateResource(resource);
            }
            catch (Exception e) {
                throw new UnstableStateException("Pool is in unstable state because one resource has not been correctly activate", e);
            }
            return resource;
        }
        if (this.poolPolicy.equals((Object)PoolPolicy.WAIT)) {
            Byte by = this.waitingFlag;
            synchronized (by) {
                try {
                    this.waitingFlag.wait();
                }
                catch (InterruptedException e) {
                    throw new UnstableStateException("Pool is in unstable state because an interruption was throwed during waiting resource time", e);
                }
            }
            resource = this.acquire();
        } else if (this.poolPolicy.equals((Object)PoolPolicy.REJECT)) {
            throw new PoolPolicyBehaviorException("There are no more available resource (Reject policy enforment used)");
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void release(T resource) throws UnstableStateException {
        if (this.resources.containsKey(resource)) {
            this.mark(resource, false);
            try {
                this.handler.passivateResource(resource);
            }
            catch (Exception e) {
                throw new UnstableStateException("Pool is in unstable state because one resource ha not been correctly passivate", e);
            }
            if (this.poolPolicy.equals((Object)PoolPolicy.WAIT)) {
                Byte by = this.waitingFlag;
                synchronized (by) {
                    this.waitingFlag.notify();
                }
            }
        } else {
            throw new IllegalArgumentException("Unknowned resource for current pool");
        }
    }

    public final synchronized int unused() {
        Collection<Boolean> values = this.resources.values();
        int count = 0;
        for (Boolean value : values) {
            if (value.booleanValue()) continue;
            ++count;
        }
        return count;
    }

    public final synchronized void cleanAndResetResources() throws UnstableStateException {
        int size = this.resources.size();
        for (Object resource : this.resources.keySet()) {
            this.mark(resource, false);
            try {
                this.handler.passivateResource(resource);
            }
            catch (Exception e) {
                throw new UnstableStateException("Pool is in unstable state because one resource has not been correctly passivate", e);
            }
            try {
                this.handler.destroyResource(resource);
            }
            catch (Exception e) {
                throw new UnstableStateException("Pool is in unstable state because one resource is not correctly switch to destroyable state", e);
            }
        }
        this.resources.clear();
        for (int i = 0; i < size; ++i) {
            try {
                this.resources.put(this.handler.createResource(), false);
                continue;
            }
            catch (Exception e) {
                throw new UnstableStateException("Pool is in unstable state because one resource has not been correctly created", e);
            }
        }
    }

    public final int currentPoolSize() {
        return this.resources.size();
    }

    public final int staticPoolSize() {
        return this.staticPartSize;
    }

    public final int dynamicPoolSize() {
        return this.dynamicPartSize;
    }

    protected void finalize() throws Throwable {
        for (Object resource : this.resources.keySet()) {
            this.mark(resource, false);
            this.handler.passivateResource(resource);
            this.handler.destroyResource(resource);
        }
        this.resources.clear();
        super.finalize();
    }

    private final T acquire() throws UnstableStateException {
        Set<Map.Entry<T, Boolean>> set = this.resources.entrySet();
        Iterator<Map.Entry<T, Boolean>> it = set.iterator();
        Object resource = null;
        while (it.hasNext()) {
            Map.Entry<T, Boolean> entry = it.next();
            if (entry.getValue().booleanValue()) continue;
            resource = entry.getKey();
        }
        if (resource == null && (this.resources.size() <= this.dynamicPartSize || this.dynamicPartSize == -1)) {
            try {
                resource = this.handler.createResource();
                this.resources.put(resource, false);
            }
            catch (Exception e) {
                throw new UnstableStateException("Pool is in unstable state because one resource has not been correctly created for dynamic pool part", e);
            }
        }
        return (T)resource;
    }

    private final void mark(T resource, boolean state) {
        this.resources.replace(resource, state);
    }
}

