/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.pooling;

import com.ebmwebsourcing.easycommons.pooling.GenericResourcePool;
import com.ebmwebsourcing.easycommons.pooling.api.PoolPolicy;
import com.ebmwebsourcing.easycommons.pooling.api.PoolPolicyBehaviorException;
import com.ebmwebsourcing.easycommons.pooling.api.UnstableStateException;
import com.ebmwebsourcing.easycommons.pooling.factory.TransformerResourceHandler;
import javax.xml.transform.Transformer;

public class TransformerResourcePool {
    private final GenericResourcePool<Transformer> transformerResourcePool;

    public TransformerResourcePool(int minPoolSize, int maxPoolSize, PoolPolicy poolPolicy) throws UnstableStateException {
        TransformerResourceHandler transformerResourceFactory = new TransformerResourceHandler();
        this.transformerResourcePool = new GenericResourcePool<Transformer>(transformerResourceFactory, minPoolSize, maxPoolSize, poolPolicy);
    }

    public final Transformer take() throws UnstableStateException, PoolPolicyBehaviorException {
        return this.transformerResourcePool.take();
    }

    public final Transformer takeXmlWithoutDeclarationTransformer() throws UnstableStateException, PoolPolicyBehaviorException {
        Transformer transformer = this.transformerResourcePool.take();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setOutputProperty("method", "xml");
        return transformer;
    }

    public final Transformer takeWithoutDeclarationTransformer() throws UnstableStateException, PoolPolicyBehaviorException {
        Transformer transformer = this.transformerResourcePool.take();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        return transformer;
    }

    public final Transformer takeXmlWithDeclarationTransformer() throws UnstableStateException, PoolPolicyBehaviorException {
        Transformer transformer = this.transformerResourcePool.take();
        transformer.setOutputProperty("omit-xml-declaration", "no");
        transformer.setOutputProperty("method", "xml");
        return transformer;
    }

    public final void release(Transformer resource) throws UnstableStateException {
        this.transformerResourcePool.release(resource);
    }

    public final int unused() {
        return this.transformerResourcePool.unused();
    }

    public final void cleanAndResetResources() throws UnstableStateException {
        this.transformerResourcePool.cleanAndResetResources();
    }

    public final int currentPoolSize() {
        return this.transformerResourcePool.currentPoolSize();
    }

    public final int staticPoolSize() {
        return this.transformerResourcePool.staticPoolSize();
    }

    public final int dynamicPoolSize() {
        return this.transformerResourcePool.dynamicPoolSize();
    }
}

