/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.xml;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLPrettyPrinter {
    public static final ThreadLocal<TransformerFactory> transformerFactoryThreadLocal = new ThreadLocal<TransformerFactory>(){

        @Override
        protected TransformerFactory initialValue() {
            return TransformerFactory.newInstance();
        }
    };

    public static String prettyPrint(Node xmlDocument, String encoding) {
        String result = "";
        try {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            XMLPrettyPrinter.prettify(xmlDocument, outStream, encoding);
            result = outStream.toString(encoding);
        }
        catch (Exception e) {
            System.err.println("write_dom failed:" + e);
        }
        return result;
    }

    public static String prettyPrint(Document xmlDocument) {
        return XMLPrettyPrinter.prettyPrint(xmlDocument, XMLPrettyPrinter.getEncoding(xmlDocument));
    }

    public static String prettyPrint(Element node) {
        String res = null;
        if (node != null) {
            res = node instanceof Document ? XMLPrettyPrinter.prettyPrint(node, XMLPrettyPrinter.getEncoding((Document)((Object)node))) : XMLPrettyPrinter.prettyPrint(node, XMLPrettyPrinter.getEncoding(node.getOwnerDocument()));
        }
        return res;
    }

    public static String prettyPrint(Node node) {
        String res = null;
        if (node != null) {
            res = node instanceof Document ? XMLPrettyPrinter.prettyPrint(node, XMLPrettyPrinter.getEncoding((Document)node)) : XMLPrettyPrinter.prettyPrint(node, XMLPrettyPrinter.getEncoding(node.getOwnerDocument()));
        }
        return res;
    }

    public static void prettify(Node node, OutputStream out, String encoding) throws Exception {
        DOMSource source = new DOMSource(node);
        Source stylesheetSource = XMLPrettyPrinter.getStyleSheetSource();
        TransformerFactory tf = transformerFactoryThreadLocal.get();
        Templates templates = tf.newTemplates(stylesheetSource);
        Transformer transformer = templates.newTransformer();
        transformer.setOutputProperty("encoding", encoding);
        transformer.transform(source, new StreamResult(out));
    }

    public static String getEncoding(Document xmlDocument) {
        String encoding = xmlDocument.getInputEncoding();
        if (encoding == null) {
            encoding = xmlDocument.getXmlEncoding();
        }
        if (encoding == null) {
            encoding = "UTF-8";
        }
        return encoding;
    }

    public static void prettify(Node node, OutputStream out) throws Exception {
        DOMSource source = new DOMSource(node);
        Source stylesheetSource = XMLPrettyPrinter.getStyleSheetSource();
        TransformerFactory tf = transformerFactoryThreadLocal.get();
        Templates templates = tf.newTemplates(stylesheetSource);
        Transformer transformer = templates.newTransformer();
        transformer.transform(source, new StreamResult(out));
    }

    public static void prettify(InputStream in, OutputStream out) throws Exception {
        StreamSource source = new StreamSource(in);
        Source stylesheetSource = XMLPrettyPrinter.getStyleSheetSource();
        TransformerFactory tf = transformerFactoryThreadLocal.get();
        Templates templates = tf.newTemplates(stylesheetSource);
        Transformer transformer = templates.newTransformer();
        transformer.transform(source, new StreamResult(out));
    }

    private static Source getStyleSheetSource() {
        StreamSource stylesheetSource = new StreamSource(XMLPrettyPrinter.class.getResourceAsStream("/prettyPrint.xsl"));
        return stylesheetSource;
    }
}

