/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.util;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.ow2.petals.component.framework.util.CustomizableThreadFactory;
import org.ow2.petals.component.framework.util.StringHelper;

public class RetryTaskExecutor {
    private String taskName;
    private Logger logger;
    private final int minDelay;
    private final int maxDelay;
    private final int delayFactor;
    private final TimeUnit timeUnit;
    private int innerDelay;
    private final int retries;
    private ScheduledExecutorService executor;
    private volatile boolean running = true;

    public RetryTaskExecutor(String taskName, Logger logger, int minDelay, int maxDelay, int delayFactor, TimeUnit timeUnit, int retries) {
        if (maxDelay < minDelay) {
            throw new IllegalArgumentException("Max delay can not be less than min delay");
        }
        if (delayFactor < 1) {
            throw new IllegalArgumentException("Factor can not be less than 1");
        }
        if (timeUnit == null) {
            throw new IllegalArgumentException("TimeUnit can not be null");
        }
        this.taskName = !StringHelper.isNullOrEmpty(taskName) ? taskName : "Undefined task";
        this.minDelay = minDelay;
        this.maxDelay = maxDelay;
        this.timeUnit = timeUnit;
        this.delayFactor = delayFactor;
        this.retries = retries;
        this.logger = logger;
    }

    public <T> T tryExecute(final Callable<T> command) throws Exception {
        T result = null;
        this.logger.fine("Start execution of task: " + this.taskName);
        this.innerDelay = this.minDelay;
        this.executor = Executors.newScheduledThreadPool(1, new CustomizableThreadFactory(this.taskName + " - Retry Thread #"));
        long i = 0L;
        while (this.running) {
            long retry;
            ++i;
            ScheduledFuture future = this.executor.schedule(new Callable<T>(){

                @Override
                public T call() throws Exception {
                    return command.call();
                }
            }, (long)this.innerDelay, this.timeUnit);
            try {
                result = (T)future.get();
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (retry == 1L) {
                    this.logger.warning("Can't execute a provided task '" + this.taskName + "', cause : " + cause.getMessage());
                    if (this.retries > 0) {
                        this.logger.warning("Retry the execution of this task " + this.retries + " times before complete failure.");
                    } else {
                        this.logger.warning("Retry the execution of this task indefinitely");
                    }
                }
                if (this.retries > 0 && retry == (long)(this.retries - 1)) {
                    this.executor.shutdownNow();
                    throw new Exception("Can not get a valid response in " + this.retries + " tries...", cause);
                }
                if (this.innerDelay < this.maxDelay && this.innerDelay * this.delayFactor < this.maxDelay) {
                    this.innerDelay *= this.delayFactor;
                }
                this.innerDelay = this.maxDelay;
            }
            if (result != null) {
                this.logger.fine("Task '" + this.taskName + "' succeed.");
                this.running = false;
                continue;
            }
            if (this.retries <= 0 || retry != (long)(this.retries - 1)) continue;
            this.logger.warning("Retry proccess for task '" + this.taskName + "' stops without result.");
            this.running = false;
        }
        this.executor.shutdownNow();
        return result;
    }

    public int getActualDelay() {
        return this.innerDelay;
    }

    public void cancel() {
        this.running = false;
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }
}

