/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.wsstar.notification.service.basenotification.impl;

import com.ebmwebsourcing.wsstar.addressing.definition.WSAddressingFactory;
import com.ebmwebsourcing.wsstar.addressing.definition.api.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.addressing.definition.api.ReferenceParametersType;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingException;
import com.ebmwebsourcing.wsstar.addressing.definition.api.absitf.AbsItfReferenceParametersType;
import com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.FilterType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Renew;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.RenewResponse;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Subscribe;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.SubscriptionManagerRP;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.SubscriptionPolicyType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.TopicExpressionType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Unsubscribe;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.UnsubscribeResponse;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationException;
import com.ebmwebsourcing.wsstar.notification.extension.WSNotificationExtensionFactory;
import com.ebmwebsourcing.wsstar.notification.extension.api.ResourcesUuidType;
import com.ebmwebsourcing.wsstar.notification.extension.api.SOAParameterType;
import com.ebmwebsourcing.wsstar.notification.extension.api.TerminationTimeType;
import com.ebmwebsourcing.wsstar.notification.extension.utils.WSNotificationExtensionException;
import com.ebmwebsourcing.wsstar.notification.extension.utils.WsnSpecificTypeHelper;
import com.ebmwebsourcing.wsstar.notification.service.basenotification.WsnbSubscriptionManager;
import com.ebmwebsourcing.wsstar.notification.service.fault.ResourceNotDestroyedFault;
import com.ebmwebsourcing.wsstar.notification.service.fault.ResourceUnknownFault;
import com.ebmwebsourcing.wsstar.notification.service.fault.UnacceptableInitialTerminationTimeFault;
import com.ebmwebsourcing.wsstar.notification.service.fault.WSNotificationFault;
import com.ebmwebsourcing.wsstar.notification.service.persistence.WsnPersistence;
import com.ebmwebsourcing.wsstar.notification.service.topic.WstopTopicManager;
import com.ebmwebsourcing.wsstar.notification.service.util.WSNotificationTopicManagerBadUsageException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.namespace.QName;

public class SubscriptionManagerMgr
implements WsnbSubscriptionManager {
    protected Logger logger;
    protected Map<String, SubscriptionManagerRP> subscriptions;
    protected WstopTopicManager topicsMgr;
    protected WsnPersistence persistenceMgr;
    protected String subscriptionsManagerEdp = "http://www.ebmwebsourcing.com/subscriptionManager/default";
    protected QName subscriptionsManagerService = new QName("http://www.ebmwebsourcing.com/default", "SubscriptionManagerService");
    protected QName subscriptionsManagerInterface = new QName("http://www.ebmwebsourcing.com/default", "SubscriptionManager");

    public SubscriptionManagerMgr(Logger logger, WstopTopicManager topicsMgr, WsnPersistence persistenceMgr) {
        this.logger = logger;
        this.subscriptions = new ConcurrentHashMap<String, SubscriptionManagerRP>();
        this.topicsMgr = topicsMgr;
        this.persistenceMgr = persistenceMgr;
    }

    public SubscriptionManagerMgr(Logger logger, WstopTopicManager topicsMgr) {
        this.logger = logger;
        this.subscriptions = new ConcurrentHashMap<String, SubscriptionManagerRP>();
        this.topicsMgr = topicsMgr;
        this.persistenceMgr = null;
    }

    public SubscriptionManagerMgr(Logger logger) {
        this.logger = logger;
        this.subscriptions = new ConcurrentHashMap<String, SubscriptionManagerRP>();
        this.persistenceMgr = null;
    }

    public String getSubscriptionsManagerEdp() {
        return this.subscriptionsManagerEdp;
    }

    public void setSubscriptionsManagerEdp(String subscriptionsMgrEdp) {
        this.subscriptionsManagerEdp = subscriptionsMgrEdp;
    }

    public QName getSubscriptionsManagerService() {
        return this.subscriptionsManagerService;
    }

    public void setSubscriptionsManagerService(QName subscriptionsMgrService) {
        this.subscriptionsManagerService = subscriptionsMgrService;
    }

    public QName getSubscriptionsManagerInterface() {
        return this.subscriptionsManagerInterface;
    }

    public void setSubscriptionsManagerInterface(QName subscriptionsMgrInterface) {
        this.subscriptionsManagerInterface = subscriptionsMgrInterface;
    }

    public List<String> getStoredSubscriptionIds() {
        return new CopyOnWriteArrayList<String>(this.subscriptions.keySet());
    }

    public WstopTopicManager getTopicsMgr() {
        return this.topicsMgr;
    }

    public void setTopicsMgr(WstopTopicManager topicsMgr) {
        this.topicsMgr = topicsMgr;
    }

    @Override
    public UnsubscribeResponse unsubscribe(Unsubscribe request) throws WSNotificationException, WSNotificationFault, WSNotificationExtensionException {
        List resourcesId;
        this.logger.log(Level.FINE, "performs a \"Unsubscribe\" request ...");
        this.logger.log(Level.FINE, "\"Unsubscribe\"  method implementation in progress ... ");
        if (this.topicsMgr == null) {
            throw new WSNotificationTopicManagerBadUsageException(this.getClass().getSimpleName(), "unsubscribe()");
        }
        UnsubscribeResponse response = null;
        ResourcesUuidType uuids = WsnSpecificTypeHelper.getResourcesUuidType((Unsubscribe)request);
        if (uuids != null && (resourcesId = uuids.getUuids()) != null) {
            for (String rId : resourcesId) {
                if (this.subscriptions.containsKey(rId)) {
                    this.subscriptions.remove(rId);
                    if (this.subscriptions.containsKey(rId)) {
                        throw new ResourceNotDestroyedFault("eng", "The SubscriptionManager was unable to destroy the Subscription resource for some reason.");
                    }
                    this.topicsMgr.removeExistingSubscription(rId);
                    if (this.persistenceMgr == null) continue;
                    this.persistenceMgr.removeSubscription(rId);
                    continue;
                }
                throw new ResourceUnknownFault("eng", "The SubscriptionManager is acting as a WS-Resource, and the resource identified in the message is not known to the Web service.");
            }
        }
        response = WSNotificationFactory.getInstance().createUnsubscribeResponse();
        return response;
    }

    @Override
    public RenewResponse renew(Renew request) throws WSNotificationException, WSNotificationFault, WSNotificationExtensionException {
        this.logger.log(Level.FINE, "performs a \"Renew\" request ...");
        RenewResponse response = null;
        ResourcesUuidType uuids = WsnSpecificTypeHelper.getResourcesUuidType((Renew)request);
        if (uuids != null) {
            String ruuid = (String)uuids.getUuids().get(0);
            SubscriptionManagerRP subscriptionRP = this.subscriptions.get(ruuid);
            if (subscriptionRP == null) {
                throw new ResourceUnknownFault("eng", "The SubscriptionManager is acting as a WS-Resource, and the resource identified in the message is not known to the Web service.");
            }
            TerminationTimeType newTerminationTime = WSNotificationExtensionFactory.getInstance().createTerminationTimeType();
            String newTerminationTimeVal = request.getTerminationTime();
            Date timeVar = new GregorianCalendar().getTime();
            response = WSNotificationFactory.getInstance().createRenewResponse();
            response.setCurrentTime(timeVar);
            try {
                if (newTerminationTimeVal.startsWith("P")) {
                    DatatypeFactory.newInstance().newDuration(newTerminationTimeVal).addTo(timeVar);
                } else {
                    timeVar = DatatypeFactory.newInstance().newXMLGregorianCalendar(newTerminationTimeVal).toGregorianCalendar().getTime();
                }
            }
            catch (DatatypeConfigurationException e) {
                throw new WSNotificationException(e);
            }
            newTerminationTime.setValue(timeVar);
            WsnSpecificTypeHelper.setTerminationTimeToSubscription((TerminationTimeType)newTerminationTime, (SubscriptionManagerRP)subscriptionRP);
            response.setTerminationTime(timeVar);
            if (this.persistenceMgr != null) {
                this.persistenceMgr.persist(subscriptionRP, ruuid);
            }
        }
        return response;
    }

    public EndpointReferenceType createAndStoreSubscriptionResource(String subscriptionId, Subscribe payload) throws WSNotificationException, WSAddressingException, WSNotificationFault, WSNotificationExtensionException {
        if (this.topicsMgr == null) {
            throw new WSNotificationTopicManagerBadUsageException(this.getClass().getSimpleName(), "createAndStoreSubscriptionResource()");
        }
        EndpointReferenceType subsRef = null;
        SubscriptionManagerRP subscription = null;
        subsRef = WSAddressingFactory.getInstance().newEndpointReferenceType();
        subsRef.setAddress(payload.getConsumerReference().getAddress());
        ReferenceParametersType ref = (ReferenceParametersType)subsRef.newReferenceParameters();
        subsRef.setReferenceParameters((AbsItfReferenceParametersType)ref);
        SOAParameterType soaParam = WSNotificationExtensionFactory.getInstance().createSOAParameterType();
        soaParam.setService(this.subscriptionsManagerService);
        soaParam.setInterface(this.subscriptionsManagerInterface);
        soaParam.setEndpoint(this.subscriptionsManagerEdp);
        WsnSpecificTypeHelper.setSOAParameter((SOAParameterType)soaParam, (ReferenceParametersType)ref);
        ResourcesUuidType rUuids = WSNotificationExtensionFactory.getInstance().createResourcesUuidType();
        rUuids.addUuid(subscriptionId);
        WsnSpecificTypeHelper.setResourcesUuidType((ResourcesUuidType)rUuids, (ReferenceParametersType)ref);
        subscription = WSNotificationFactory.getInstance().createSubscriptionManagerRP();
        subscription.setConsumerReference(payload.getConsumerReference());
        FilterType ft = payload.getFilter();
        subscription.setFilter(ft);
        Date now = new GregorianCalendar().getTime();
        subscription.setCreationTime(now);
        subscription.setSubscriptionPolicy(payload.getSubscriptionPolicy());
        try {
            String initTermTime = payload.getInitialTerminationTime();
            if (initTermTime != null && initTermTime.length() > 0) {
                TerminationTimeType termTime = WSNotificationExtensionFactory.getInstance().createTerminationTimeType();
                Date termTimeValue = null;
                if (initTermTime.startsWith("P")) {
                    Duration duration = DatatypeFactory.newInstance().newDuration(initTermTime);
                    termTimeValue = new GregorianCalendar().getTime();
                    duration.addTo(termTimeValue);
                } else {
                    termTimeValue = DatatypeFactory.newInstance().newXMLGregorianCalendar(initTermTime).toGregorianCalendar().getTime();
                }
                if (!termTimeValue.after(now)) {
                    throw new UnacceptableInitialTerminationTimeFault("eng", "The value of InitialTerminationTime specified in the Subscribe message was not\tacceptable to the NotificationProducer.");
                }
                termTime.setValue(termTimeValue);
                WsnSpecificTypeHelper.setTerminationTimeToSubscription((TerminationTimeType)termTime, (SubscriptionManagerRP)subscription);
            }
        }
        catch (DatatypeConfigurationException e) {
            throw new WSNotificationExtensionException((Throwable)e);
        }
        this.subscriptions.put(subscriptionId, subscription);
        if (this.persistenceMgr != null) {
            this.persistenceMgr.persist(subscription, subscriptionId);
        }
        return subsRef;
    }

    public EndpointReferenceType getConsumerEdpRefOfSubscription(String subscriptionId) throws WSNotificationException {
        if (this.topicsMgr == null) {
            throw new WSNotificationTopicManagerBadUsageException(this.getClass().getSimpleName(), "getConsumerEdpRefOfSubscription()");
        }
        EndpointReferenceType consumerEdp = null;
        SubscriptionManagerRP subsManResource = this.subscriptions.get(subscriptionId);
        if (subsManResource != null) {
            consumerEdp = subsManResource.getConsumerReference();
        }
        return consumerEdp;
    }

    public TopicExpressionType getTopicExpressionOfSubscription(String subscriptionId) throws WSNotificationException {
        if (this.topicsMgr == null) {
            throw new WSNotificationTopicManagerBadUsageException(this.getClass().getSimpleName(), "getTopicExpressionOfSubscription()");
        }
        TopicExpressionType topExpr = null;
        SubscriptionManagerRP subsManResource = this.subscriptions.get(subscriptionId);
        if (subsManResource != null) {
            topExpr = subsManResource.getFilter().getTopicExpression();
        }
        return topExpr;
    }

    public FilterType getFilterOfSubscription(String subscriptionId) throws WSNotificationException {
        if (this.topicsMgr == null) {
            throw new WSNotificationTopicManagerBadUsageException(this.getClass().getSimpleName(), "getFilterOfSubscription()");
        }
        FilterType filter = null;
        SubscriptionManagerRP subsManResource = this.subscriptions.get(subscriptionId);
        if (subsManResource != null) {
            filter = subsManResource.getFilter();
        }
        return filter;
    }

    public SubscriptionPolicyType getPolicyOfSubscription(String subscriptionId) throws WSNotificationException {
        if (this.topicsMgr == null) {
            throw new WSNotificationTopicManagerBadUsageException(this.getClass().getSimpleName(), "getPolicyOfSubscription()");
        }
        SubscriptionPolicyType policy = null;
        SubscriptionManagerRP subsManResource = this.subscriptions.get(subscriptionId);
        if (subsManResource != null) {
            policy = subsManResource.getSubscriptionPolicy();
        }
        return policy;
    }

    public TerminationTimeType getTerminationTimeOfSubscription(String subscriptionId) throws WSNotificationException {
        if (this.topicsMgr == null) {
            throw new WSNotificationTopicManagerBadUsageException(this.getClass().getSimpleName(), "getTerminationTimeOfSubscription()");
        }
        TerminationTimeType terminationTime = null;
        SubscriptionManagerRP subsManRP = this.subscriptions.get(subscriptionId);
        if (subsManRP != null) {
            try {
                terminationTime = WsnSpecificTypeHelper.getTerminationTimeFromSubscription((SubscriptionManagerRP)subsManRP);
            }
            catch (WSNotificationExtensionException e) {
                throw new WSNotificationException(e);
            }
        }
        return terminationTime;
    }

    public void removeExpiredSubscription(String subscriptionId) throws WSNotificationException {
        if (this.topicsMgr == null) {
            throw new WSNotificationTopicManagerBadUsageException(this.getClass().getSimpleName(), "removeExpiredSubscription()");
        }
        if (this.subscriptions.containsKey(subscriptionId)) {
            this.subscriptions.remove(subscriptionId);
            try {
                this.topicsMgr.removeExistingSubscription(subscriptionId);
            }
            catch (WSNotificationFault e) {
                throw new WSNotificationException(e);
            }
            if (this.persistenceMgr != null) {
                this.persistenceMgr.removeSubscription(subscriptionId);
            }
        }
    }

    public void restorePersistedSubscriptions() throws WSNotificationException, WSNotificationFault {
        if (this.topicsMgr == null) {
            throw new WSNotificationTopicManagerBadUsageException(this.getClass().getSimpleName(), "restorePersistedSubscriptions()");
        }
        if (this.persistenceMgr != null) {
            Map<String, SubscriptionManagerRP> subsRPToRestore = this.persistenceMgr.getSubscriptionsToRestore();
            Set<String> rIds = subsRPToRestore.keySet();
            SubscriptionManagerRP currentSubsRP = null;
            for (String idItem : rIds) {
                currentSubsRP = subsRPToRestore.get(idItem);
                this.subscriptions.put(idItem, currentSubsRP);
                this.topicsMgr.storeNewSubscription(currentSubsRP.getFilter().getTopicExpression(), idItem);
            }
        }
    }

    public Map<String, Subscribe> getSubscriptionsRPAsSubscribePayoad() throws WSNotificationException {
        ConcurrentHashMap<String, Subscribe> result = new ConcurrentHashMap<String, Subscribe>();
        SubscriptionManagerRP currentSubscriptionManagerRP = null;
        for (Map.Entry<String, SubscriptionManagerRP> mapPairItem : this.subscriptions.entrySet()) {
            currentSubscriptionManagerRP = mapPairItem.getValue();
            Subscribe currentSubscribePayload = WSNotificationFactory.getInstance().createSubscribe();
            currentSubscribePayload.setConsumerReference(currentSubscriptionManagerRP.getConsumerReference());
            currentSubscribePayload.setFilter(currentSubscriptionManagerRP.getFilter());
            currentSubscribePayload.setSubscriptionPolicy(currentSubscriptionManagerRP.getSubscriptionPolicy());
            result.put(mapPairItem.getKey(), currentSubscribePayload);
        }
        return result;
    }
}

