/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.su;

import java.util.HashMap;
import java.util.Map;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;
import org.ow2.petals.component.framework.interceptor.MessageInterceptorManager;
import org.ow2.petals.component.framework.jbidescriptor.generated.Consumes;
import org.ow2.petals.component.framework.jbidescriptor.generated.Jbi;
import org.ow2.petals.component.framework.jbidescriptor.generated.Provides;
import org.ow2.petals.component.framework.util.ServiceEndpointKey;
import org.w3c.dom.Document;

public class ServiceUnitDataHandler {
    private Jbi descriptor;
    private Map<ServiceEndpointKey, Provides> epJBIDesc;
    private Map<ServiceEndpointKey, Document> epServiceDesc = new HashMap<ServiceEndpointKey, Document>();
    private final Map<ServiceEndpointKey, ServiceEndpoint> endpoints;
    private final Map<Object, MessageInterceptorManager> messageInterceptorManagersMap;
    private final Map<Object, ConfigurationExtensions> configurationExtensionsMap;
    private final Map<Consumes, ConfigurationExtensions> exchangePropertiesMap;
    private String installRoot;
    private String name;

    private ServiceUnitDataHandler() {
        this.epJBIDesc = new HashMap<ServiceEndpointKey, Provides>();
        this.endpoints = new HashMap<ServiceEndpointKey, ServiceEndpoint>();
        this.messageInterceptorManagersMap = new HashMap<Object, MessageInterceptorManager>();
        this.configurationExtensionsMap = new HashMap<Object, ConfigurationExtensions>();
        this.exchangePropertiesMap = new HashMap<Consumes, ConfigurationExtensions>();
    }

    public ServiceUnitDataHandler(String suName, String installRoot, Jbi jbiDescriptor) {
        this();
        this.name = suName;
        this.installRoot = installRoot;
        this.descriptor = jbiDescriptor;
        for (Consumes consumes : this.descriptor.getServices().getConsumes()) {
            this.configurationExtensionsMap.put(consumes, new ConfigurationExtensions(consumes.getAny()));
            if (consumes.getExchangeProperties() == null) continue;
            this.exchangePropertiesMap.put(consumes, new ConfigurationExtensions(consumes.getExchangeProperties().getExchangeProperty()));
        }
        for (Provides provides : this.descriptor.getServices().getProvides()) {
            this.configurationExtensionsMap.put(provides, new ConfigurationExtensions(provides.getAny()));
        }
    }

    public void addEndpointDescription(ServiceEndpoint endpoint, Document description) {
        this.addEndpointDescription(endpoint.getServiceName(), endpoint.getEndpointName(), description);
    }

    public Document getEndpointDescription(ServiceEndpoint endpoint) {
        return this.epServiceDesc.get(new ServiceEndpointKey(endpoint.getServiceName(), endpoint.getEndpointName()));
    }

    public void addEndpointDescription(QName serviceName, String endpointName, Document description) {
        this.epServiceDesc.put(new ServiceEndpointKey(serviceName, endpointName), description);
    }

    public void addJBIDescription(ServiceEndpoint endpoint, Provides provides) {
        this.addJBIDescription(endpoint.getServiceName(), endpoint.getEndpointName(), provides);
    }

    public void addJBIDescription(QName serviceName, String endpointName, Provides provides) {
        this.epJBIDesc.put(new ServiceEndpointKey(serviceName, endpointName), provides);
    }

    public void addServiceEndpoint(ServiceEndpoint serviceEndpoint) {
        this.endpoints.put(new ServiceEndpointKey(serviceEndpoint.getServiceName(), serviceEndpoint.getEndpointName()), serviceEndpoint);
    }

    public Map<ServiceEndpointKey, ServiceEndpoint> getServiceEndpoints() {
        return this.endpoints;
    }

    public Jbi getDescriptor() {
        return this.descriptor;
    }

    public Map<ServiceEndpointKey, Provides> getEpJBIDesc() {
        return this.epJBIDesc;
    }

    public Map<ServiceEndpointKey, Document> getEpServiceDesc() {
        return this.epServiceDesc;
    }

    public String getInstallRoot() {
        return this.installRoot;
    }

    public String getName() {
        return this.name;
    }

    public void removeEndpoint(ServiceEndpoint endpoint) {
        ServiceEndpointKey key = new ServiceEndpointKey(endpoint.getServiceName(), endpoint.getEndpointName());
        this.epServiceDesc.remove(key);
        this.epJBIDesc.remove(key);
        this.endpoints.remove(key);
    }

    public void setEpJBIDesc(Map<ServiceEndpointKey, Provides> epJBIDesc) {
        this.epJBIDesc = epJBIDesc;
    }

    public void setEpServiceDesc(Map<ServiceEndpointKey, Document> epServiceDesc) {
        this.epServiceDesc = epServiceDesc;
    }

    public void addMessageInterceptorManager(Object service, MessageInterceptorManager manager) {
        if (!(service instanceof Consumes) && !(service instanceof Provides)) {
            throw new IllegalArgumentException("The parameter service  is not an instance of Provides or Consumes Classes");
        }
        this.messageInterceptorManagersMap.put(service, manager);
    }

    public MessageInterceptorManager getMessageInterceptorManager(Object service) {
        return this.messageInterceptorManagersMap.get(service);
    }

    public Map<Object, MessageInterceptorManager> getMessageInterceptorManagersMap() {
        return this.messageInterceptorManagersMap;
    }

    public ConfigurationExtensions getConfigurationExtensions(Object service) {
        return this.configurationExtensionsMap.get(service);
    }
}

