/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.se.pojo;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.logging.Logger;
import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.MessagingException;
import org.ow2.petals.component.framework.api.exception.FaultException;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.process.async.AsyncContext;
import org.ow2.petals.se.pojo.su.POJOURLClassLoader;

public class Pojo {
    public static final String COMPONENT_CONTEXT_SETTER = "setComponentContext";
    public static final String DELIVERY_CHANNEL_SETTER = "setDeliveryChannel";
    public static final String JBI_LISTENER_SETTER = "setJBIListener";
    public static final String LOGGER_SETTER = "setLogger";
    public static final String ON_EXCHANGE_METHOD = "onExchange";
    public static final String ON_ASYNC_EXCHANGE_METHOD = "onAsyncExchange";
    public static final String ON_EXPIRED_ASYNC_EXCHANGE_METHOD = "onExpiredAsyncExchange";
    private DeliveryChannel channel;
    private POJOURLClassLoader classLoader;
    private ComponentContext context;
    private Logger logger;
    private Method onExchangeMethod;
    private Method onAsyncExchangeMethod;
    private Method onExpiredAsyncExchangeMethod;
    private Object pojo;

    public Pojo(Object object, POJOURLClassLoader classLoader, ComponentContext context, DeliveryChannel channel, Logger logger) {
        this.pojo = object;
        this.context = context;
        this.channel = channel;
        this.logger = logger;
        this.classLoader = classLoader;
    }

    public Object getPojo() {
        return this.pojo;
    }

    public boolean callOnExchangeMethod(Exchange ex, AsyncContext asyncContext) throws MessagingException, FaultException {
        Method onExchange = asyncContext == null ? this.onExchangeMethod : this.onAsyncExchangeMethod;
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.classLoader);
        boolean result = false;
        try {
            Object object = asyncContext == null ? onExchange.invoke(this.pojo, ex) : onExchange.invoke(this.pojo, ex, asyncContext);
            result = (Boolean)object;
        }
        catch (IllegalArgumentException e) {
            throw new MessagingException("Java reflection exception during call on " + onExchange.getName() + "() on the POJO.", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new MessagingException("Java reflection exception during call on " + onExchange.getName() + "() on the POJO.", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            Throwable orginalEx = e.getCause();
            if (orginalEx != null && orginalEx instanceof FaultException) {
                throw (FaultException)orginalEx;
            }
            throw new MessagingException("Processing exception during call on " + onExchange.getName() + "() on the POJO.", (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        return result;
    }

    public boolean callOnExpiredAsyncJBIMessage(Exchange expiredExchange, AsyncContext asyncContext) throws MessagingException, FaultException {
        Method onExchange = asyncContext == null ? this.onExchangeMethod : this.onExpiredAsyncExchangeMethod;
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.classLoader);
        boolean result = false;
        try {
            Object object = asyncContext == null ? onExchange.invoke(this.pojo, expiredExchange) : onExchange.invoke(this.pojo, expiredExchange, asyncContext);
            result = (Boolean)object;
        }
        catch (IllegalArgumentException e) {
            throw new MessagingException("Java reflection exception during call on " + onExchange.getName() + "() on the POJO.", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new MessagingException("Java reflection exception during call on " + onExchange.getName() + "() on the POJO.", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            Throwable orginalEx = e.getCause();
            if (orginalEx != null && orginalEx instanceof FaultException) {
                throw (FaultException)orginalEx;
            }
            throw new MessagingException("Processing exception during call on " + onExchange.getName() + "() on the POJO.", (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        return result;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void init() throws Exception {
        this.setLoggerOnPojo();
        this.setContextOnPojo();
        this.setChannelOnPojo();
        this.call("init");
        this.setupOnExchangeMethod();
        this.setupOnAsyncExchangeMethod();
        this.setupOnExpiredAsyncExchangeMethod();
    }

    public void shutdown() throws Exception {
        this.classLoader.close(this.logger);
        this.call("shutdown");
    }

    public void start() throws Exception {
        this.call("start");
    }

    public void stop() throws Exception {
        this.call("stop");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void call(String methodName) throws MessagingException {
        block7: {
            ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.classLoader);
            try {
                Method m = Pojo.findMethod(this.pojo.getClass(), methodName, null);
                if (m == null) break block7;
                try {
                    m.invoke(this.pojo, new Object[0]);
                }
                catch (IllegalArgumentException e) {
                    throw new MessagingException("Java reflection exception during call on " + methodName + "() on the POJO.", (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    throw new MessagingException("Java reflection exception during call on " + methodName + "() on the POJO.", (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    throw new MessagingException("Processing exception during call on " + methodName + "() on the POJO.", (Throwable)e);
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setChannelOnPojo() throws PEtALSCDKException {
        block5: {
            ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.classLoader);
            try {
                Method setChannelMethod = Pojo.findMethod(this.pojo.getClass(), DELIVERY_CHANNEL_SETTER, DeliveryChannel.class);
                if (setChannelMethod == null) break block5;
                try {
                    setChannelMethod.invoke(this.pojo, this.channel);
                }
                catch (Exception e) {
                    throw new PEtALSCDKException("Can not set the DeliveryChannel on the POJO", (Throwable)e);
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setContextOnPojo() throws PEtALSCDKException {
        block5: {
            ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.classLoader);
            try {
                Method setContextMethod = Pojo.findMethod(this.pojo.getClass(), COMPONENT_CONTEXT_SETTER, ComponentContext.class);
                if (setContextMethod == null) break block5;
                try {
                    setContextMethod.invoke(this.pojo, this.context);
                }
                catch (Exception e) {
                    throw new PEtALSCDKException("Can not set the ComponentContext on the POJO", (Throwable)e);
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setLoggerOnPojo() throws PEtALSCDKException {
        block5: {
            ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.classLoader);
            try {
                Method setLoggerMethod = Pojo.findMethod(this.pojo.getClass(), LOGGER_SETTER, Logger.class);
                if (setLoggerMethod == null) break block5;
                try {
                    setLoggerMethod.invoke(this.pojo, this.logger);
                }
                catch (Exception e) {
                    throw new PEtALSCDKException("Can not set the Logger on the POJO", (Throwable)e);
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldClassLoader);
            }
        }
    }

    protected void setupOnExchangeMethod() throws PEtALSCDKException {
        this.onExchangeMethod = Pojo.findMethod(this.pojo.getClass(), ON_EXCHANGE_METHOD, Exchange.class);
        if (this.onExchangeMethod == null) {
            throw new PEtALSCDKException("The 'onExchange' method is not found in " + this.pojo.getClass());
        }
        if (this.onExchangeMethod.getReturnType() != Boolean.TYPE) {
            throw new PEtALSCDKException("The 'onExchange' method signature is not correct, it must return a boolean");
        }
    }

    protected void setupOnAsyncExchangeMethod() throws PEtALSCDKException {
        Class[] args = new Class[]{Exchange.class, AsyncContext.class};
        try {
            this.onAsyncExchangeMethod = this.pojo.getClass().getMethod(ON_ASYNC_EXCHANGE_METHOD, args);
        }
        catch (NoSuchMethodException e) {
            this.onAsyncExchangeMethod = null;
        }
        if (this.onAsyncExchangeMethod != null && this.onAsyncExchangeMethod.getReturnType() != Boolean.TYPE) {
            throw new PEtALSCDKException("The 'onAsyncExchange' method signature is not correct, it must return a boolean");
        }
    }

    protected void setupOnExpiredAsyncExchangeMethod() throws PEtALSCDKException {
        Class[] args = new Class[]{Exchange.class, AsyncContext.class};
        try {
            this.onExpiredAsyncExchangeMethod = this.pojo.getClass().getMethod(ON_EXPIRED_ASYNC_EXCHANGE_METHOD, args);
        }
        catch (NoSuchMethodException e) {
            this.onExpiredAsyncExchangeMethod = null;
        }
        if (this.onExpiredAsyncExchangeMethod != null && this.onExpiredAsyncExchangeMethod.getReturnType() != Boolean.TYPE) {
            throw new PEtALSCDKException("The 'onExpiredAsyncExchange' method signature is not correct, it must return a boolean");
        }
    }

    public static final Method findMethod(Class<?> clazz, String name, Class<?> parameterClass) {
        Method method = null;
        Method[] ms = clazz.getMethods();
        for (int i = 0; i < ms.length && method == null; ++i) {
            Method tmpMethod = ms[i];
            if (!tmpMethod.getName().equals(name) || !Modifier.isPublic(tmpMethod.getModifiers())) continue;
            if (parameterClass != null && tmpMethod.getParameterTypes().length == 1 && parameterClass.isAssignableFrom(tmpMethod.getParameterTypes()[0])) {
                method = tmpMethod;
                continue;
            }
            if (parameterClass != null || tmpMethod.getParameterTypes().length != 0) continue;
            method = tmpMethod;
        }
        return method;
    }
}

