/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.se.pojo.su;

import java.net.URL;
import java.util.List;
import org.ow2.petals.commons.exception.ExceptionUtil;
import org.ow2.petals.component.framework.AbstractComponent;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.jbidescriptor.generated.Jbi;
import org.ow2.petals.component.framework.jbidescriptor.generated.Provides;
import org.ow2.petals.component.framework.su.ServiceEngineServiceUnitManager;
import org.ow2.petals.component.framework.su.ServiceUnitDataHandler;
import org.ow2.petals.component.framework.util.ClassLoaderUtil;
import org.ow2.petals.component.framework.util.StringHelper;
import org.ow2.petals.se.pojo.Pojo;
import org.ow2.petals.se.pojo.PojoComponent;
import org.ow2.petals.se.pojo.su.POJOURLClassLoader;

public class SUManager
extends ServiceEngineServiceUnitManager {
    public SUManager(AbstractComponent engine) {
        super(engine);
    }

    @Override
    public void doDeploy(String serviceUnitName, String suRootPath, Jbi descriptor) throws PEtALSCDKException {
        ServiceUnitDataHandler suDatahandler;
        ConfigurationExtensions extensions;
        String className;
        if (descriptor.getServices().getConsumes().size() != 0) {
            throw new PEtALSCDKException("Consumes section are not supported by this component");
        }
        List providesList = descriptor.getServices().getProvides();
        if (providesList == null || providesList.size() != 1) {
            throw new PEtALSCDKException("Only one Provides section supported");
        }
        Provides provides = (Provides)providesList.get(0);
        if (provides != null && StringHelper.isNullOrEmpty(className = (extensions = (suDatahandler = this.getSUDataHandlerForService(provides)).getConfigurationExtensions(provides)).get((Object)"class-name"))) {
            throw new PEtALSCDKException("Provides section must contains a POJO parameter 'class-name'");
        }
    }

    @Override
    public void doInit(String serviceUnitName, String suRootPath) throws PEtALSCDKException {
        Pojo pojo;
        Jbi jbiDescriptor = this.getServiceUnitDataHandlers().get(serviceUnitName).getDescriptor();
        Provides provides = (Provides)jbiDescriptor.getServices().getProvides().get(0);
        ServiceUnitDataHandler suDatahandler = this.getSUDataHandlerForService(provides);
        ConfigurationExtensions extensions = suDatahandler.getConfigurationExtensions(provides);
        String className = extensions.get((Object)"class-name");
        try {
            pojo = this.createPojo(className, suDatahandler);
            pojo.init();
        }
        catch (Exception e) {
            if (e instanceof PEtALSCDKException) {
                throw (PEtALSCDKException)((Object)e);
            }
            throw new PEtALSCDKException(ExceptionUtil.getExtendedMessage((Exception)e));
        }
        ((PojoComponent)this.component).getPojos().put(provides.getEndpointName(), pojo);
    }

    @Override
    public void doShutdown(String serviceUnitName) throws PEtALSCDKException {
        Jbi jbiDescriptor = this.getServiceUnitDataHandlers().get(serviceUnitName).getDescriptor();
        Provides provides = (Provides)jbiDescriptor.getServices().getProvides().get(0);
        try {
            Pojo pojo = ((PojoComponent)this.component).getPojos().remove(provides.getEndpointName());
            pojo.shutdown();
        }
        catch (Exception e) {
            if (e instanceof PEtALSCDKException) {
                throw (PEtALSCDKException)((Object)e);
            }
            throw new PEtALSCDKException(ExceptionUtil.getExtendedMessage((Exception)e));
        }
    }

    @Override
    public void doStart(String serviceUnitName) throws PEtALSCDKException {
        Jbi jbiDescriptor = this.getServiceUnitDataHandlers().get(serviceUnitName).getDescriptor();
        Provides provides = (Provides)jbiDescriptor.getServices().getProvides().get(0);
        try {
            ((PojoComponent)this.component).getPojos().get(provides.getEndpointName()).start();
        }
        catch (Exception e) {
            if (e instanceof PEtALSCDKException) {
                throw (PEtALSCDKException)((Object)e);
            }
            throw new PEtALSCDKException(ExceptionUtil.getExtendedMessage((Exception)e));
        }
    }

    @Override
    public void doStop(String serviceUnitName) throws PEtALSCDKException {
        Jbi jbiDescriptor = this.getServiceUnitDataHandlers().get(serviceUnitName).getDescriptor();
        Provides provides = (Provides)jbiDescriptor.getServices().getProvides().get(0);
        try {
            ((PojoComponent)this.component).getPojos().get(provides.getEndpointName()).stop();
        }
        catch (Exception e) {
            if (e instanceof PEtALSCDKException) {
                throw (PEtALSCDKException)((Object)e);
            }
            throw new PEtALSCDKException(ExceptionUtil.getExtendedMessage((Exception)e));
        }
    }

    @Override
    public void doUndeploy(String serviceUnitName) throws PEtALSCDKException {
        ((PojoComponent)this.component).getPojos().remove(serviceUnitName);
    }

    private Pojo createPojo(String className, ServiceUnitDataHandler suDatahandler) throws Exception {
        URL[] arrayOfSuJar = ClassLoaderUtil.getUrls(suDatahandler.getInstallRoot());
        POJOURLClassLoader classLoader = new POJOURLClassLoader(arrayOfSuJar, this.getClass().getClassLoader());
        Class<?> clazz = classLoader.loadClass(className);
        return new Pojo(clazz.newInstance(), classLoader, this.component.getContext(), this.component.getChannel(), this.logger);
    }
}

