/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.se.quartz.job;

import com.ebmwebsourcing.easycommons.lang.StringHelper;
import com.ebmwebsourcing.easycommons.logger.Level;
import com.ebmwebsourcing.easycommons.thread.ExecutionContext;
import java.util.logging.Logger;
import javax.jbi.messaging.FlowAttributes;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import org.ow2.petals.commons.PetalsExecutionContext;
import org.ow2.petals.component.framework.api.Message;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.jbidescriptor.generated.Consumes;
import org.ow2.petals.component.framework.util.LoggingUtil;
import org.ow2.petals.component.framework.util.SourceUtil;
import org.ow2.petals.se.quartz.QuartzConsumeFlowStepBeginLogData;
import org.ow2.petals.se.quartz.QuartzExternalListener;
import org.ow2.petals.se.quartz.utils.QuartzUtils;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class EmitSignalJob
implements Job {
    public void execute(JobExecutionContext jobContext) throws JobExecutionException {
        JobDataMap dataMap = jobContext.getJobDetail().getJobDataMap();
        QuartzExternalListener quartzExternalListener = (QuartzExternalListener)((Object)dataMap.get((Object)"SchedulerManager"));
        Consumes consume = quartzExternalListener.getConsumes();
        ConfigurationExtensions extensions = new ConfigurationExtensions(consume.getAny());
        Logger logger = quartzExternalListener.getLogger();
        String serviceIdentifier = QuartzUtils.buildTargetServiceIdentifier(consume);
        PetalsExecutionContext.initFlowInstanceId();
        PetalsExecutionContext.nextFlowStepId();
        logger.log(Level.MONIT, "", (Object)new QuartzConsumeFlowStepBeginLogData(ExecutionContext.getProperties().getProperty("flowInstanceId"), ExecutionContext.getProperties().getProperty("flowStepId"), StringHelper.nonNullValue((Object)consume.getInterfaceName()), StringHelper.nonNullValue((Object)consume.getServiceName()), StringHelper.nonNullValue((Object)consume.getEndpointName()), StringHelper.nonNullValue((Object)consume.getOperation()), String.valueOf(jobContext.getFireTime().getTime())));
        try {
            String msg;
            Exchange exchange = quartzExternalListener.createConsumeExchange(consume, Message.MEPConstants.IN_ONLY_PATTERN);
            String content = extensions.get((Object)"content");
            if (content != null) {
                content = content.trim();
            }
            if (logger.isLoggable(Level.FINE)) {
                msg = "Creating the scheduled message " + exchange.getExchangeId() + " for " + serviceIdentifier + ".";
                logger.fine(msg);
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(exchange.getExchangeId() + ": the sent content is\n" + content);
            }
            exchange.getInMessage().setContent(SourceUtil.createSource((String)content));
            quartzExternalListener.send(exchange);
            if (logger.isLoggable(Level.INFO)) {
                msg = "The scheduled message " + exchange.getExchangeId() + " was successfully sent to " + serviceIdentifier + ".";
                logger.info(msg);
            }
        }
        catch (MessagingException e) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("A scheduled message cound not be sent to " + serviceIdentifier + " (MessagingException).");
            }
            LoggingUtil.addMonitFailureTrace((Logger)logger, (FlowAttributes)PetalsExecutionContext.getFlowAttributes(), (String)e.getMessage(), (MessageExchange.Role)MessageExchange.Role.CONSUMER);
        }
        catch (PEtALSCDKException e) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("A scheduled message cound not be sent to " + serviceIdentifier + " (PEtALSCDKException).");
            }
            LoggingUtil.addMonitFailureTrace((Logger)logger, (FlowAttributes)PetalsExecutionContext.getFlowAttributes(), (String)e.getMessage(), (MessageExchange.Role)MessageExchange.Role.CONSUMER);
        }
    }
}

