/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.petals.tools.rmi.server.util;

import java.net.URI;
import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.servicedesc.ServiceEndpoint;
import org.objectweb.petals.tools.rmi.common.serializable.NormalizedMessage;
import org.objectweb.petals.tools.rmi.common.serializable.messagingtypes.InOnly;
import org.objectweb.petals.tools.rmi.common.serializable.messagingtypes.InOptionalOut;
import org.objectweb.petals.tools.rmi.common.serializable.messagingtypes.InOut;
import org.objectweb.petals.tools.rmi.common.serializable.messagingtypes.RobustInOnly;

public final class Convert {
    public static final String IN_MSG = "in";
    public static final URI IN_ONLY_PATTERN = URI.create("http://www.w3.org/2004/08/wsdl/in-only");
    public static final URI IN_OPTIONAL_OUT_PATTERN = URI.create("http://www.w3.org/2004/08/wsdl/in-opt-out");
    public static final URI IN_OUT_PATTERN = URI.create("http://www.w3.org/2004/08/wsdl/in-out");
    public static final String OUT_MSG = "out";
    public static final URI ROBUST_IN_ONLY_PATTERN = URI.create("http://www.w3.org/2004/08/wsdl/robust-in-only");

    private Convert() {
    }

    public static MessageExchange convertConcreteMessageExchangeToFakeMessageExchange(MessageExchange concrete, URI pattern) throws MessagingException {
        MessageExchange fake = Convert.createAnEmptyFakeMessage(pattern);
        if (concrete.getEndpoint() != null) {
            fake.setEndpoint((ServiceEndpoint)new org.objectweb.petals.tools.rmi.common.serializable.ServiceEndpoint(concrete.getEndpoint().getServiceName(), concrete.getEndpoint().getEndpointName(), concrete.getEndpoint().getInterfaces()));
        }
        if (concrete.getError() != null) {
            fake.setError(Convert.convertException(concrete.getError()));
        }
        if (concrete.getFault() != null) {
            fake.setFault((Fault)Convert.convertConcreteToFakeNormalizedMessage((org.objectweb.petals.tools.rmi.common.serializable.MessageExchange)fake, (javax.jbi.messaging.NormalizedMessage)concrete.getFault()));
        }
        fake.setInterfaceName(concrete.getInterfaceName());
        if (concrete.getMessage(IN_MSG) != null) {
            fake.setMessage(Convert.convertConcreteToFakeNormalizedMessage((org.objectweb.petals.tools.rmi.common.serializable.MessageExchange)fake, concrete.getMessage(IN_MSG)), IN_MSG);
        }
        if (concrete.getMessage(OUT_MSG) != null) {
            fake.setMessage(Convert.convertConcreteToFakeNormalizedMessage((org.objectweb.petals.tools.rmi.common.serializable.MessageExchange)fake, concrete.getMessage(OUT_MSG)), OUT_MSG);
        }
        fake.setOperation(concrete.getOperation());
        if (concrete.getPropertyNames() != null) {
            for (Object property : concrete.getPropertyNames()) {
                fake.setProperty((String)property, concrete.getProperty((String)property));
            }
        }
        fake.setService(concrete.getService());
        fake.setStatus(concrete.getStatus());
        ((org.objectweb.petals.tools.rmi.common.serializable.MessageExchange)fake).setExchangeId(concrete.getExchangeId());
        ((org.objectweb.petals.tools.rmi.common.serializable.MessageExchange)fake).setProcessInstanceId(concrete.getProcessInstanceId());
        ((org.objectweb.petals.tools.rmi.common.serializable.MessageExchange)fake).setPattern(concrete.getPattern());
        return fake;
    }

    public static final JBIException convertJBIException(JBIException e) {
        JBIException me = new JBIException(e.getMessage());
        me.setStackTrace(e.getStackTrace());
        return me;
    }

    public static final MessagingException convertMessagingException(MessagingException e) {
        MessagingException me = new MessagingException(e.getMessage());
        me.setStackTrace(e.getStackTrace());
        return me;
    }

    public static Exception convertException(Exception e) {
        Exception exception = new Exception(e.getMessage());
        exception.setStackTrace(e.getStackTrace());
        return exception;
    }

    public static void setConcreteValueMEToFakeValueME(ComponentContext cc, MessageExchange concrete, org.objectweb.petals.tools.rmi.common.serializable.MessageExchange fake) throws MessagingException {
        if (fake.getStatus() == ExchangeStatus.DONE) {
            concrete.setStatus(fake.getStatus());
        } else if (fake.getStatus() == ExchangeStatus.ERROR) {
            concrete.setStatus(fake.getStatus());
            concrete.setError(fake.getError());
        } else {
            if (concrete.getEndpoint() != null) {
                fake.setEndpoint((ServiceEndpoint)new org.objectweb.petals.tools.rmi.common.serializable.ServiceEndpoint(concrete.getEndpoint().getServiceName(), concrete.getEndpoint().getEndpointName(), concrete.getEndpoint().getInterfaces()));
            } else {
                fake.setEndpoint(null);
            }
            fake.setError(concrete.getError());
            if (concrete.getFault() != null) {
                fake.setFault((Fault)Convert.convertConcreteToFakeNormalizedMessage(fake, (javax.jbi.messaging.NormalizedMessage)concrete.getFault()));
            } else {
                fake.setFault(null);
            }
            fake.setInterfaceName(concrete.getInterfaceName());
            if (concrete.getMessage(IN_MSG) != null) {
                fake.setMessage(Convert.convertConcreteToFakeNormalizedMessage(fake, concrete.getMessage(IN_MSG)), IN_MSG);
            }
            if (concrete.getMessage(OUT_MSG) != null) {
                fake.setMessage(Convert.convertConcreteToFakeNormalizedMessage(fake, concrete.getMessage(OUT_MSG)), OUT_MSG);
            }
            fake.setOperation(concrete.getOperation());
            if (concrete.getPropertyNames() != null) {
                for (Object property : concrete.getPropertyNames()) {
                    fake.setProperty((String)property, concrete.getProperty((String)property));
                }
            }
            fake.setService(concrete.getService());
            fake.setStatus(concrete.getStatus());
        }
    }

    public static void setFakeValueMEToConcreteValueME(ComponentContext cc, org.objectweb.petals.tools.rmi.common.serializable.MessageExchange fake, MessageExchange concrete) throws MessagingException {
        if (fake.getStatus() == ExchangeStatus.DONE) {
            concrete.setStatus(fake.getStatus());
        } else if (fake.getStatus() == ExchangeStatus.ERROR) {
            concrete.setStatus(fake.getStatus());
            concrete.setError(fake.getError());
        } else {
            if (fake.getEndpoint() != null) {
                concrete.setEndpoint(cc.getEndpoint(fake.getEndpoint().getServiceName(), fake.getEndpoint().getEndpointName()));
            } else {
                concrete.setEndpoint(null);
            }
            if (fake.getError() != null) {
                concrete.setError(fake.getError());
            }
            if (fake.getFault() != null) {
                concrete.setFault((Fault)Convert.convertFakeToConcreteNormalizedMessage(concrete, (NormalizedMessage)fake.getFault()));
            }
            concrete.setInterfaceName(fake.getInterfaceName());
            Convert.convertFakeToConcreteNormalizedMessage(fake, concrete);
            concrete.setOperation(fake.getOperation());
            if (fake.getPropertyNames() != null) {
                for (Object property : fake.getPropertyNames()) {
                    concrete.setProperty((String)property, fake.getProperty((String)property));
                }
            }
            concrete.setService(fake.getService());
            concrete.setStatus(fake.getStatus());
        }
    }

    private static final javax.jbi.messaging.NormalizedMessage convertConcreteToFakeNormalizedMessage(org.objectweb.petals.tools.rmi.common.serializable.MessageExchange fakeME, javax.jbi.messaging.NormalizedMessage concrete) throws MessagingException {
        Object fake = null;
        if (concrete != null) {
            fake = concrete instanceof Fault ? fakeME.createFault() : fakeME.createMessage();
            fake.setContent(concrete.getContent());
            if (concrete.getPropertyNames() != null) {
                for (Object property : concrete.getPropertyNames()) {
                    fake.setProperty((String)property, concrete.getProperty((String)property));
                }
            }
            fake.setSecuritySubject(concrete.getSecuritySubject());
            if (concrete.getAttachmentNames() != null) {
                for (Object attachmentName : concrete.getAttachmentNames()) {
                    fake.addAttachment((String)attachmentName, concrete.getAttachment((String)attachmentName));
                }
            }
        }
        return fake;
    }

    private static final javax.jbi.messaging.NormalizedMessage convertFakeToConcreteNormalizedMessage(MessageExchange concreteME, NormalizedMessage fake) throws MessagingException {
        Object concrete = null;
        if (fake != null) {
            concrete = fake instanceof Fault ? concreteME.createFault() : concreteME.createMessage();
            concrete.setContent(fake.getContent());
            if (fake.getPropertyNames() != null) {
                for (Object property : fake.getPropertyNames()) {
                    concrete.setProperty((String)property, fake.getProperty((String)property));
                }
            }
            concrete.setSecuritySubject(fake.getSecuritySubject());
            if (fake.getAttachmentNames() != null) {
                for (Object attachmentName : fake.getAttachmentNames()) {
                    concrete.addAttachment((String)attachmentName, fake.getAttachment((String)attachmentName));
                }
            }
        }
        return concrete;
    }

    private static final void convertFakeToConcreteNormalizedMessage(org.objectweb.petals.tools.rmi.common.serializable.MessageExchange fake, MessageExchange concrete) throws MessagingException {
        if (fake.getMessage(IN_MSG) != null && concrete.getMessage(IN_MSG) == null) {
            concrete.setMessage(Convert.convertFakeToConcreteNormalizedMessage(concrete, (NormalizedMessage)fake.getMessage(IN_MSG)), IN_MSG);
        }
        if (fake.getMessage(OUT_MSG) != null && concrete.getMessage(OUT_MSG) == null) {
            concrete.setMessage(Convert.convertFakeToConcreteNormalizedMessage(concrete, (NormalizedMessage)fake.getMessage(OUT_MSG)), OUT_MSG);
        }
    }

    private static final MessageExchange createAnEmptyFakeMessage(URI pattern) {
        InOnly fake = null;
        if (pattern != null) {
            if (pattern.equals(IN_ONLY_PATTERN)) {
                fake = new InOnly();
            } else if (pattern.equals(IN_OUT_PATTERN)) {
                fake = new InOut();
            } else if (pattern.equals(IN_OPTIONAL_OUT_PATTERN)) {
                fake = new InOptionalOut();
            } else if (pattern.equals(ROBUST_IN_ONLY_PATTERN)) {
                fake = new RobustInOnly();
            } else if (pattern == null) {
                fake = new org.objectweb.petals.tools.rmi.common.serializable.MessageExchange();
            }
        }
        return fake;
    }
}

