/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.se.rmi;

import java.io.File;
import java.net.MalformedURLException;
import java.rmi.AccessException;
import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.jbi.component.Component;
import javax.jbi.component.ComponentContext;
import javax.jbi.component.ComponentLifeCycle;
import javax.jbi.component.ServiceUnitManager;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.management.ObjectName;
import org.objectweb.petals.tools.rmi.server.remote.implementations.RemoteComponentContextImpl;
import org.objectweb.petals.tools.rmi.server.remote.implementations.RemoteDeliveryChannelImpl;
import org.objectweb.petals.tools.rmi.server.remote.interfaces.RemoteComponentContext;
import org.objectweb.petals.tools.rmi.server.remote.interfaces.RemoteDeliveryChannel;
import org.ow2.petals.se.rmi.registry.Registry;
import org.ow2.petals.se.rmi.registry.RmiProperties;
import org.ow2.petals.se.rmi.registry.RmiPropertiesException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;

public class RmiComponent
implements Component,
ComponentLifeCycle {
    private static final String JBI_DESCRIPTOR_PATH = "META-INF/jbi.xml";
    private Registry rmiServer;
    private RemoteComponentContextImpl rmiComponentContext = null;
    private ComponentContext concreteComponentContext = null;
    private RemoteDeliveryChannel rmiDeliveryChannel = null;
    private DeliveryChannel concreteDeliveryChannel = null;
    private Logger logger;
    private Map<String, MessageExchange> messages;
    private RmiProperties rmiProperties = null;

    public Logger getLogger() {
        return this.logger;
    }

    public Map<String, MessageExchange> getMessages() {
        return this.messages;
    }

    public void start() throws JBIException {
        this.logger.info("Starting RMI Service Engine...");
        this.logger.info(" - RMI Port : " + this.rmiProperties.getRmiPort());
        this.logger.info(" - Embedded : " + this.rmiProperties.isEmbeddedRegistry());
        this.logger.info(" - Component Context Name : " + this.rmiProperties.getComponentContextName());
        try {
            this.rmiServer.registerRMIInterface((RemoteComponentContext)this.rmiComponentContext);
        }
        catch (RemoteException e) {
            this.getLogger().severe(e.getClass().getSimpleName() + " - " + e.getMessage());
            throw new JBIException((Throwable)e);
        }
        catch (MalformedURLException e) {
            this.getLogger().severe(e.getClass().getSimpleName() + " - " + e.getMessage());
            throw new JBIException((Throwable)e);
        }
        catch (AlreadyBoundException e) {
            this.getLogger().severe(e.getClass().getSimpleName() + " - " + e.getMessage());
            throw new JBIException((Throwable)e);
        }
    }

    public RemoteComponentContext getRmiComponentContext() {
        return this.rmiComponentContext;
    }

    public RemoteDeliveryChannel getRmiDeliveryChannel() {
        return this.rmiDeliveryChannel;
    }

    public void stop() throws JBIException {
        this.logger.info("Stopping Service Engine...");
        try {
            this.rmiServer.deregisterRMIInterface();
        }
        catch (RemoteException e) {
            this.getLogger().log(Level.WARNING, e.getMessage(), e);
        }
        catch (MalformedURLException e) {
            this.getLogger().log(Level.SEVERE, e.getMessage(), e);
            throw new JBIException(e.getMessage());
        }
        catch (NotBoundException e) {
            this.getLogger().log(Level.SEVERE, e.getMessage(), e);
            throw new JBIException(e.getMessage());
        }
    }

    public Document getServiceDescription(ServiceEndpoint endpoint) {
        return this.rmiComponentContext.getOwnedEndpointDescriptor(endpoint.getEndpointName());
    }

    public ComponentLifeCycle getLifeCycle() {
        return this;
    }

    public ServiceUnitManager getServiceUnitManager() {
        return null;
    }

    public boolean isExchangeWithConsumerOkay(ServiceEndpoint endpoint, MessageExchange exchange) {
        return true;
    }

    public boolean isExchangeWithProviderOkay(ServiceEndpoint endpoint, MessageExchange exchange) {
        return true;
    }

    public ServiceEndpoint resolveEndpointReference(DocumentFragment epr) {
        return null;
    }

    public ObjectName getExtensionMBeanName() {
        return null;
    }

    public void init(ComponentContext context) throws JBIException {
        this.concreteComponentContext = context;
        this.concreteDeliveryChannel = this.concreteComponentContext.getDeliveryChannel();
        this.logger = this.concreteComponentContext.getLogger("", null);
        if (this.logger == null) {
            throw new JBIException("The logger is null");
        }
        this.logger.log(Level.INFO, "INIT RMI engine");
        File jbiDescriptorFile = new File(this.getContext().getInstallRoot() + File.separator + JBI_DESCRIPTOR_PATH);
        try {
            this.rmiProperties = new RmiProperties(jbiDescriptorFile);
        }
        catch (RmiPropertiesException e) {
            throw new JBIException("Failed to retrieve the RMI properties from the component descriptor file", (Throwable)e);
        }
        try {
            this.messages = new ConcurrentHashMap<String, MessageExchange>();
            this.rmiDeliveryChannel = new RemoteDeliveryChannelImpl(this.getChannel(), this.getContext(), this.getMessages(), this.getLogger());
            this.rmiComponentContext = new RemoteComponentContextImpl(this.getContext(), this.getRmiDeliveryChannel());
            if (this.rmiServer == null) {
                this.rmiServer = new Registry(this.rmiProperties);
            }
            this.rmiServer.initializeRegistry();
        }
        catch (RemoteException e) {
            throw new JBIException("Failed to init RMI component", (Throwable)e);
        }
    }

    public ComponentContext getContext() {
        return this.concreteComponentContext;
    }

    public DeliveryChannel getChannel() {
        return this.concreteDeliveryChannel;
    }

    public void shutDown() throws JBIException {
        try {
            this.messages.clear();
            this.rmiServer.shutDown((RemoteComponentContext)this.rmiComponentContext);
        }
        catch (AccessException e) {
            throw new JBIException("Failed to shutdown RMI registry", (Throwable)e);
        }
        catch (RemoteException e) {
            throw new JBIException("Failed to shutdown RMI registry", (Throwable)e);
        }
        catch (NotBoundException e) {
            throw new JBIException("Failed to shutdown RMI registry", (Throwable)e);
        }
        this.logger.log(Level.INFO, "RMI registry correctly shut down");
    }
}

