/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.petals.tools.rmi.common.serializable;

import com.ebmwebsourcing.easycommons.pooling.PoolException;
import com.ebmwebsourcing.easycommons.xml.Transformers;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.util.ByteArrayDataSource;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class MessageExchangeSerializer {
    protected static final MessageExchangeSerializer instance = new MessageExchangeSerializer();

    private MessageExchangeSerializer() {
    }

    public static MessageExchangeSerializer instance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serializeContent(Source content, ObjectOutputStream s, boolean compress) throws IOException {
        Source source = content;
        synchronized (source) {
            StreamResult sresult = null;
            GZIPOutputStream gz = null;
            if (compress) {
                gz = new GZIPOutputStream(s);
                sresult = new StreamResult(gz);
            } else {
                sresult = new StreamResult(s);
            }
            Transformer transformer = null;
            try {
                transformer = Transformers.takeTransformer();
                transformer.setOutputProperty("omit-xml-declaration", "no");
                transformer.setOutputProperty("method", "xml");
                transformer.transform(content, sresult);
            }
            catch (TransformerException e) {
                throw new IOException(e);
            }
            catch (PoolException e) {
                throw new IOException(e);
            }
            finally {
                if (transformer != null) {
                    Transformers.releaseTransformer((Transformer)transformer);
                }
            }
            if (compress) {
                gz.finish();
            }
        }
    }

    public Source deserializeContent(ObjectInputStream s, boolean compress) throws IOException {
        StreamSource source = new StreamSource();
        InputStream in = s;
        if (compress) {
            in = new GZIPInputStream(s);
        }
        byte[] buff = new byte[1024];
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        int n = 0;
        while (-1 != (n = in.read(buff))) {
            outputStream.write(buff, 0, n);
        }
        ByteArrayInputStream result = new ByteArrayInputStream(outputStream.toByteArray());
        source.setInputStream(result);
        return source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serializeAttachments(Map<String, DataHandler> attachments, ObjectOutputStream s) throws IOException {
        s.writeInt(attachments.size());
        for (Map.Entry<String, DataHandler> attachment : attachments.entrySet()) {
            InputStream binary;
            DataHandler value = attachment.getValue();
            if (value == null || (binary = value.getInputStream()) == null) continue;
            InputStream inputStream = binary;
            synchronized (inputStream) {
                int available = binary.available();
                s.writeUTF(attachment.getKey());
                s.writeUTF(value.getContentType());
                s.writeUTF(value.getName());
                s.writeInt(available);
                byte[] buff = new byte[4097];
                int n = 0;
                while (-1 != (n = binary.read(buff))) {
                    s.write(buff, 0, n);
                    s.flush();
                }
            }
        }
    }

    public Map<String, DataHandler> deserializeAttachments(ObjectInputStream s) throws IOException {
        HashMap<String, DataHandler> attachments = new HashMap<String, DataHandler>();
        int attachmentsCount = s.readInt();
        for (int i = 0; i < attachmentsCount; ++i) {
            String attachmentName = s.readUTF();
            String contentType = s.readUTF();
            String name = s.readUTF();
            int available = s.readInt();
            byte[] content = new byte[available];
            s.readFully(content);
            ByteArrayDataSource dataSource = new ByteArrayDataSource(content, contentType);
            dataSource.setName(name);
            DataHandler dataHandler = new DataHandler((DataSource)dataSource);
            attachments.put(attachmentName, dataHandler);
        }
        return attachments;
    }
}

