/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.petals.tools.rmi.common.serializable;

import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import com.ebmwebsourcing.easycommons.stream.InputStreamForker;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.activation.DataHandler;
import javax.jbi.messaging.MessagingException;
import javax.security.auth.Subject;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.objectweb.petals.tools.rmi.common.serializable.MessageExchangeSerializer;

public class NormalizedMessage
implements javax.jbi.messaging.NormalizedMessage,
Serializable {
    public static final String COMPRESSION = "org.objectweb.petals.transport.compress";
    private static final long serialVersionUID = 1L;
    private transient Map<String, DataHandler> attachments;
    private transient Source content = null;
    private Map<String, Object> properties = new HashMap<String, Object>();
    private Subject subject;
    private transient InputStreamForker forkedInputStreamContent;

    public NormalizedMessage() {
        this.attachments = new HashMap<String, DataHandler>();
    }

    public void addAttachment(String id, DataHandler attachment) throws MessagingException {
        this.attachments.put(id, attachment);
    }

    public DataHandler getAttachment(String id) {
        return this.attachments.get(id);
    }

    public Set<?> getAttachmentNames() {
        return this.attachments.keySet();
    }

    public Source getContent() {
        if (this.content instanceof StreamSource) {
            this.forkedInputStreamContent = new InputStreamForker(((StreamSource)this.content).getInputStream());
            try {
                this.content = new StreamSource(this.forkedInputStreamContent.fork());
            }
            catch (IOException e) {
                throw new UncheckedException((Throwable)e);
            }
        }
        return this.content;
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public Set<?> getPropertyNames() {
        return this.properties.keySet();
    }

    public Subject getSecuritySubject() {
        return this.subject;
    }

    public void removeAttachment(String id) throws MessagingException {
        if (this.attachments.remove(id) == null) {
            throw new MessagingException(id + " attachment does not exist.");
        }
    }

    public void setContent(Source content) throws MessagingException {
        this.content = content;
    }

    public void setProperty(String name, Object value) {
        if (value == null) {
            this.properties.remove(name);
        } else {
            this.properties.put(name, value);
        }
    }

    public void setSecuritySubject(Subject securitySubject) {
        this.subject = securitySubject;
    }

    protected void readObjectDelegate(ObjectInputStream s) throws IOException {
        try {
            s.defaultReadObject();
            this.attachments = MessageExchangeSerializer.instance().deserializeAttachments(s);
            String compression = (String)this.getProperty(COMPRESSION);
            this.content = MessageExchangeSerializer.instance().deserializeContent(s, Boolean.valueOf(compression));
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e.getClass() + ":" + e.getMessage());
        }
    }

    protected void writeObjectDelegate(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        MessageExchangeSerializer.instance().serializeAttachments(this.attachments, s);
        String compression = (String)this.getProperty(COMPRESSION);
        if (this.forkedInputStreamContent != null) {
            InputStream is = this.forkedInputStreamContent.fork();
            this.content = new StreamSource(is);
        }
        MessageExchangeSerializer.instance().serializeContent(this.content, s, Boolean.valueOf(compression));
        if (this.forkedInputStreamContent != null) {
            this.content = new StreamSource(this.forkedInputStreamContent.fork());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException {
        this.readObjectDelegate(s);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        this.writeObjectDelegate(s);
    }
}

