/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.se.rmi.registry;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.ow2.petals.se.rmi.registry.RmiPropertiesException;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class RmiProperties {
    private static final String RMI_SCHEMA_RESSOURCE = "/petalsRMI.xsd";
    private static final String RMI_EXTENSIONS_SCHEMA_RESSOURCE = "/petalsRMIExtensions.xsd";
    private final String NAMESPACE_XSD = "http://www.w3.org/2001/XMLSchema";
    public static final String RMI_HOST = "host";
    public static final String RMI_PORT = "port";
    public static final String RMI_EMBEDDED_REGISTRY = "embeddedregistry";
    public static final String RMI_COMPONENT_CONTEXT_NAME = "componentcontextname";
    public static final String DEFAULT_RMI_HOST = "localhost";
    public static final int DEFAULT_RMI_PORT = 1099;
    public static final boolean DEFAULT_RMI_EMBEDDED_REGISTRY = true;
    public static final String DEFAULT_RMI_COMPONENT_CONTEXT_NAME = "RMIComponentContext";
    private File jbiDescriptor;
    private String rmiHost;
    private int rmiPort;
    private boolean isEmbeddedRegistry;
    private String componentContextName;

    public RmiProperties(File jbiDescriptor) throws RmiPropertiesException {
        this.jbiDescriptor = jbiDescriptor;
        this.rmiHost = DEFAULT_RMI_HOST;
        this.rmiPort = 1099;
        this.isEmbeddedRegistry = true;
        this.componentContextName = DEFAULT_RMI_COMPONENT_CONTEXT_NAME;
        this.parseJbi();
    }

    public String getRmiHost() {
        return this.rmiHost;
    }

    public int getRmiPort() {
        return this.rmiPort;
    }

    public boolean isEmbeddedRegistry() {
        return this.isEmbeddedRegistry;
    }

    public String getComponentContextName() {
        return this.componentContextName;
    }

    private void parseJbi() throws RmiPropertiesException {
        Document rmiDocument = this.getDomDocument();
        NodeList rmiNodeList = rmiDocument.getElementsByTagNameNS("http://petals.ow2.org/extensions/rmi", "rmi");
        NodeList propertiesNodeList = rmiNodeList.item(0).getChildNodes();
        for (int i = 0; i < propertiesNodeList.getLength(); ++i) {
            if (RMI_HOST.equals(propertiesNodeList.item(i).getLocalName())) {
                this.rmiHost = propertiesNodeList.item(i).getTextContent();
                continue;
            }
            if (RMI_PORT.equals(propertiesNodeList.item(i).getLocalName())) {
                this.rmiPort = Integer.valueOf(propertiesNodeList.item(i).getTextContent());
                continue;
            }
            if (RMI_EMBEDDED_REGISTRY.equals(propertiesNodeList.item(i).getLocalName())) {
                this.isEmbeddedRegistry = Boolean.valueOf(propertiesNodeList.item(i).getTextContent());
                continue;
            }
            if (!RMI_COMPONENT_CONTEXT_NAME.equals(propertiesNodeList.item(i).getLocalName())) continue;
            this.componentContextName = propertiesNodeList.item(i).getTextContent();
        }
    }

    private Document getDomDocument() throws RmiPropertiesException {
        Document document = null;
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setNamespaceAware(true);
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            URL schemaURL = this.getClass().getResource(RMI_SCHEMA_RESSOURCE);
            URL schemaExtensionsURL = this.getClass().getResource(RMI_EXTENSIONS_SCHEMA_RESSOURCE);
            Source[] schemas = new Source[]{new StreamSource(schemaExtensionsURL.openStream()), new StreamSource(schemaURL.openStream())};
            Schema rmiSchema = factory.newSchema(schemas);
            docBuilderFactory.setSchema(rmiSchema);
            DocumentBuilder docbuilder = docBuilderFactory.newDocumentBuilder();
            document = docbuilder.parse(this.jbiDescriptor);
        }
        catch (IOException e) {
            throw new RmiPropertiesException(e);
        }
        catch (SAXException e) {
            throw new RmiPropertiesException(e);
        }
        catch (ParserConfigurationException e) {
            throw new RmiPropertiesException(e);
        }
        return document;
    }
}

