/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.logger;

import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class DeprecatedLogger
extends Logger {
    DeprecatedLogger(String name, String resourceBundleName) {
        super(name, resourceBundleName);
    }

    @Override
    public void log(LogRecord record) {
        this.inferCaller(record);
        super.log(record);
    }

    private void inferCaller(LogRecord record) {
        String cname;
        StackTraceElement frame;
        int ix;
        StackTraceElement[] stack = new Throwable().getStackTrace();
        boolean firstJavaLoggerFound = false;
        for (ix = 0; ix < stack.length; ++ix) {
            frame = stack[ix];
            cname = frame.getClassName();
            if (cname.equals(Logger.class.getName())) {
                firstJavaLoggerFound = true;
                continue;
            }
            if (firstJavaLoggerFound) break;
        }
        while (ix < stack.length) {
            frame = stack[ix];
            cname = frame.getClassName();
            if (!cname.equals(DeprecatedLogger.class.getName())) {
                record.setSourceClassName(cname);
                record.setSourceMethodName(frame.getMethodName());
                return;
            }
            ++ix;
        }
    }
}

