/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.logger;

import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.IllegalFormatException;
import java.util.Locale;
import java.util.logging.LogRecord;
import org.w3c.dom.Node;

public class Formatter
extends java.util.logging.Formatter {
    private static final int INDENT_LEVEL = 2;
    private static final String INDENT_STRING = Formatter.createIndentString(2, ' ');
    private final DateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS", Locale.getDefault());

    private static final String createIndentString(int indentLevel, char indentChar) {
        String indentString = "";
        for (int i = 0; i < indentLevel; ++i) {
            indentString = indentString + indentChar;
        }
        return indentString;
    }

    private final String simplifySourceClassName(String sourceClassName) {
        return sourceClassName.replaceAll("com.ebmwebsourcing.", "").replaceAll("org.ow2.", "");
    }

    private final String indent(String s) {
        return s.replaceAll("\r?\n", "\n" + INDENT_STRING).trim();
    }

    private final Object formatMessageParameter(Object obj) {
        String res = "";
        res = obj instanceof Node ? res + XMLPrettyPrinter.prettyPrint((Node)obj) : res + obj;
        return res.trim();
    }

    private final int getFormatSpecifiersCount(String formatString) {
        int nbOccurences = 0;
        int currentIndex = -1;
        while ((currentIndex = formatString.indexOf(37, currentIndex + 1)) != -1) {
            ++nbOccurences;
        }
        return nbOccurences;
    }

    private final void formatMessageWithParametersUsingSprintfSyntax(StringBuffer sb, String message, Object[] parameters) {
        try {
            sb.append(String.format(message, parameters));
        }
        catch (IllegalFormatException ife) {
            this.formatMessageWithParametersUsingFallbackSyntax(sb, message, parameters);
        }
    }

    private final void formatMessageWithParametersUsingFallbackSyntax(StringBuffer sb, String message, Object[] parameters) {
        sb.append(message);
        if (parameters.length > 0) {
            sb.append(" : ");
            for (Object parameter : parameters) {
                sb.append("\n").append(this.formatMessageParameter(parameter));
            }
            sb.append("\n");
        }
    }

    private final void formatMessageWithParameters(StringBuffer sb, LogRecord logRecord) {
        Object[] parameters = logRecord.getParameters();
        if (parameters == null) {
            parameters = new Object[]{};
        }
        for (int i = 0; i < parameters.length; ++i) {
            parameters[i] = this.formatMessageParameter(parameters[i]);
        }
        String message = logRecord.getMessage();
        if (this.getFormatSpecifiersCount(message) == parameters.length) {
            this.formatMessageWithParametersUsingSprintfSyntax(sb, message, parameters);
        } else {
            this.formatMessageWithParametersUsingFallbackSyntax(sb, message, parameters);
        }
        if (logRecord.getSourceClassName() != null) {
            if (sb.charAt(sb.length() - 1) != '\n') {
                sb.append(INDENT_STRING);
            }
            sb.append("(").append(this.simplifySourceClassName(logRecord.getSourceClassName())).append(")");
            sb.append(" [").append(Thread.currentThread().getName()).append("]");
        }
        sb.append("\n");
    }

    protected Date getLogTime(LogRecord logRecord) {
        return new Date(logRecord.getMillis());
    }

    @Override
    public final String format(LogRecord record) {
        StringBuffer sb = new StringBuffer(this.dateFormat.format(this.getLogTime(record)));
        sb.append(" - ").append(record.getLevel()).append(" : ");
        this.formatMessageWithParameters(sb, record);
        if (record.getThrown() != null) {
            sb.append("Caused by ").append(record.getThrown().getClass()).append(" : ");
            sb.append(record.getThrown().toString()).append("\n");
            for (StackTraceElement ste : record.getThrown().getStackTrace()) {
                sb.append("  ").append(ste.toString()).append("\n");
            }
        }
        return this.indent(sb.toString()) + "\n";
    }
}

