/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.se.validation;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.messaging.MessagingException;
import javax.xml.namespace.QName;
import org.ow2.petals.commons.exception.ExceptionUtil;
import org.ow2.petals.component.framework.api.Message;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.listener.AbstractJBIListener;
import org.ow2.petals.se.validation.ValidationSe;
import org.ow2.petals.se.validation.model.ValidationConfigurationHandler;
import org.ow2.petals.se.validation.service.ValidationService;

public class ValidationJBIListener
extends AbstractJBIListener {
    private static final String VALIDATE_OPERATION = "validate";
    private static final String FILTER_OPERATION = "filter";
    private String logHint;
    private ValidationService validationService;

    public void init() {
        this.validationService = new ValidationService(this.getLogger());
    }

    public boolean onJBIMessage(Exchange exchange) {
        block11: {
            Logger log = this.getLogger();
            this.logHint = "Exchange " + exchange.getExchangeId();
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.logHint + " was received and is started to be processed.");
            }
            if (!this.validateExchange(exchange)) {
                if (log.isLoggable(Level.WARNING)) {
                    log.warning(this.logHint + " encountered a problem. " + exchange.getError().getMessage());
                }
            } else {
                try {
                    this.processExchange(exchange);
                    if (log.isLoggable(Level.FINE)) {
                        log.fine(this.logHint + " was successfully processed.");
                    }
                }
                catch (PEtALSCDKException e) {
                    if (log.isLoggable(Level.WARNING)) {
                        log.warning(this.logHint + " encountered a problem. " + e.getMessage());
                    }
                    if (exchange.isActiveStatus()) {
                        MessagingException exception = new MessagingException(ExceptionUtil.getExtendedMessage((Exception)((Object)e)));
                        exchange.setError((Exception)((Object)exception));
                    }
                }
                catch (MessagingException e) {
                    if (log.isLoggable(Level.WARNING)) {
                        log.warning(this.logHint + " encountered a problem. " + e.getMessage());
                    }
                    if (!exchange.isActiveStatus()) break block11;
                    exchange.setError((Exception)((Object)e));
                }
            }
        }
        return true;
    }

    private boolean validateExchange(Exchange exchange) {
        boolean result = true;
        QName operation = exchange.getOperation();
        if (operation == null) {
            exchange.setError(new Exception("The JBI operation must be set by the consumer of the service."));
            result = false;
        } else if (VALIDATE_OPERATION.equals(operation.getLocalPart().toLowerCase())) {
            if (!Message.MEPConstants.IN_OUT_PATTERN.equals(exchange.getPattern())) {
                String msg = "The operation '" + operation + "' must use the pattern 'InOut'.";
                exchange.setError(new Exception(msg));
                result = false;
            }
        } else if (FILTER_OPERATION.equals(operation.getLocalPart().toLowerCase())) {
            if (!Message.MEPConstants.IN_OUT_PATTERN.equals(exchange.getPattern())) {
                String msg = "The operation '" + operation + "' must use the pattern 'InOut'.";
                exchange.setError(new Exception(msg));
                result = false;
            }
        } else {
            String msg = "The operation '" + operation + "' is not supported by this component.";
            exchange.setError(new Exception(msg));
            result = false;
        }
        return result;
    }

    private void processExchange(Exchange exchange) throws MessagingException, PEtALSCDKException {
        ValidationConfigurationHandler handler;
        Logger log = this.getLogger();
        if (log.isLoggable(Level.FINE)) {
            log.fine(this.logHint + ": the request was validated, the transformation is about to start.");
        }
        if ((handler = ((ValidationSe)this.component).getValidationConfigurationHandler(exchange.getEndpointName())) == null) {
            String msg = this.logHint + " encountered a problem. No handler was found for this end-point.";
            if (log.isLoggable(Level.SEVERE)) {
                log.severe(msg);
            }
            throw new PEtALSCDKException(msg);
        }
        String opName = exchange.getOperation().getLocalPart().toLowerCase();
        if (VALIDATE_OPERATION.equals(opName)) {
            this.validationService.validate(exchange, handler.getSchema());
        } else {
            this.validationService.filter(exchange, handler.getSchema());
        }
    }
}

