/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.se.validation.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.se.validation.model.ValidationConfiguration;
import org.ow2.petals.se.validation.util.XsdResourceResolver;
import org.xml.sax.SAXException;

public class ValidationConfigurationHandler {
    private final ValidationConfiguration validationConfiguration;
    private Schema schema;
    private final Object lock = new Object();

    public ValidationConfigurationHandler(ValidationConfiguration validationConfiguration, Logger logger) {
        this.validationConfiguration = validationConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Logger logger) throws PEtALSCDKException {
        Object object = this.lock;
        synchronized (object) {
            String suRoot = this.validationConfiguration.getSuInstallRoot();
            String logPrefix = this.validationConfiguration.getServiceUnitName();
            InputStream xsdInputStream = null;
            try {
                File xsdFile = new File(suRoot, this.validationConfiguration.getXsdPath());
                xsdInputStream = new FileInputStream(xsdFile);
                StreamSource source = new StreamSource(xsdInputStream);
                SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                XsdResourceResolver resolver = new XsdResourceResolver(suRoot, logger);
                schemaFactory.setResourceResolver(resolver);
                this.schema = schemaFactory.newSchema(source);
            }
            catch (FileNotFoundException e) {
                throw new PEtALSCDKException(logPrefix + ": failed to retrieve the XSD resources.", (Throwable)e);
            }
            catch (SAXException e) {
                throw new PEtALSCDKException(logPrefix + ": failed to create to a schema instance.", (Throwable)e);
            }
            finally {
                block15: {
                    if (xsdInputStream != null) {
                        try {
                            xsdInputStream.close();
                        }
                        catch (IOException e) {
                            if (!logger.isLoggable(Level.WARNING)) break block15;
                            logger.warning(logPrefix + ": the XSD input stream could not be closed. Error discarded.");
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            this.schema = null;
        }
    }

    public Schema getSchema() {
        return this.schema;
    }

    public String getEndpointName() {
        return this.validationConfiguration.getEndpointName();
    }
}

