/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.se.validation;

import com.ebmwebsourcing.easycommons.lang.StringHelper;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.ow2.petals.component.framework.AbstractComponent;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.jbidescriptor.generated.Jbi;
import org.ow2.petals.component.framework.jbidescriptor.generated.Provides;
import org.ow2.petals.component.framework.su.AbstractServiceUnitManager;
import org.ow2.petals.component.framework.su.ServiceUnitDataHandler;
import org.ow2.petals.se.validation.ValidationSe;
import org.ow2.petals.se.validation.model.ValidationConfiguration;
import org.ow2.petals.se.validation.model.ValidationConfigurationHandler;

public class ValidationSuManager
extends AbstractServiceUnitManager {
    private static final String XSD_PATH = "schema";
    private final Map<String, ValidationConfigurationHandler> suNameToValidationConfigurationHandler = new ConcurrentHashMap<String, ValidationConfigurationHandler>();

    public ValidationSuManager(AbstractComponent component) {
        super(component);
    }

    protected void doDeploy(String serviceUnitName, String suRootPath, Jbi jbiDescriptor) throws PEtALSCDKException {
        if (jbiDescriptor.getServices().getConsumes() != null && jbiDescriptor.getServices().getConsumes().size() != 0) {
            throw new PEtALSCDKException("'Consumes' sections are not supported by this component.");
        }
        List providesList = jbiDescriptor.getServices().getProvides();
        if (providesList == null || providesList.size() != 1) {
            throw new PEtALSCDKException("Only one 'Provides' section is allowed by this component.");
        }
        Provides provides = (Provides)providesList.get(0);
        ServiceUnitDataHandler suDatahandler = this.getSUDataHandlerForService(provides);
        ConfigurationExtensions extensions = suDatahandler.getConfigurationExtensions((Object)provides);
        String schemaFileName = extensions.get((Object)XSD_PATH);
        if (StringHelper.isNullOrEmpty((String)schemaFileName)) {
            throw new PEtALSCDKException("A configuration for this component must define the  'schema' parameter.");
        }
        ValidationConfiguration config = new ValidationConfiguration(schemaFileName.trim(), suRootPath, provides.getEndpointName(), serviceUnitName);
        ValidationConfigurationHandler handler = new ValidationConfigurationHandler(config, this.logger);
        this.suNameToValidationConfigurationHandler.put(serviceUnitName, handler);
        ((ValidationSe)this.component).registerValidationConfigurationHandler(provides.getEndpointName(), handler);
    }

    protected void doStart(String serviceUnitName) throws PEtALSCDKException {
        ValidationConfigurationHandler handler = this.suNameToValidationConfigurationHandler.get(serviceUnitName);
        if (handler == null) {
            throw new PEtALSCDKException("No configuration handler was found for the service-unit " + serviceUnitName + " (start).");
        }
        handler.start(this.logger);
    }

    protected void doStop(String serviceUnitName) throws PEtALSCDKException {
        ValidationConfigurationHandler handler = this.suNameToValidationConfigurationHandler.get(serviceUnitName);
        if (handler == null) {
            throw new PEtALSCDKException("No configuration handler was found for the service-unit " + serviceUnitName + " (stop).");
        }
        handler.stop();
    }

    protected void doUndeploy(String serviceUnitName) throws PEtALSCDKException {
        ValidationConfigurationHandler handler = this.suNameToValidationConfigurationHandler.remove(serviceUnitName);
        ((ValidationSe)this.component).removeValidationConfigurationHandler(handler.getEndpointName());
    }
}

