/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.se.validation.service;

import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import com.ebmwebsourcing.easycommons.stream.InputStreamForker;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.MessagingException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.util.SourceUtil;
import org.xml.sax.SAXException;

public class ValidationService {
    private final Logger logger;

    public ValidationService(Logger logger) {
        this.logger = logger;
    }

    public void filter(Exchange exchange, Schema xsdSchema) throws MessagingException, PEtALSCDKException {
        Source responseSource = null;
        String logHint = "Exchange " + exchange.getExchangeId();
        Source source = exchange.getInMessageContentAsSource();
        if (source instanceof StreamSource) {
            InputStreamForker messageAsStream = new InputStreamForker(((StreamSource)source).getInputStream());
            try {
                source = new StreamSource(messageAsStream.fork());
                responseSource = new StreamSource(messageAsStream.fork());
            }
            catch (IOException e) {
                throw new UncheckedException((Throwable)e);
            }
        } else {
            responseSource = source;
        }
        try {
            xsdSchema.newValidator().validate(source);
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine(logHint + ": the XML message is valid.");
            }
            exchange.setOutMessageContent(responseSource);
        }
        catch (SAXException e) {
            if (this.logger.isLoggable(Level.WARNING)) {
                this.logger.warning(logHint + ": the XML message is invalid. " + e.getMessage());
            }
            this.setFilterFault(exchange, e.getMessage());
        }
        catch (IOException e) {
            if (this.logger.isLoggable(Level.WARNING)) {
                this.logger.warning(logHint + ": the XML message is invalid. " + e.getMessage());
            }
            this.setFilterFault(exchange, e.getMessage());
        }
    }

    private void setFilterFault(Exchange exchange, String errorMessage) throws MessagingException, PEtALSCDKException {
        StringBuffer faultMessage = new StringBuffer();
        faultMessage.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        faultMessage.append("<validationFault xmlns='");
        faultMessage.append(exchange.getOperation().getNamespaceURI());
        faultMessage.append("'>");
        faultMessage.append("<message>");
        faultMessage.append(errorMessage);
        faultMessage.append("</message></validationFault>");
        Fault fault = exchange.createFault();
        Source source = SourceUtil.createSource((String)faultMessage.toString(), (String)"UTF-8");
        fault.setContent(source);
        exchange.setFault(fault);
    }

    public void validate(Exchange exchange, Schema xsdSchema) throws MessagingException, PEtALSCDKException {
        String logHint = "Exchange " + exchange.getExchangeId();
        Source inContent = exchange.getInMessageContentAsSource();
        try {
            xsdSchema.newValidator().validate(inContent);
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine(logHint + ": the XML message is valid.");
            }
            this.setValidateResponseOk(exchange);
        }
        catch (SAXException e) {
            if (this.logger.isLoggable(Level.WARNING)) {
                this.logger.warning(logHint + ": the XML message is invalid. " + e.getMessage());
            }
            this.setValidateResponseKo(exchange, e.getMessage());
        }
        catch (IOException e) {
            if (this.logger.isLoggable(Level.WARNING)) {
                this.logger.warning(logHint + ": the XML message is invalid. " + e.getMessage());
            }
            this.setValidateResponseKo(exchange, e.getMessage());
        }
    }

    private void setValidateResponseKo(Exchange exchange, String errorMessage) throws MessagingException, PEtALSCDKException {
        StringBuffer responseMessage = new StringBuffer();
        responseMessage.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?><tns:validateResponse xmlns:tns='");
        responseMessage.append(exchange.getOperation().getNamespaceURI());
        responseMessage.append("'><tns:valid>false</tns:valid><tns:comment>");
        responseMessage.append(errorMessage);
        responseMessage.append("</tns:comment></tns:validateResponse>");
        Source source = SourceUtil.createSource((String)responseMessage.toString(), (String)"UTF-8");
        exchange.setOutMessageContent(source);
    }

    private void setValidateResponseOk(Exchange exchange) throws MessagingException, PEtALSCDKException {
        StringBuffer responseMessage = new StringBuffer();
        responseMessage.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?><tns:validateResponse xmlns:tns='");
        responseMessage.append(exchange.getOperation().getNamespaceURI());
        responseMessage.append("'><tns:valid>true</tns:valid></tns:validateResponse>");
        Source source = SourceUtil.createSource((String)responseMessage.toString(), (String)"UTF-8");
        exchange.setOutMessageContent(source);
    }
}

