/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.api.util;

import com.ebmwebsourcing.easycommons.io.IOHelper;
import com.ebmwebsourcing.easycommons.properties.PropertiesException;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;

public class PropertiesUtil {
    public static final Properties loadProperties(String propertiesFilePath) throws PropertiesException {
        Properties properties = new Properties();
        if (propertiesFilePath != null) {
            InputStream propFileStream = null;
            try {
                propFileStream = PropertiesUtil.loadPropertiesFileFromUrl(new URL(propertiesFilePath));
            }
            catch (MalformedURLException e) {
                propFileStream = PropertiesUtil.loadPropertiesFileFromRelativePath(propertiesFilePath);
            }
            if (propFileStream != null) {
                try {
                    properties.load(propFileStream);
                }
                catch (IOException e) {
                    String message = String.format("Cannot find properties at location : %s", propertiesFilePath);
                    throw new PropertiesException(message);
                }
                finally {
                    IOHelper.close((Closeable)propFileStream);
                }
            } else {
                String message = String.format("Cannot find properties at location : %s", propertiesFilePath);
                throw new PropertiesException(message);
            }
        }
        return properties;
    }

    private static final InputStream loadPropertiesFileFromRelativePath(String propertiesFilePath) throws PropertiesException {
        FileInputStream is = null;
        String petalsHome = System.getenv("PETALS_HOME");
        if (petalsHome != null) {
            File propFile = new File(petalsHome, propertiesFilePath);
            try {
                is = new FileInputStream(propFile);
            }
            catch (FileNotFoundException fnfe) {
                String message = String.format("Cannot load properties from the file %s", propertiesFilePath);
                throw new PropertiesException(message, (Throwable)fnfe);
            }
        } else {
            throw new PropertiesException("PETALS_HOME is not defined");
        }
        return is;
    }

    private static final InputStream loadPropertiesFileFromUrl(URL url) throws PropertiesException {
        InputStream is = null;
        try {
            URLConnection connection = url.openConnection();
            is = connection.getInputStream();
        }
        catch (IOException ioe) {
            String message = String.format("Cannot load properties from URL %s", url);
            throw new PropertiesException(message, (Throwable)ioe);
        }
        return is;
    }
}

