/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.se.validation.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.petals.se.validation.util.LSInputImpl;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

public class XsdResourceResolver
implements LSResourceResolver {
    private String resourcesBase = "";
    private final Logger logger;

    public XsdResourceResolver(String resourcesBase, Logger logger) {
        this.logger = logger;
        this.resourcesBase = resourcesBase;
        logger.finest("XSD imports will be searched in " + resourcesBase);
    }

    @Override
    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        LSInputImpl resource = new LSInputImpl();
        try {
            this.logger.finest("load XSD import " + this.resourcesBase + systemId);
            resource.setByteStream(new FileInputStream(new File(this.resourcesBase, systemId)));
        }
        catch (FileNotFoundException fnfe) {
            this.logger.log(Level.SEVERE, "can not load XSD import " + fnfe.getMessage(), fnfe);
        }
        return resource;
    }
}

