/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.stream;

import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public abstract class DumbExecutor {
    private final ByteArrayOutputStream stdOutCapture = new ByteArrayOutputStream();
    private final ByteArrayOutputStream stdErrCapture = new ByteArrayOutputStream();
    private Throwable capturedThrowable;

    protected abstract void doRun() throws Throwable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        Class<DumbExecutor> clazz = DumbExecutor.class;
        synchronized (DumbExecutor.class) {
            PrintStream originalStdOut = System.out;
            PrintStream originalStdErr = System.err;
            PrintStream stdOutCapturePrintStream = new PrintStream(new ThreadSpecificCapturingStream(originalStdOut, this.stdOutCapture));
            PrintStream stdErrCapturePrintStream = new PrintStream(new ThreadSpecificCapturingStream(originalStdErr, this.stdErrCapture));
            System.setOut(stdOutCapturePrintStream);
            System.setErr(stdErrCapturePrintStream);
            try {
                this.doRun();
            }
            catch (Throwable t) {
                this.capturedThrowable = t;
            }
            System.setOut(originalStdOut);
            System.setErr(originalStdErr);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public final String getCapturedStdOut() {
        return this.stdOutCapture.toString();
    }

    public String getCapturedStdErr() {
        return this.stdErrCapture.toString();
    }

    public Throwable getCapturedThrowable() {
        return this.capturedThrowable;
    }

    private static final class ThreadSpecificCapturingStream
    extends FilterOutputStream {
        private final Thread capturingThread = Thread.currentThread();
        private final OutputStream capturingOutputStream;

        public ThreadSpecificCapturingStream(OutputStream capturedOutputStream, OutputStream capturingOutputStream) {
            super(capturedOutputStream);
            this.capturingOutputStream = capturingOutputStream;
        }

        @Override
        public void write(int b) throws IOException {
            if (Thread.currentThread() != this.capturingThread) {
                super.write(b);
            } else {
                this.capturingOutputStream.write(b);
            }
        }
    }
}

