/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.se.xslt.model;

import javax.xml.transform.TransformerFactory;
import org.apache.xalan.processor.TransformerFactoryImpl;
import org.junit.Assert;
import org.junit.Test;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.se.xslt.model.XsltConfigurationHandler;

public class XsltConfigurationHandlerTest {
    @Test
    public void testCreateTransformerFactoryOKWithTransformerFactoryEqualsToNull() throws Exception {
        TransformerFactory transformerFactory = XsltConfigurationHandler.createTransformerFactory((String)"logPrefix", null);
        Class<?> transformerFactoryClass = transformerFactory.getClass();
        Class<?> defaultTransformerFactoryClass = TransformerFactory.newInstance().getClass();
        Assert.assertEquals(transformerFactoryClass, defaultTransformerFactoryClass);
    }

    @Test
    public void testCreateTransformerFactoryOKWithXalanTransformerFactory() throws Exception {
        TransformerFactory transformerFactory = XsltConfigurationHandler.createTransformerFactory((String)"logPrefix", (String)"org.apache.xalan.processor.TransformerFactoryImpl");
        Assert.assertTrue((boolean)(transformerFactory instanceof TransformerFactoryImpl));
    }

    @Test(expected=PEtALSCDKException.class)
    public void testCreateTransformerFactoryKOBecauseOfWrongClass() throws Exception {
        XsltConfigurationHandler.createTransformerFactory((String)"logPrefix", (String)"org.junit.Test");
    }

    @Test(expected=PEtALSCDKException.class)
    public void testCreateTransformerFactoryKOIllegalAccessException() throws Exception {
        XsltConfigurationHandler.createTransformerFactory((String)"logPrefix", (String)"javax.xml.transform.Transformer");
    }

    @Test(expected=PEtALSCDKException.class)
    public void testCreateTransformerFactoryKOBecauseOfUnexistingClass() throws Exception {
        XsltConfigurationHandler.createTransformerFactory((String)"logPrefix", (String)"org.apache.xalan.processor.TranformerFactoryImpl");
    }
}

