/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easywsdl.wsdl.util;

import com.sun.xml.bind.marshaller.NamespacePrefixMapper;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class CustomPrefixMapper
extends NamespacePrefixMapper {
    public Map<String, String> predefinedNamespaces = new HashMap<String, String>();

    public CustomPrefixMapper() {
    }

    public CustomPrefixMapper(String[] customNamespaces) {
        try {
            for (int i = 0; i < customNamespaces.length; ++i) {
                String prefix = customNamespaces[i++];
                String namespace = customNamespaces[i];
                this.predefinedNamespaces.put(namespace, prefix);
            }
        }
        catch (Exception e) {
            System.out.println("Error while initialising custom namespaces. Using default namespaces.");
            this.predefinedNamespaces.clear();
        }
    }

    public String getPreferredPrefix(String namespaceUri, String suggestion, boolean requirePrefix) {
        if (namespaceUri.equals("http://schemas.xmlsoap.org/wsdl/")) {
            return "w";
        }
        if (namespaceUri.equals("http://schemas.xmlsoap.org/wsdl/soap12/")) {
            return "soap12";
        }
        if (namespaceUri.equals("http://schemas.xmlsoap.org/wsdl/soap/")) {
            return "soap";
        }
        if (namespaceUri.equals("http://schemas.xmlsoap.org/wsdl/http/")) {
            return "http";
        }
        if (namespaceUri.equals("http://schemas.xmlsoap.org/wsdl/mime/")) {
            return "mime";
        }
        if (namespaceUri.equals("http://www.w3.org/2001/XMLSchema")) {
            return "xs";
        }
        if (this.predefinedNamespaces.containsKey(namespaceUri)) {
            return this.predefinedNamespaces.get(namespaceUri);
        }
        return suggestion;
    }

    public String[] getPreDeclaredNamespaceUris() {
        String[] custNS = new String[this.predefinedNamespaces.size() * 2];
        Iterator<String> it = this.predefinedNamespaces.keySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            String ns = it.next();
            String prefix = this.predefinedNamespaces.get(ns);
            custNS[i++] = prefix;
            custNS[i++] = ns;
        }
        return custNS;
    }
}

